/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import com.nimbusds.jose.Algorithm;
import java.util.Objects;
import se.swedenconnect.security.algorithms.EncryptionAlgorithm;
import se.swedenconnect.security.algorithms.impl.AbstractKeyBasedAlgorithm;
import se.swedenconnect.security.algorithms.impl.AlgorithmBuilder;

public abstract class AbstractEncryptionAlgorithm
extends AbstractKeyBasedAlgorithm
implements EncryptionAlgorithm {
    private int keyLength;

    public AbstractEncryptionAlgorithm(String uri, int order, String keyType, int keyLength, String jcaName, Algorithm joseAlgorithm) {
        super(uri, order, keyType, jcaName, joseAlgorithm);
        this.setKeyLength(keyLength);
    }

    protected AbstractEncryptionAlgorithm(String uri) {
        super(uri);
    }

    @Override
    public int getKeyLength() {
        return this.keyLength;
    }

    protected void setKeyLength(int keyLength) {
        this.keyLength = keyLength;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.keyLength);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractEncryptionAlgorithm)) {
            return false;
        }
        AbstractEncryptionAlgorithm other = (AbstractEncryptionAlgorithm)obj;
        return this.keyLength == other.keyLength;
    }

    @Override
    public String toString() {
        return String.format("%s, key-length='%d'", super.toString(), this.keyLength);
    }

    protected static abstract class AbstractEncryptionAlgorithmBuilder<T extends AbstractEncryptionAlgorithm, B extends AbstractEncryptionAlgorithmBuilder<T, ? extends AlgorithmBuilder<T>>>
    extends AbstractKeyBasedAlgorithm.AbstractKeyBasedAlgorithmBuilder<T, B> {
        public AbstractEncryptionAlgorithmBuilder(String algorithmUri) {
            super(algorithmUri);
        }

        public B keyLength(int keyLength) {
            ((AbstractEncryptionAlgorithm)this.getAlgorithm()).setKeyLength(keyLength);
            return (B)((AbstractEncryptionAlgorithmBuilder)this.getBuilder());
        }
    }
}

