/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import com.nimbusds.jose.Algorithm;
import java.util.Objects;
import java.util.Optional;
import se.swedenconnect.security.algorithms.JoseAlgorithm;
import se.swedenconnect.security.algorithms.impl.AbstractAlgorithm;
import se.swedenconnect.security.algorithms.impl.AlgorithmBuilder;

public abstract class AbstractJoseAlgorithm
extends AbstractAlgorithm
implements JoseAlgorithm {
    private Algorithm joseAlgorithm;

    public AbstractJoseAlgorithm(String uri, int order, String jcaName, Algorithm joseAlgorithm) {
        super(uri, order, jcaName);
        this.setJoseAlgorithm(joseAlgorithm);
    }

    protected AbstractJoseAlgorithm(String uri) {
        super(uri);
    }

    @Override
    public Algorithm getJoseAlgorithm() {
        return this.joseAlgorithm;
    }

    protected void setJoseAlgorithm(Algorithm joseAlgorithm) {
        this.joseAlgorithm = joseAlgorithm;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.joseAlgorithm);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractJoseAlgorithm)) {
            return false;
        }
        AbstractJoseAlgorithm other = (AbstractJoseAlgorithm)obj;
        return Objects.equals(this.joseAlgorithm, other.joseAlgorithm);
    }

    @Override
    public String toString() {
        return String.format("%s, jose-algorithm='%s'", super.toString(), Optional.ofNullable(this.joseAlgorithm).map(Algorithm::toString).orElse("-"));
    }

    protected static abstract class AbstractJoseAlgorithmBuilder<T extends AbstractJoseAlgorithm, B extends AbstractJoseAlgorithmBuilder<T, ? extends AlgorithmBuilder<T>>>
    extends AbstractAlgorithm.AbstractAlgorithmBuilder<T, B> {
        public AbstractJoseAlgorithmBuilder(String algorithmUri) {
            super(algorithmUri);
        }

        public B joseAlgorithm(Algorithm joseAlgorithm) {
            ((AbstractJoseAlgorithm)this.getAlgorithm()).setJoseAlgorithm(joseAlgorithm);
            return (B)((AbstractJoseAlgorithmBuilder)this.getBuilder());
        }
    }
}

