/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import com.nimbusds.jose.Algorithm;
import java.util.Objects;
import se.swedenconnect.security.algorithms.KeyBasedAlgorithm;
import se.swedenconnect.security.algorithms.impl.AbstractJoseAlgorithm;
import se.swedenconnect.security.algorithms.impl.AlgorithmBuilder;

public abstract class AbstractKeyBasedAlgorithm
extends AbstractJoseAlgorithm
implements KeyBasedAlgorithm {
    private String keyType;

    public AbstractKeyBasedAlgorithm(String uri, int order, String keyType, String jcaName, Algorithm joseAlgorithm) {
        super(uri, order, jcaName, joseAlgorithm);
        this.setKeyType(keyType);
    }

    protected AbstractKeyBasedAlgorithm(String uri) {
        super(uri);
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    protected void setKeyType(String keyType) {
        this.keyType = Objects.requireNonNull(keyType, "keyType must be set");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.keyType);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractKeyBasedAlgorithm)) {
            return false;
        }
        AbstractKeyBasedAlgorithm other = (AbstractKeyBasedAlgorithm)obj;
        return Objects.equals(this.keyType, other.keyType);
    }

    @Override
    public String toString() {
        return String.format("%s, key-type='%s'", super.toString(), this.keyType);
    }

    protected static abstract class AbstractKeyBasedAlgorithmBuilder<T extends AbstractKeyBasedAlgorithm, B extends AbstractKeyBasedAlgorithmBuilder<T, ? extends AlgorithmBuilder<T>>>
    extends AbstractJoseAlgorithm.AbstractJoseAlgorithmBuilder<T, B> {
        public AbstractKeyBasedAlgorithmBuilder(String algorithmUri) {
            super(algorithmUri);
        }

        public B keyType(String keyType) {
            ((AbstractKeyBasedAlgorithm)this.getAlgorithm()).setKeyType(keyType);
            return (B)((AbstractKeyBasedAlgorithmBuilder)this.getBuilder());
        }

        @Override
        protected void assertCorrect() throws IllegalArgumentException {
            super.assertCorrect();
            if (((AbstractKeyBasedAlgorithm)this.getAlgorithm()).getKeyType() == null) {
                throw new IllegalArgumentException("keyType must be set");
            }
        }
    }
}

