/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.security.algorithms.Algorithm;
import se.swedenconnect.security.algorithms.AlgorithmRegistry;

public class AlgorithmRegistryImpl
implements AlgorithmRegistry {
    private static final Logger log = LoggerFactory.getLogger(AlgorithmRegistryImpl.class);
    private final Map<String, Algorithm> registry = new ConcurrentHashMap<String, Algorithm>();

    public AlgorithmRegistryImpl() {
    }

    public AlgorithmRegistryImpl(List<Algorithm> registry) {
        this();
        if (registry != null) {
            registry.forEach(a -> this.register((Algorithm)a));
        }
    }

    public void register(Algorithm algorithm) {
        log.debug("Registering algorithm: {}", (Object)algorithm);
        if (algorithm.getUri() == null) {
            throw new IllegalArgumentException("Invalid algorithm - missing URI");
        }
        this.registry.put(algorithm.getUri(), algorithm);
    }

    public void unregister(String algorithmUri) {
        Algorithm alg = this.registry.remove(algorithmUri);
        if (alg != null) {
            log.debug("Algorithm '{}' was removed from the registry", (Object)algorithmUri);
        }
    }

    @Override
    public Algorithm getAlgorithm(String algorithmUri) {
        return this.registry.get(algorithmUri);
    }

    @Override
    public <T extends Algorithm> T getAlgorithm(String algorithmUri, Class<T> clazz) {
        try {
            return (T)((Algorithm)clazz.cast(this.getAlgorithm(algorithmUri)));
        }
        catch (ClassCastException e) {
            log.info("The algorithm '{}' is not of type '{}'", (Object)algorithmUri, (Object)clazz.getSimpleName());
            return null;
        }
    }

    @Override
    public <T extends Algorithm> T getAlgorithm(Predicate<Algorithm> predicate, Class<T> clazz) {
        return (T)((Algorithm)this.registry.values().stream().filter(a -> clazz.isInstance(a)).map(a -> (Algorithm)clazz.cast(a)).filter(predicate).min(Comparator.comparing(Algorithm::getOrder)).orElse(null));
    }

    @Override
    public Algorithm getAlgorithm(Predicate<Algorithm> predicate) {
        return this.registry.values().stream().filter(predicate).min(Comparator.comparing(Algorithm::getOrder)).orElse(null);
    }

    @Override
    public List<Algorithm> getAlgorithms(Predicate<Algorithm> predicate) {
        return this.registry.values().stream().filter(predicate).sorted((a1, a2) -> Integer.compare(a1.getOrder(), a2.getOrder())).collect(Collectors.toList());
    }

    @Override
    public <T extends Algorithm> List<T> getAlgorithms(Predicate<Algorithm> predicate, Class<T> clazz) {
        return this.registry.values().stream().filter(a -> clazz.isInstance(a)).map(a -> (Algorithm)clazz.cast(a)).filter(predicate).sorted((a1, a2) -> Integer.compare(a1.getOrder(), a2.getOrder())).collect(Collectors.toList());
    }
}

