/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import com.nimbusds.jose.Algorithm;
import java.util.Objects;
import se.swedenconnect.security.algorithms.BlockEncryptionAlgorithm;
import se.swedenconnect.security.algorithms.impl.AbstractEncryptionAlgorithm;

public class BlockEncryptionAlgorithmImpl
extends AbstractEncryptionAlgorithm
implements BlockEncryptionAlgorithm {
    private int ivLength;

    public BlockEncryptionAlgorithmImpl(String uri, int order, String keyType, int keyLength, int ivLength, String jcaName, Algorithm joseAlgorithm) {
        super(uri, order, keyType, keyLength, jcaName, joseAlgorithm);
        this.setIvLength(ivLength);
    }

    protected BlockEncryptionAlgorithmImpl(String uri) {
        super(uri);
    }

    public static BlockEncryptionAlgorithmBuilder builder(String uri) {
        return new BlockEncryptionAlgorithmBuilder(uri);
    }

    @Override
    public int getIvLength() {
        return this.ivLength;
    }

    protected void setIvLength(int ivLength) {
        this.ivLength = ivLength;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.ivLength);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BlockEncryptionAlgorithmImpl)) {
            return false;
        }
        BlockEncryptionAlgorithmImpl other = (BlockEncryptionAlgorithmImpl)obj;
        return this.ivLength == other.ivLength;
    }

    @Override
    public String toString() {
        return String.format("%s, iv-length='%d'", super.toString(), this.ivLength);
    }

    public static class BlockEncryptionAlgorithmBuilder
    extends AbstractEncryptionAlgorithm.AbstractEncryptionAlgorithmBuilder<BlockEncryptionAlgorithmImpl, BlockEncryptionAlgorithmBuilder> {
        public BlockEncryptionAlgorithmBuilder(String algorithmUri) {
            super(algorithmUri);
        }

        public BlockEncryptionAlgorithmBuilder ivLength(int ivLength) {
            ((BlockEncryptionAlgorithmImpl)this.getAlgorithm()).setIvLength(ivLength);
            return this.getBuilder();
        }

        @Override
        protected BlockEncryptionAlgorithmBuilder getBuilder() {
            return this;
        }

        @Override
        protected BlockEncryptionAlgorithmImpl createAlgorithm(String algorithmUri) {
            return new BlockEncryptionAlgorithmImpl(algorithmUri);
        }
    }
}

