/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import com.nimbusds.jose.JWSAlgorithm;
import java.util.Objects;
import java.util.Optional;
import se.swedenconnect.security.algorithms.Algorithm;
import se.swedenconnect.security.algorithms.MacAlgorithm;
import se.swedenconnect.security.algorithms.MessageDigestAlgorithm;
import se.swedenconnect.security.algorithms.impl.AbstractJoseAlgorithm;

public class MacAlgorithmImpl
extends AbstractJoseAlgorithm
implements MacAlgorithm {
    private MessageDigestAlgorithm messageDigestAlgorithm;

    public MacAlgorithmImpl(String uri, int order, String jcaName, JWSAlgorithm joseAlgorithm, MessageDigestAlgorithm messageDigestAlgorithm) {
        super(uri, order, jcaName, (com.nimbusds.jose.Algorithm)joseAlgorithm);
        this.setMessageDigestAlgorithm(messageDigestAlgorithm);
    }

    protected MacAlgorithmImpl(String uri) {
        super(uri);
    }

    public static MacAlgorithmBuilder builder(String uri) {
        return new MacAlgorithmBuilder(uri);
    }

    @Override
    public MessageDigestAlgorithm getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    protected void setMessageDigestAlgorithm(MessageDigestAlgorithm messageDigestAlgorithm) {
        this.messageDigestAlgorithm = Objects.requireNonNull(messageDigestAlgorithm, "messageDigestAlgorithm must be set");
        if (this.messageDigestAlgorithm.isBlacklisted()) {
            this.setBlacklisted(true);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.messageDigestAlgorithm);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MacAlgorithmImpl)) {
            return false;
        }
        MacAlgorithmImpl other = (MacAlgorithmImpl)obj;
        return Objects.equals(this.messageDigestAlgorithm, other.messageDigestAlgorithm);
    }

    @Override
    public String toString() {
        return String.format("%s, message-digest-algorithm='%s'", super.toString(), Optional.ofNullable(this.messageDigestAlgorithm).map(Algorithm::getUri).orElse("-"));
    }

    public static class MacAlgorithmBuilder
    extends AbstractJoseAlgorithm.AbstractJoseAlgorithmBuilder<MacAlgorithmImpl, MacAlgorithmBuilder> {
        public MacAlgorithmBuilder(String algorithmUri) {
            super(algorithmUri);
        }

        public MacAlgorithmBuilder messageDigestAlgorithm(MessageDigestAlgorithm messageDigestAlgorithm) {
            ((MacAlgorithmImpl)this.getAlgorithm()).setMessageDigestAlgorithm(messageDigestAlgorithm);
            return this.getBuilder();
        }

        @Override
        protected void assertCorrect() throws IllegalArgumentException {
            super.assertCorrect();
            if (((MacAlgorithmImpl)this.getAlgorithm()).getMessageDigestAlgorithm() == null) {
                throw new IllegalArgumentException("messageDigestAlgorithm must be set");
            }
        }

        @Override
        protected MacAlgorithmBuilder getBuilder() {
            return this;
        }

        @Override
        protected MacAlgorithmImpl createAlgorithm(String algorithmUri) {
            return new MacAlgorithmImpl(algorithmUri);
        }
    }
}

