/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.security.algorithms.MessageDigestAlgorithm;
import se.swedenconnect.security.algorithms.impl.AbstractAlgorithm;

public class MessageDigestAlgorithmImpl
extends AbstractAlgorithm
implements MessageDigestAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(MessageDigestAlgorithmImpl.class);
    private static DigestAlgorithmIdentifierFinder algIdFinder = new DefaultDigestAlgorithmIdentifierFinder();
    private AlgorithmIdentifier algorithmIdentifier;

    public MessageDigestAlgorithmImpl(String uri, int order, String jcaName) {
        super(uri, order, jcaName);
    }

    protected MessageDigestAlgorithmImpl(String uri) {
        super(uri);
    }

    public static MessageDigestAlgorithmBuilder builder(String uri) {
        return new MessageDigestAlgorithmBuilder(uri);
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    protected void setJcaName(String jcaName) {
        super.setJcaName(jcaName);
        if (this.algorithmIdentifier == null) {
            try {
                this.algorithmIdentifier = algIdFinder.find(jcaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.algorithmIdentifier == null) {
                log.info("No AlgorithmIdentifier exists for {}/{}", (Object)this.getUri(), (Object)this.getJcaName());
            }
        }
    }

    @Override
    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        objectArray[1] = this.algorithmIdentifier != null ? (this.algorithmIdentifier.getParameters() == null ? this.algorithmIdentifier.getAlgorithm().getId() : ASN1Dump.dumpAsString((Object)this.algorithmIdentifier)) : "-";
        return String.format("%s, algorithm-identifier=[%s]", objectArray);
    }

    public static class MessageDigestAlgorithmBuilder
    extends AbstractAlgorithm.AbstractAlgorithmBuilder<MessageDigestAlgorithmImpl, MessageDigestAlgorithmBuilder> {
        public MessageDigestAlgorithmBuilder(String algorithmUri) {
            super(algorithmUri);
        }

        @Override
        protected MessageDigestAlgorithmBuilder getBuilder() {
            return this;
        }

        @Override
        protected MessageDigestAlgorithmImpl createAlgorithm(String algorithmUri) {
            return new MessageDigestAlgorithmImpl(algorithmUri);
        }
    }
}

