/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import com.nimbusds.jose.JWSAlgorithm;
import java.security.spec.PSSParameterSpec;
import java.util.Objects;
import java.util.Optional;
import se.swedenconnect.security.algorithms.MessageDigestAlgorithm;
import se.swedenconnect.security.algorithms.RSAPSSSignatureAlgorithm;
import se.swedenconnect.security.algorithms.impl.SignatureAlgorithmImpl;

public class RSAPSSSignatureAlgorithmImpl
extends SignatureAlgorithmImpl
implements RSAPSSSignatureAlgorithm {
    private PSSParameterSpec parameterSpec;
    private String mgfUri;
    private MessageDigestAlgorithm mgfDigestAlgorithm;

    public RSAPSSSignatureAlgorithmImpl(String uri, int order, String keyType, String jcaName, PSSParameterSpec parameterSpec, JWSAlgorithm joseAlgorithm, MessageDigestAlgorithm messageDigestAlgorithm) {
        super(uri, order, keyType, jcaName, joseAlgorithm, messageDigestAlgorithm);
    }

    protected RSAPSSSignatureAlgorithmImpl(String uri) {
        super(uri);
    }

    public static RSAPSSSignatureAlgorithmBuilder getBuilder(String uri) {
        return new RSAPSSSignatureAlgorithmBuilder(uri);
    }

    @Override
    public PSSParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    protected void setParameterSpec(PSSParameterSpec parameterSpec) {
        this.parameterSpec = parameterSpec;
    }

    @Override
    public String getMGFUri() {
        return Optional.ofNullable(this.mgfUri).orElse(RSAPSSSignatureAlgorithm.super.getMGFUri());
    }

    public void setMGFUri(String mgfUri) {
        this.mgfUri = mgfUri;
    }

    @Override
    public MessageDigestAlgorithm getMGFDigestAlgorithm() {
        return Optional.ofNullable(this.mgfDigestAlgorithm).orElse(RSAPSSSignatureAlgorithm.super.getMGFDigestAlgorithm());
    }

    public void setMGFDigestAlgorithm(MessageDigestAlgorithm mgfDigestAlgorithm) {
        this.mgfDigestAlgorithm = mgfDigestAlgorithm;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.mgfDigestAlgorithm, this.mgfUri);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RSAPSSSignatureAlgorithmImpl)) {
            return false;
        }
        RSAPSSSignatureAlgorithmImpl other = (RSAPSSSignatureAlgorithmImpl)obj;
        return Objects.equals(this.mgfDigestAlgorithm, other.mgfDigestAlgorithm) && Objects.equals(this.mgfUri, other.mgfUri);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        if (this.mgfUri != null) {
            sb.append(", mgf-uri='").append(this.mgfUri).append("'");
        }
        if (this.mgfDigestAlgorithm != null) {
            sb.append(", mgf-digest-uri='").append(this.mgfDigestAlgorithm.getUri()).append("'");
        }
        return sb.toString();
    }

    public static class RSAPSSSignatureAlgorithmBuilder
    extends SignatureAlgorithmImpl.AbstractSignatureAlgorithmBuilder<RSAPSSSignatureAlgorithmImpl, RSAPSSSignatureAlgorithmBuilder> {
        public RSAPSSSignatureAlgorithmBuilder(String algorithmUri) {
            super(algorithmUri);
        }

        public RSAPSSSignatureAlgorithmBuilder parameterSpec(PSSParameterSpec parameterSpec) {
            ((RSAPSSSignatureAlgorithmImpl)this.getAlgorithm()).setParameterSpec(parameterSpec);
            return this.getBuilder();
        }

        public RSAPSSSignatureAlgorithmBuilder mgfUri(String mgfUri) {
            ((RSAPSSSignatureAlgorithmImpl)this.getAlgorithm()).setMGFUri(mgfUri);
            return this.getBuilder();
        }

        public RSAPSSSignatureAlgorithmBuilder setMGFDigestAlgorithm(MessageDigestAlgorithm mgfDigestAlgorithm) {
            ((RSAPSSSignatureAlgorithmImpl)this.getAlgorithm()).setMGFDigestAlgorithm(mgfDigestAlgorithm);
            return this.getBuilder();
        }

        @Override
        protected void assertCorrect() throws IllegalArgumentException {
            super.assertCorrect();
            if (((RSAPSSSignatureAlgorithmImpl)this.getAlgorithm()).getParameterSpec() == null) {
                throw new IllegalArgumentException("parameterSpec must be set");
            }
        }

        @Override
        protected RSAPSSSignatureAlgorithmBuilder getBuilder() {
            return this;
        }

        @Override
        protected RSAPSSSignatureAlgorithmImpl createAlgorithm(String algorithmUri) {
            return new RSAPSSSignatureAlgorithmImpl(algorithmUri);
        }
    }
}

