/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import com.nimbusds.jose.JWSAlgorithm;
import java.util.Objects;
import java.util.Optional;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.security.algorithms.Algorithm;
import se.swedenconnect.security.algorithms.MessageDigestAlgorithm;
import se.swedenconnect.security.algorithms.SignatureAlgorithm;
import se.swedenconnect.security.algorithms.impl.AbstractKeyBasedAlgorithm;
import se.swedenconnect.security.algorithms.impl.AlgorithmBuilder;

public class SignatureAlgorithmImpl
extends AbstractKeyBasedAlgorithm
implements SignatureAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(SignatureAlgorithmImpl.class);
    private static SignatureAlgorithmIdentifierFinder algIdFinder = new DefaultSignatureAlgorithmIdentifierFinder();
    private MessageDigestAlgorithm messageDigestAlgorithm;
    private AlgorithmIdentifier algorithmIdentifier;

    public SignatureAlgorithmImpl(String uri, int order, String keyType, String jcaName, JWSAlgorithm joseAlgorithm, MessageDigestAlgorithm messageDigestAlgorithm) {
        super(uri, order, keyType, jcaName, (com.nimbusds.jose.Algorithm)joseAlgorithm);
        this.setMessageDigestAlgorithm(messageDigestAlgorithm);
    }

    protected SignatureAlgorithmImpl(String uri) {
        super(uri);
    }

    public static SignatureAlgorithmBuilder builder(String uri) {
        return new SignatureAlgorithmBuilder(uri);
    }

    @Override
    public MessageDigestAlgorithm getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    protected void setMessageDigestAlgorithm(MessageDigestAlgorithm messageDigestAlgorithm) {
        this.messageDigestAlgorithm = Objects.requireNonNull(messageDigestAlgorithm, "messageDigestAlgorithm must be set");
        if (this.messageDigestAlgorithm.isBlacklisted()) {
            this.setBlacklisted(true);
        }
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    protected void setJcaName(String jcaName) {
        super.setJcaName(jcaName);
        if (this.algorithmIdentifier == null) {
            try {
                this.algorithmIdentifier = algIdFinder.find(jcaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.algorithmIdentifier == null) {
                log.info("No AlgorithmIdentifier exists for {}/{}", (Object)this.getUri(), (Object)this.getJcaName());
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.messageDigestAlgorithm);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SignatureAlgorithmImpl)) {
            return false;
        }
        SignatureAlgorithmImpl other = (SignatureAlgorithmImpl)obj;
        return Objects.equals(this.messageDigestAlgorithm, other.messageDigestAlgorithm);
    }

    @Override
    public String toString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = super.toString();
        objectArray[1] = Optional.ofNullable(this.messageDigestAlgorithm).map(Algorithm::getUri).orElse("-");
        objectArray[2] = this.algorithmIdentifier != null ? (this.algorithmIdentifier.getParameters() == null ? this.algorithmIdentifier.getAlgorithm().getId() : ASN1Dump.dumpAsString((Object)this.algorithmIdentifier)) : "-";
        return String.format("%s, message-digest-algorithm='%s', algorithm-identifier=[%s]", objectArray);
    }

    protected static abstract class AbstractSignatureAlgorithmBuilder<T extends SignatureAlgorithmImpl, B extends AbstractSignatureAlgorithmBuilder<T, ? extends AlgorithmBuilder<T>>>
    extends AbstractKeyBasedAlgorithm.AbstractKeyBasedAlgorithmBuilder<T, B> {
        public AbstractSignatureAlgorithmBuilder(String algorithmUri) {
            super(algorithmUri);
        }

        public B messageDigestAlgorithm(MessageDigestAlgorithm messageDigestAlgorithm) {
            ((SignatureAlgorithmImpl)this.getAlgorithm()).setMessageDigestAlgorithm(messageDigestAlgorithm);
            return (B)((AbstractSignatureAlgorithmBuilder)this.getBuilder());
        }

        @Override
        protected void assertCorrect() throws IllegalArgumentException {
            super.assertCorrect();
            if (((SignatureAlgorithmImpl)this.getAlgorithm()).getMessageDigestAlgorithm() == null) {
                throw new IllegalArgumentException("messageDigestAlgorithm must be set");
            }
        }
    }

    public static class SignatureAlgorithmBuilder
    extends AbstractSignatureAlgorithmBuilder<SignatureAlgorithmImpl, SignatureAlgorithmBuilder> {
        public SignatureAlgorithmBuilder(String algorithmUri) {
            super(algorithmUri);
        }

        @Override
        protected SignatureAlgorithmBuilder getBuilder() {
            return this;
        }

        @Override
        protected SignatureAlgorithmImpl createAlgorithm(String algorithmUri) {
            return new SignatureAlgorithmImpl(algorithmUri);
        }
    }
}

