/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.Requirement;
import java.security.Provider;
import java.security.Security;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.security.algorithms.Algorithm;
import se.swedenconnect.security.algorithms.MessageDigestAlgorithm;
import se.swedenconnect.security.algorithms.impl.AlgorithmRegistryImpl;
import se.swedenconnect.security.algorithms.impl.BlockEncryptionAlgorithmImpl;
import se.swedenconnect.security.algorithms.impl.KeyTransportAlgorithmImpl;
import se.swedenconnect.security.algorithms.impl.MacAlgorithmImpl;
import se.swedenconnect.security.algorithms.impl.MessageDigestAlgorithmImpl;
import se.swedenconnect.security.algorithms.impl.NoParamsRSAPSSSignatureAlgorithm;
import se.swedenconnect.security.algorithms.impl.RSAPSSSignatureAlgorithmImpl;
import se.swedenconnect.security.algorithms.impl.SignatureAlgorithmImpl;
import se.swedenconnect.security.algorithms.impl.SymmetricKeyWrapImpl;

public class StaticAlgorithmRegistry
extends AlgorithmRegistryImpl {
    private static final Logger log = LoggerFactory.getLogger(StaticAlgorithmRegistry.class);
    private static Algorithm[] defaultDigestAlgorithms;
    private static Algorithm[] defaultSignatureAlgorithms;
    private static Algorithm[] defaultMacAlgorithms;
    private static Algorithm[] defaultSymmetricKeyWrapAlgorithms;
    private static Algorithm[] defaultBlockEncryptionAlgorithms;
    private static Algorithm[] defaultKeyTransportAlgorithms;

    public StaticAlgorithmRegistry() {
        if (Security.getProvider("BC") == null) {
            log.info("Crypto provider '{}' is not installed, installing it ...", (Object)"BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
            log.info("Crypto provider '{}' was installed", (Object)"BC");
        }
        Arrays.stream(StaticAlgorithmRegistry.getDefaultDigestAlgorithms()).forEach(a -> this.register((Algorithm)a));
        Arrays.stream(StaticAlgorithmRegistry.getDefaultSignatureAlgorithms()).forEach(a -> this.register((Algorithm)a));
        Arrays.stream(StaticAlgorithmRegistry.getDefaultMacAlgorithms()).forEach(a -> this.register((Algorithm)a));
        Arrays.stream(StaticAlgorithmRegistry.getDefaultSymmetricKeyWrapAlgorithms()).forEach(a -> this.register((Algorithm)a));
        Arrays.stream(StaticAlgorithmRegistry.getDefaultBlockEncryptionAlgorithms()).forEach(a -> this.register((Algorithm)a));
        Arrays.stream(StaticAlgorithmRegistry.getDefaultKeyTransportAlgorithms()).forEach(a -> this.register((Algorithm)a));
    }

    public static Algorithm[] getDefaultDigestAlgorithms() {
        if (defaultDigestAlgorithms == null) {
            defaultDigestAlgorithms = new Algorithm[]{((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2001/04/xmlenc#sha256").order(1)).jcaName("SHA-256")).build(), ((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#sha384").order(2)).jcaName("SHA-384")).build(), ((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2001/04/xmlenc#sha512").order(3)).jcaName("SHA-512")).build(), ((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#sha224").order(4)).jcaName("SHA-224")).build(), ((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2007/05/xmldsig-more#sha3-256").order(5)).jcaName("SHA3-256")).build(), ((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2007/05/xmldsig-more#sha3-384").order(6)).jcaName("SHA3-384")).build(), ((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2007/05/xmldsig-more#sha3-512").order(7)).jcaName("SHA3-512")).build(), ((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2007/05/xmldsig-more#sha3-224").order(8)).jcaName("SHA3-224")).build(), ((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2001/04/xmlenc#ripemd160").order(9)).jcaName("RIPEMD160")).build(), ((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2000/09/xmldsig#sha1").order(Integer.MAX_VALUE)).jcaName("SHA-1")).blacklisted(true)).build(), ((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)((MessageDigestAlgorithmImpl.MessageDigestAlgorithmBuilder)MessageDigestAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#md5").order(Integer.MAX_VALUE)).jcaName("MD5")).blacklisted(true)).build()};
        }
        return defaultDigestAlgorithms;
    }

    public static Algorithm[] getDefaultSignatureAlgorithms() {
        if (defaultSignatureAlgorithms == null) {
            StaticAlgorithmRegistry.getDefaultDigestAlgorithms();
            defaultSignatureAlgorithms = new Algorithm[]{((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2009/xmldsig11#dsa-sha256").order(1)).keyType("DSA")).jcaName("SHA256withDSA")).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256", defaultDigestAlgorithms))).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256").order(1)).keyType("RSA")).jcaName("SHA256withRSA")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.RS256)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256", defaultDigestAlgorithms))).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384").order(2)).keyType("RSA")).jcaName("SHA384withRSA")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.RS384)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha384", defaultDigestAlgorithms))).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512").order(3)).keyType("RSA")).jcaName("SHA512withRSA")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.RS512)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512", defaultDigestAlgorithms))).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224").order(4)).keyType("RSA")).jcaName("SHA224withRSA")).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha224", defaultDigestAlgorithms))).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160").order(5)).keyType("RSA")).jcaName("RIPEMD160withRSA")).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#ripemd160", defaultDigestAlgorithms))).build(), ((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)RSAPSSSignatureAlgorithmImpl.getBuilder("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1").order(6)).keyType("RSA")).jcaName("SHA256withRSAandMGF1")).parameterSpec(new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1)).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.PS256)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256", defaultDigestAlgorithms))).build(), ((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)RSAPSSSignatureAlgorithmImpl.getBuilder("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1").order(7)).keyType("RSA")).jcaName("SHA384withRSAandMGF1")).parameterSpec(new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1)).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.PS384)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha384", defaultDigestAlgorithms))).build(), ((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)RSAPSSSignatureAlgorithmImpl.getBuilder("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1").order(8)).keyType("RSA")).jcaName("SHA512withRSAandMGF1")).parameterSpec(new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1)).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.PS512)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512", defaultDigestAlgorithms))).build(), ((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)RSAPSSSignatureAlgorithmImpl.getBuilder("http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1").order(9)).keyType("RSA")).jcaName("SHA224withRSAandMGF1")).parameterSpec(new PSSParameterSpec("SHA-224", "MGF1", MGF1ParameterSpec.SHA224, 28, 1)).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha224", defaultDigestAlgorithms))).build(), ((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)RSAPSSSignatureAlgorithmImpl.getBuilder("http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1").order(10)).keyType("RSA")).jcaName("SHA3-256withRSAandMGF1")).parameterSpec(new PSSParameterSpec("SHA3-256", "MGF1", new MGF1ParameterSpec("SHA3-256"), 32, 1)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha3-256", defaultDigestAlgorithms))).build(), ((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)RSAPSSSignatureAlgorithmImpl.getBuilder("http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1").order(11)).keyType("RSA")).jcaName("SHA3-384withRSAandMGF1")).parameterSpec(new PSSParameterSpec("SHA3-384", "MGF1", new MGF1ParameterSpec("SHA3-384"), 48, 1)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha3-384", defaultDigestAlgorithms))).build(), ((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)RSAPSSSignatureAlgorithmImpl.getBuilder("http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1").order(12)).keyType("RSA")).jcaName("SHA3-512withRSAandMGF1")).parameterSpec(new PSSParameterSpec("SHA3-512", "MGF1", new MGF1ParameterSpec("SHA3-512"), 64, 1)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha3-512", defaultDigestAlgorithms))).build(), ((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)RSAPSSSignatureAlgorithmImpl.getBuilder("http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1").order(13)).keyType("RSA")).jcaName("SHA3-224withRSAandMGF1")).parameterSpec(new PSSParameterSpec("SHA3-224", "MGF1", new MGF1ParameterSpec("SHA3-224"), 28, 1)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha3-224", defaultDigestAlgorithms))).build(), new NoParamsRSAPSSSignatureAlgorithm(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256").order(1)).keyType("EC")).jcaName("SHA256withECDSA")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.ES256)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256", defaultDigestAlgorithms))).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384").order(2)).keyType("EC")).jcaName("SHA384withECDSA")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.ES384)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha384", defaultDigestAlgorithms))).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512").order(3)).keyType("EC")).jcaName("SHA512withECDSA")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.ES512)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512", defaultDigestAlgorithms))).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224").order(4)).keyType("EC")).jcaName("SHA224withECDSA")).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha224", defaultDigestAlgorithms))).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160").order(5)).keyType("EC")).jcaName("RIPEMD160withECDSA")).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#ripemd160", defaultDigestAlgorithms))).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2000/09/xmldsig#dsa-sha1").order(Integer.MAX_VALUE)).keyType("DSA")).jcaName("SHA1withDSA")).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1", defaultDigestAlgorithms))).blacklisted(true)).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#rsa-md5").order(Integer.MAX_VALUE)).keyType("RSA")).jcaName("MD5withRSA")).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#md5", defaultDigestAlgorithms))).blacklisted(true)).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2000/09/xmldsig#rsa-sha1").order(Integer.MAX_VALUE)).keyType("RSA")).jcaName("SHA1withRSA")).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1", defaultDigestAlgorithms))).blacklisted(true)).build(), ((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)((RSAPSSSignatureAlgorithmImpl.RSAPSSSignatureAlgorithmBuilder)RSAPSSSignatureAlgorithmImpl.getBuilder("http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1").order(Integer.MAX_VALUE)).keyType("RSA")).jcaName("SHA1withRSAandMGF1")).parameterSpec(new PSSParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, 20, 1)).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1", defaultDigestAlgorithms))).blacklisted(true)).build(), ((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)((SignatureAlgorithmImpl.SignatureAlgorithmBuilder)SignatureAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1").order(Integer.MAX_VALUE)).keyType("EC")).jcaName("SHA1withECDSA")).joseAlgorithm(null)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1", defaultDigestAlgorithms))).blacklisted(true)).build()};
        }
        return defaultSignatureAlgorithms;
    }

    public static Algorithm[] getDefaultMacAlgorithms() {
        if (defaultMacAlgorithms == null) {
            StaticAlgorithmRegistry.getDefaultDigestAlgorithms();
            defaultMacAlgorithms = new Algorithm[]{((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)MacAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256").order(1)).jcaName("HmacSHA256")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.HS256)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256", defaultDigestAlgorithms)).build(), ((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)MacAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384").order(2)).jcaName("HmacSHA384")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.HS384)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha384", defaultDigestAlgorithms)).build(), ((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)MacAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512").order(3)).jcaName("HmacSHA512")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWSAlgorithm.HS512)).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512", defaultDigestAlgorithms)).build(), ((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)MacAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224").order(4)).jcaName("HmacSHA224")).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha224", defaultDigestAlgorithms)).build(), ((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)MacAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160").order(5)).jcaName("HMACRIPEMD160")).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#ripemd160", defaultDigestAlgorithms)).build(), ((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)MacAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#hmac-md5").order(Integer.MAX_VALUE)).jcaName("HmacMD5")).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#md5", defaultDigestAlgorithms)).blacklisted(true)).build(), ((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)((MacAlgorithmImpl.MacAlgorithmBuilder)MacAlgorithmImpl.builder("http://www.w3.org/2000/09/xmldsig#hmac-sha1").order(Integer.MAX_VALUE)).jcaName("HmacSHA1")).messageDigestAlgorithm(StaticAlgorithmRegistry.getDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1", defaultDigestAlgorithms)).blacklisted(true)).build()};
        }
        return defaultMacAlgorithms;
    }

    public static final Algorithm[] getDefaultSymmetricKeyWrapAlgorithms() {
        if (defaultSymmetricKeyWrapAlgorithms == null) {
            defaultSymmetricKeyWrapAlgorithms = new Algorithm[]{((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)SymmetricKeyWrapImpl.builder("http://www.w3.org/2001/04/xmlenc#kw-aes128").order(1)).jcaName("AESWrap")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWEAlgorithm.A128KW)).keyType("AES")).keyLength(128)).build(), ((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)SymmetricKeyWrapImpl.builder("http://www.w3.org/2001/04/xmlenc#kw-aes192").order(2)).jcaName("AESWrap")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWEAlgorithm.A192KW)).keyType("AES")).keyLength(192)).build(), ((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)SymmetricKeyWrapImpl.builder("http://www.w3.org/2001/04/xmlenc#kw-aes256").order(3)).jcaName("AESWrap")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWEAlgorithm.A256KW)).keyType("AES")).keyLength(256)).build(), ((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)SymmetricKeyWrapImpl.builder("http://www.w3.org/2001/04/xmldsig-more#kw-camellia128").order(1)).jcaName("CamelliaWrap")).keyType("Camellia")).keyLength(128)).build(), ((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)SymmetricKeyWrapImpl.builder("http://www.w3.org/2001/04/xmldsig-more#kw-camellia192").order(2)).jcaName("CamelliaWrap")).keyType("Camellia")).keyLength(192)).build(), ((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)SymmetricKeyWrapImpl.builder("http://www.w3.org/2001/04/xmldsig-more#kw-camellia256").order(3)).jcaName("CamelliaWrap")).keyType("Camellia")).keyLength(256)).build(), ((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)SymmetricKeyWrapImpl.builder("http://www.w3.org/2007/05/xmldsig-more#kw-seed128").order(1)).jcaName("SEEDWrap")).keyType("SEED")).keyLength(128)).build(), ((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)((SymmetricKeyWrapImpl.SymmetricKeyWrapBuilder)SymmetricKeyWrapImpl.builder("http://www.w3.org/2001/04/xmlenc#kw-tripledes").order(1)).jcaName("DESedeWrap")).keyType("DESede")).keyLength(192)).build()};
        }
        return defaultSymmetricKeyWrapAlgorithms;
    }

    public static Algorithm[] getDefaultBlockEncryptionAlgorithms() {
        if (defaultBlockEncryptionAlgorithms == null) {
            defaultBlockEncryptionAlgorithms = new Algorithm[]{((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2009/xmlenc11#aes128-gcm").order(1)).jcaName("AES/GCM/NoPadding")).joseAlgorithm((com.nimbusds.jose.Algorithm)EncryptionMethod.A128GCM)).keyType("AES")).keyLength(128)).ivLength(96).build(), ((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2009/xmlenc11#aes192-gcm").order(2)).jcaName("AES/GCM/NoPadding")).joseAlgorithm((com.nimbusds.jose.Algorithm)EncryptionMethod.A192GCM)).keyType("AES")).keyLength(192)).ivLength(96).build(), ((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2009/xmlenc11#aes256-gcm").order(3)).jcaName("AES/GCM/NoPadding")).joseAlgorithm((com.nimbusds.jose.Algorithm)EncryptionMethod.A256GCM)).keyType("AES")).keyLength(256)).ivLength(96).build(), ((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2001/04/xmlenc#aes128-cbc").order(4)).jcaName("AES/CBC/ISO10126Padding")).keyType("AES")).keyLength(128)).ivLength(128).build(), ((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2001/04/xmlenc#aes192-cbc").order(5)).jcaName("AES/CBC/ISO10126Padding")).keyType("AES")).keyLength(192)).ivLength(128).build(), ((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2001/04/xmlenc#aes256-cbc").order(6)).jcaName("AES/CBC/ISO10126Padding")).keyType("AES")).keyLength(256)).ivLength(128).build(), ((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2007/05/xmldsig-more#seed128-cbc").order(1)).jcaName("SEED/CBC/ISO10126Padding")).keyType("SEED")).keyLength(128)).ivLength(128).build(), ((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#camellia128-cbc").order(1)).jcaName("Camellia/CBC/ISO10126Padding")).keyType("Camellia")).keyLength(128)).ivLength(128).build(), ((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#camellia192-cbc").order(2)).jcaName("Camellia/CBC/ISO10126Padding")).keyType("Camellia")).keyLength(192)).ivLength(128).build(), ((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2001/04/xmldsig-more#camellia256-cbc").order(3)).jcaName("Camellia/CBC/ISO10126Padding")).keyType("Camellia")).keyLength(256)).ivLength(128).build(), ((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)((BlockEncryptionAlgorithmImpl.BlockEncryptionAlgorithmBuilder)BlockEncryptionAlgorithmImpl.builder("http://www.w3.org/2001/04/xmlenc#tripledes-cbc").order(1)).jcaName("DESede/CBC/ISO10126Padding")).keyType("DESede")).keyLength(192)).ivLength(64).build()};
        }
        return defaultBlockEncryptionAlgorithms;
    }

    public static Algorithm[] getDefaultKeyTransportAlgorithms() {
        if (defaultKeyTransportAlgorithms == null) {
            defaultKeyTransportAlgorithms = new Algorithm[]{((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)KeyTransportAlgorithmImpl.builder("http://www.w3.org/2009/xmlenc11#rsa-oaep").order(1)).jcaName("RSA/ECB/OAEPPadding")).joseAlgorithm((com.nimbusds.jose.Algorithm)JWEAlgorithm.RSA_OAEP_256)).keyType("RSA")).build(), ((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)KeyTransportAlgorithmImpl.builder("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p").order(2)).jcaName("RSA/ECB/OAEPPadding")).joseAlgorithm((com.nimbusds.jose.Algorithm)new JWEAlgorithm("RSA-OAEP", Requirement.OPTIONAL))).keyType("RSA")).build(), ((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)((KeyTransportAlgorithmImpl.KeyTransportAlgorithmBuilder)KeyTransportAlgorithmImpl.builder("http://www.w3.org/2001/04/xmlenc#rsa-1_5").order(Integer.MAX_VALUE)).jcaName("RSA/ECB/PKCS1Padding")).joseAlgorithm((com.nimbusds.jose.Algorithm)new JWEAlgorithm("RSA1_5", Requirement.REQUIRED))).keyType("RSA")).blacklisted(true)).build()};
        }
        return defaultKeyTransportAlgorithms;
    }

    private static MessageDigestAlgorithm getDigestAlgorithm(String uri, Algorithm[] algs) {
        return Arrays.stream(algs).filter(d -> uri.equals(d.getUri())).map(MessageDigestAlgorithm.class::cast).findFirst().orElse(null);
    }
}

