/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import com.nimbusds.jose.Algorithm;
import se.swedenconnect.security.algorithms.AlgorithmType;
import se.swedenconnect.security.algorithms.impl.AbstractEncryptionAlgorithm;

public class SymmetricKeyWrapImpl
extends AbstractEncryptionAlgorithm {
    public SymmetricKeyWrapImpl(String uri, int order, String keyType, int keyLength, String jcaName, Algorithm joseAlgorithm) {
        super(uri, order, keyType, keyLength, jcaName, joseAlgorithm);
    }

    protected SymmetricKeyWrapImpl(String uri) {
        super(uri);
    }

    public static SymmetricKeyWrapBuilder builder(String uri) {
        return new SymmetricKeyWrapBuilder(uri);
    }

    @Override
    public final AlgorithmType getType() {
        return AlgorithmType.SYMMETRIC_KEY_WRAP;
    }

    public static class SymmetricKeyWrapBuilder
    extends AbstractEncryptionAlgorithm.AbstractEncryptionAlgorithmBuilder<SymmetricKeyWrapImpl, SymmetricKeyWrapBuilder> {
        public SymmetricKeyWrapBuilder(String algorithmUri) {
            super(algorithmUri);
        }

        @Override
        protected SymmetricKeyWrapBuilder getBuilder() {
            return this;
        }

        @Override
        protected SymmetricKeyWrapImpl createAlgorithm(String algorithmUri) {
            return new SymmetricKeyWrapImpl(algorithmUri);
        }
    }
}

