/*
 * Decompiled with CFR 0.152.
 */
package almond.internals;

import almond.internals.HtmlAnsiOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.fusesource.jansi.io.AnsiProcessor;

public class AnsiToHtmlProcessor
extends AnsiProcessor {
    private boolean concealOn = false;
    private HtmlAnsiOutputStream haos;

    AnsiToHtmlProcessor(OutputStream outputStream) {
        super(outputStream);
    }

    public HtmlAnsiOutputStream getHtmlAnsiOutputStream() {
        return this.haos;
    }

    public void setHtmlAnsiOutputStream(HtmlAnsiOutputStream htmlAnsiOutputStream) {
        this.haos = htmlAnsiOutputStream;
    }

    protected void processSetAttribute(int n) throws IOException {
        switch (n) {
            case 8: {
                this.haos.write("\u001b[8m");
                this.concealOn = true;
                break;
            }
            case 1: {
                this.haos.writeAttribute("b");
                break;
            }
            case 22: {
                this.haos.closeAttributes();
                break;
            }
            case 4: {
                this.haos.writeAttribute("u");
                break;
            }
            case 24: {
                this.haos.closeAttributes();
                break;
            }
            case 7: {
                break;
            }
            case 27: {
                break;
            }
        }
    }

    protected void processDefaultTextColor() throws IOException {
        this.processAttributeReset();
    }

    protected void processAttributeReset() throws IOException {
        if (this.concealOn) {
            this.haos.write("\u001b[0m");
            this.concealOn = false;
        }
        this.haos.closeAttributes();
    }

    protected void processSetForegroundColor(int n, boolean bl) throws IOException {
        this.haos.writeAttribute("span style=\"color: " + HtmlAnsiOutputStream.RGB_COLOR_MAP[n] + "\"");
        this.haos.writeAttribute("span class=\"ansi-" + HtmlAnsiOutputStream.ANSI_COLOR_MAP[n] + "-fg\"");
    }

    protected void processSetBackgroundColor(int n, boolean bl) throws IOException {
        String string = "";
        if (n == 7) {
            string = "; color: rgb(255, 255, 255);";
        }
        this.haos.writeAttribute("span style=\"background-color: " + HtmlAnsiOutputStream.RGB_COLOR_MAP[n] + string + "\"");
        this.haos.writeAttribute("span class=\"ansi-" + HtmlAnsiOutputStream.ANSI_COLOR_MAP[n] + "-bg\"");
    }
}

