/*
 * Decompiled with CFR 0.152.
 */
package almond.internals;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.jansi.AnsiOutputStream;

public class HtmlAnsiOutputStream
extends AnsiOutputStream {
    private boolean concealOn = false;
    private static final String[] ANSI_COLOR_MAP = new String[]{"black", "red", "green", "yellow", "blue", "magenta", "cyan", "white"};
    private static final String[] RGB_COLOR_MAP = new String[]{"black", "red", "rgb(0, 187, 0)", "yellow", "blue", "magenta", "rgb(0, 187, 187)", "white"};
    private static final byte[] BYTES_QUOT = "&quot;".getBytes();
    private static final byte[] BYTES_AMP = "&amp;".getBytes();
    private static final byte[] BYTES_LT = "&lt;".getBytes();
    private static final byte[] BYTES_GT = "&gt;".getBytes();
    private final List<String> closingAttributes = new ArrayList<String>();

    public void close() throws IOException {
        this.closeAttributes();
        super.close();
    }

    public HtmlAnsiOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void write(String string) throws IOException {
        this.out.write(string.getBytes());
    }

    private void writeAttribute(String string) throws IOException {
        this.write("<" + string + ">");
        this.closingAttributes.add(0, string.split(" ", 2)[0]);
    }

    private void closeAttributes() throws IOException {
        for (String string : this.closingAttributes) {
            this.write("</" + string + ">");
        }
        this.closingAttributes.clear();
    }

    public void write(int n) throws IOException {
        switch (n) {
            case 34: {
                this.out.write(BYTES_QUOT);
                break;
            }
            case 38: {
                this.out.write(BYTES_AMP);
                break;
            }
            case 60: {
                this.out.write(BYTES_LT);
                break;
            }
            case 62: {
                this.out.write(BYTES_GT);
                break;
            }
            default: {
                super.write(n);
            }
        }
    }

    public void writeLine(byte[] byArray, int n, int n2) throws IOException {
        this.write(byArray, n, n2);
        this.closeAttributes();
    }

    protected void processSetAttribute(int n) throws IOException {
        switch (n) {
            case 8: {
                this.write("\u001b[8m");
                this.concealOn = true;
                break;
            }
            case 1: {
                this.writeAttribute("b");
                break;
            }
            case 22: {
                this.closeAttributes();
                break;
            }
            case 4: {
                this.writeAttribute("u");
                break;
            }
            case 24: {
                this.closeAttributes();
                break;
            }
            case 7: {
                break;
            }
            case 27: {
                break;
            }
        }
    }

    protected void processAttributeRest() throws IOException {
        if (this.concealOn) {
            this.write("\u001b[0m");
            this.concealOn = false;
        }
        this.closeAttributes();
    }

    protected void processDefaultTextColor() throws IOException {
        this.processAttributeRest();
    }

    protected void processSetForegroundColor(int n, boolean bl) throws IOException {
        this.writeAttribute("span style=\"color: " + RGB_COLOR_MAP[n] + "\"");
        this.writeAttribute("span class=\"ansi-" + ANSI_COLOR_MAP[n] + "-fg\"");
    }

    protected void processSetBackgroundColor(int n, boolean bl) throws IOException {
        String string = "";
        if (n == 7) {
            string = "; color: rgb(255, 255, 255);";
        }
        this.writeAttribute("span style=\"background-color: " + RGB_COLOR_MAP[n] + string + "\"");
        this.writeAttribute("span class=\"ansi-" + ANSI_COLOR_MAP[n] + "-bg\"");
    }
}

