/*
 * Decompiled with CFR 0.152.
 */
package almond.internals;

import almond.internals.AnsiToHtmlProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.jansi.AnsiColors;
import org.fusesource.jansi.AnsiMode;
import org.fusesource.jansi.AnsiType;
import org.fusesource.jansi.io.AnsiOutputStream;
import org.fusesource.jansi.io.AnsiProcessor;

public class HtmlAnsiOutputStream
extends AnsiOutputStream {
    private static final Map<OutputStream, AnsiToHtmlProcessor> streamsAndProcessors = new ConcurrentHashMap<OutputStream, AnsiToHtmlProcessor>();
    public static final String[] ANSI_COLOR_MAP = new String[]{"black", "red", "green", "yellow", "blue", "magenta", "cyan", "white"};
    public static final String[] RGB_COLOR_MAP = new String[]{"black", "red", "rgb(0, 187, 0)", "yellow", "blue", "magenta", "rgb(0, 187, 187)", "white"};
    private static final byte[] BYTES_QUOT = "&quot;".getBytes();
    private static final byte[] BYTES_AMP = "&amp;".getBytes();
    private static final byte[] BYTES_LT = "&lt;".getBytes();
    private static final byte[] BYTES_GT = "&gt;".getBytes();
    private final List<String> closingAttributes = new ArrayList<String>();

    private static synchronized AnsiToHtmlProcessor createAnsiToHtmlProcessorForOutput(OutputStream outputStream) {
        AnsiToHtmlProcessor ansiToHtmlProcessor = new AnsiToHtmlProcessor(outputStream);
        streamsAndProcessors.put(outputStream, ansiToHtmlProcessor);
        return ansiToHtmlProcessor;
    }

    public void close() throws IOException {
        this.closeAttributes();
        super.close();
    }

    public HtmlAnsiOutputStream(OutputStream outputStream) {
        super(outputStream, new AnsiOutputStream.WidthSupplier(){

            public int getTerminalWidth() {
                return Integer.MAX_VALUE;
            }
        }, AnsiMode.Default, (AnsiProcessor)HtmlAnsiOutputStream.createAnsiToHtmlProcessorForOutput(outputStream), AnsiType.Native, AnsiColors.Colors16, Charset.defaultCharset(), null, null, true);
        streamsAndProcessors.get(outputStream).setHtmlAnsiOutputStream(this);
    }

    public void write(String string) throws IOException {
        this.out.write(string.getBytes());
    }

    public void writeAttribute(String string) throws IOException {
        this.write("<" + string + ">");
        this.closingAttributes.add(0, string.split(" ", 2)[0]);
    }

    public void closeAttributes() throws IOException {
        for (String string : this.closingAttributes) {
            this.write("</" + string + ">");
        }
        this.closingAttributes.clear();
    }

    public void write(int n) throws IOException {
        switch (n) {
            case 34: {
                this.out.write(BYTES_QUOT);
                break;
            }
            case 38: {
                this.out.write(BYTES_AMP);
                break;
            }
            case 60: {
                this.out.write(BYTES_LT);
                break;
            }
            case 62: {
                this.out.write(BYTES_GT);
                break;
            }
            default: {
                super.write(n);
            }
        }
    }

    public void writeLine(byte[] byArray, int n, int n2) throws IOException {
        this.write(byArray, n, n2);
        this.closeAttributes();
    }
}

