/*
 * Decompiled with CFR 0.152.
 */
package almond.internals;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import scala.Function1;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;

public class FunctionOutputStream
extends OutputStream {
    private final Charset internalCharset;
    private final Function1<String, BoxedUnit> f;
    private final CharsetDecoder decoder;
    private final byte[] inArray;
    private final char[] outArray;
    private final ByteBuffer writeBuf;
    private final CharBuffer out;

    public FunctionOutputStream(int inputBufferSize, int outputBufferSize, Charset internalCharset, Function1<String, BoxedUnit> f) {
        this.internalCharset = internalCharset;
        this.f = f;
        this.decoder = internalCharset.newDecoder();
        this.inArray = new byte[inputBufferSize];
        this.outArray = new char[outputBufferSize];
        this.writeBuf = ByteBuffer.wrap(this.inArray);
        this.out = CharBuffer.wrap(this.outArray);
    }

    private void flushIfNeeded() {
        if (!this.writeBuf.hasRemaining()) {
            this.flush();
            return;
        }
    }

    @Override
    public void write(int b) {
        this.writeBuf.put((byte)b);
        this.flushIfNeeded();
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int len0;
        int take;
        int off0 = off;
        for (len0 = len; len0 > 0; len0 -= take) {
            take = package$.MODULE$.min(len0, this.writeBuf.remaining());
            if (take <= 0) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            this.writeBuf.put(b, off0, take);
            off0 += take;
            this.flushIfNeeded();
        }
        if (len0 != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (off0 != off + len) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
    }

    @Override
    public void flush() {
        super.flush();
        ByteBuffer readBuf = ByteBuffer.wrap(this.inArray, 0, this.writeBuf.position());
        CoderResult r = null;
        while (r == null || r.isOverflow()) {
            if (r != null) {
                readBuf.position(0);
                readBuf.limit(this.writeBuf.position());
            }
            r = this.decoder.decode(readBuf, this.out, false);
            int outLen = this.out.position();
            if (r.isError() || r.isOverflow() && outLen == 0) {
                r.throwException();
                continue;
            }
            if (outLen > 0) {
                String s = new String(this.outArray, 0, outLen);
                this.out.clear();
                this.f.apply((Object)s);
            }
            int read = readBuf.position();
            int avail = this.writeBuf.position();
            int remaining = avail - read;
            this.writeBuf.position(remaining);
            if (remaining <= 0) continue;
            System.arraycopy(this.inArray, read, this.inArray, 0, remaining);
        }
    }

    public PrintStream printStream() {
        return new PrintStream((OutputStream)this, true, this.internalCharset.name());
    }
}

