/*
 * Ory APIs
 * Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed with a valid Personal Access Token. Public APIs are mostly used in browsers. 
 *
 * The version of the OpenAPI document: v0.0.1-alpha.111
 * Contact: support@ory.sh
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package sh.ory.api;

import sh.ory.ApiCallback;
import sh.ory.ApiClient;
import sh.ory.ApiException;
import sh.ory.ApiResponse;
import sh.ory.Configuration;
import sh.ory.Pair;
import sh.ory.ProgressRequestBody;
import sh.ory.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import sh.ory.model.ActiveProject;
import sh.ory.model.CloudAccount;
import sh.ory.model.GenericError;
import sh.ory.model.InlineObject;
import sh.ory.model.Project;
import sh.ory.model.ProjectRevision;
import sh.ory.model.SuccessfulProjectConfigUpdate;
import sh.ory.model.UpdateProjectConfigConfig;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class V0alpha0Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public V0alpha0Api() {
        this(Configuration.getDefaultApiClient());
    }

    public V0alpha0Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createProject
     * @param projectRevision  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createProjectCall(ProjectRevision projectRevision, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = projectRevision;

        // create path and map variables
        String localVarPath = "/backoffice/public/projects";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createProjectValidateBeforeCall(ProjectRevision projectRevision, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createProjectCall(projectRevision, _callback);
        return localVarCall;

    }

    /**
     * Create a Project
     * Creates a new project.
     * @param projectRevision  (optional)
     * @return Project
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public Project createProject(ProjectRevision projectRevision) throws ApiException {
        ApiResponse<Project> localVarResp = createProjectWithHttpInfo(projectRevision);
        return localVarResp.getData();
    }

    /**
     * Create a Project
     * Creates a new project.
     * @param projectRevision  (optional)
     * @return ApiResponse&lt;Project&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Project> createProjectWithHttpInfo(ProjectRevision projectRevision) throws ApiException {
        okhttp3.Call localVarCall = createProjectValidateBeforeCall(projectRevision, null);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a Project (asynchronously)
     * Creates a new project.
     * @param projectRevision  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createProjectAsync(ProjectRevision projectRevision, final ApiCallback<Project> _callback) throws ApiException {

        okhttp3.Call localVarCall = createProjectValidateBeforeCall(projectRevision, _callback);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getActiveProject
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> activeProject </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActiveProjectCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/backoffice/public/console/projects/active";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getActiveProjectValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getActiveProjectCall(_callback);
        return localVarCall;

    }

    /**
     * Returns Your Active Ory Cloud Project
     * Use this API to get your active project in the Ory Cloud Console UI.
     * @return ActiveProject
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> activeProject </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ActiveProject getActiveProject() throws ApiException {
        ApiResponse<ActiveProject> localVarResp = getActiveProjectWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Returns Your Active Ory Cloud Project
     * Use this API to get your active project in the Ory Cloud Console UI.
     * @return ApiResponse&lt;ActiveProject&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> activeProject </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ActiveProject> getActiveProjectWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getActiveProjectValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ActiveProject>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Returns Your Active Ory Cloud Project (asynchronously)
     * Use this API to get your active project in the Ory Cloud Console UI.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> activeProject </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActiveProjectAsync(final ApiCallback<ActiveProject> _callback) throws ApiException {

        okhttp3.Call localVarCall = getActiveProjectValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ActiveProject>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProject
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProjectCall(String projectId, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/backoffice/public/projects/{project_id}"
            .replaceAll("\\{" + "project_id" + "\\}", localVarApiClient.escapeString(projectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProjectValidateBeforeCall(String projectId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getProject(Async)");
        }
        

        okhttp3.Call localVarCall = getProjectCall(projectId, _callback);
        return localVarCall;

    }

    /**
     * Get a Project
     * Get a projects you have access to by its ID.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @return Project
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public Project getProject(String projectId) throws ApiException {
        ApiResponse<Project> localVarResp = getProjectWithHttpInfo(projectId);
        return localVarResp.getData();
    }

    /**
     * Get a Project
     * Get a projects you have access to by its ID.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @return ApiResponse&lt;Project&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Project> getProjectWithHttpInfo(String projectId) throws ApiException {
        okhttp3.Call localVarCall = getProjectValidateBeforeCall(projectId, null);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a Project (asynchronously)
     * Get a projects you have access to by its ID.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProjectAsync(String projectId, final ApiCallback<Project> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProjectValidateBeforeCall(projectId, _callback);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProjectMembers
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> projectMembers </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProjectMembersCall(String projectId, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/backoffice/public/projects/{project_id}/members"
            .replaceAll("\\{" + "project_id" + "\\}", localVarApiClient.escapeString(projectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProjectMembersValidateBeforeCall(String projectId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getProjectMembers(Async)");
        }
        

        okhttp3.Call localVarCall = getProjectMembersCall(projectId, _callback);
        return localVarCall;

    }

    /**
     * Get all members associated with this project.
     * This endpoint requires the user to be a member of the project with the role &#x60;OWNER&#x60; or &#x60;DEVELOPER&#x60;.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @return List&lt;CloudAccount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> projectMembers </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public List<CloudAccount> getProjectMembers(String projectId) throws ApiException {
        ApiResponse<List<CloudAccount>> localVarResp = getProjectMembersWithHttpInfo(projectId);
        return localVarResp.getData();
    }

    /**
     * Get all members associated with this project.
     * This endpoint requires the user to be a member of the project with the role &#x60;OWNER&#x60; or &#x60;DEVELOPER&#x60;.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @return ApiResponse&lt;List&lt;CloudAccount&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> projectMembers </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CloudAccount>> getProjectMembersWithHttpInfo(String projectId) throws ApiException {
        okhttp3.Call localVarCall = getProjectMembersValidateBeforeCall(projectId, null);
        Type localVarReturnType = new TypeToken<List<CloudAccount>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all members associated with this project. (asynchronously)
     * This endpoint requires the user to be a member of the project with the role &#x60;OWNER&#x60; or &#x60;DEVELOPER&#x60;.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> projectMembers </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProjectMembersAsync(String projectId, final ApiCallback<List<CloudAccount>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProjectMembersValidateBeforeCall(projectId, _callback);
        Type localVarReturnType = new TypeToken<List<CloudAccount>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listProjects
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> projects </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listProjectsCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/backoffice/public/projects";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listProjectsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listProjectsCall(_callback);
        return localVarCall;

    }

    /**
     * List All Projects
     * Lists all projects you have access to.
     * @return List&lt;Project&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> projects </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public List<Project> listProjects() throws ApiException {
        ApiResponse<List<Project>> localVarResp = listProjectsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * List All Projects
     * Lists all projects you have access to.
     * @return ApiResponse&lt;List&lt;Project&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> projects </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Project>> listProjectsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listProjectsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Project>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List All Projects (asynchronously)
     * Lists all projects you have access to.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> projects </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listProjectsAsync(final ApiCallback<List<Project>> _callback) throws ApiException {

        okhttp3.Call localVarCall = listProjectsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Project>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for purgeProject
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call purgeProjectCall(String projectId, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/backoffice/public/projects/{project_id}"
            .replaceAll("\\{" + "project_id" + "\\}", localVarApiClient.escapeString(projectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call purgeProjectValidateBeforeCall(String projectId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling purgeProject(Async)");
        }
        

        okhttp3.Call localVarCall = purgeProjectCall(projectId, _callback);
        return localVarCall;

    }

    /**
     * Irrecoverably Purge a Project
     * !! Use with extreme caution !!  Using this API endpoint you can purge (completely delete) a project and its data. This action can not be undone and will delete ALL your data.  !! Use with extreme caution !!
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public void purgeProject(String projectId) throws ApiException {
        purgeProjectWithHttpInfo(projectId);
    }

    /**
     * Irrecoverably Purge a Project
     * !! Use with extreme caution !!  Using this API endpoint you can purge (completely delete) a project and its data. This action can not be undone and will delete ALL your data.  !! Use with extreme caution !!
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> purgeProjectWithHttpInfo(String projectId) throws ApiException {
        okhttp3.Call localVarCall = purgeProjectValidateBeforeCall(projectId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Irrecoverably Purge a Project (asynchronously)
     * !! Use with extreme caution !!  Using this API endpoint you can purge (completely delete) a project and its data. This action can not be undone and will delete ALL your data.  !! Use with extreme caution !!
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call purgeProjectAsync(String projectId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = purgeProjectValidateBeforeCall(projectId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for removeProjectMember
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param memberId Member ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call removeProjectMemberCall(String projectId, String memberId, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/backoffice/public/projects/{project_id}/members/{member_id}"
            .replaceAll("\\{" + "project_id" + "\\}", localVarApiClient.escapeString(projectId.toString()))
            .replaceAll("\\{" + "member_id" + "\\}", localVarApiClient.escapeString(memberId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call removeProjectMemberValidateBeforeCall(String projectId, String memberId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling removeProjectMember(Async)");
        }
        
        // verify the required parameter 'memberId' is set
        if (memberId == null) {
            throw new ApiException("Missing the required parameter 'memberId' when calling removeProjectMember(Async)");
        }
        

        okhttp3.Call localVarCall = removeProjectMemberCall(projectId, memberId, _callback);
        return localVarCall;

    }

    /**
     * Remove a member associated with this project. This also sets their invite status to &#x60;REMOVED&#x60;.
     * This endpoint requires the user to be a member of the project with the role &#x60;OWNER&#x60;.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param memberId Member ID (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public void removeProjectMember(String projectId, String memberId) throws ApiException {
        removeProjectMemberWithHttpInfo(projectId, memberId);
    }

    /**
     * Remove a member associated with this project. This also sets their invite status to &#x60;REMOVED&#x60;.
     * This endpoint requires the user to be a member of the project with the role &#x60;OWNER&#x60;.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param memberId Member ID (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> removeProjectMemberWithHttpInfo(String projectId, String memberId) throws ApiException {
        okhttp3.Call localVarCall = removeProjectMemberValidateBeforeCall(projectId, memberId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Remove a member associated with this project. This also sets their invite status to &#x60;REMOVED&#x60;. (asynchronously)
     * This endpoint requires the user to be a member of the project with the role &#x60;OWNER&#x60;.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param memberId Member ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call removeProjectMemberAsync(String projectId, String memberId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = removeProjectMemberValidateBeforeCall(projectId, memberId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setActiveProject
     * @param inlineObject  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setActiveProjectCall(InlineObject inlineObject, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = inlineObject;

        // create path and map variables
        String localVarPath = "/backoffice/public/console/projects/active";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setActiveProjectValidateBeforeCall(InlineObject inlineObject, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = setActiveProjectCall(inlineObject, _callback);
        return localVarCall;

    }

    /**
     * Sets Your Active Project
     * Use this API to set your active project in the Ory Cloud Console UI.
     * @param inlineObject  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public void setActiveProject(InlineObject inlineObject) throws ApiException {
        setActiveProjectWithHttpInfo(inlineObject);
    }

    /**
     * Sets Your Active Project
     * Use this API to set your active project in the Ory Cloud Console UI.
     * @param inlineObject  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> setActiveProjectWithHttpInfo(InlineObject inlineObject) throws ApiException {
        okhttp3.Call localVarCall = setActiveProjectValidateBeforeCall(inlineObject, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Sets Your Active Project (asynchronously)
     * Use this API to set your active project in the Ory Cloud Console UI.
     * @param inlineObject  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setActiveProjectAsync(InlineObject inlineObject, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setActiveProjectValidateBeforeCall(inlineObject, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateProject
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param projectRevision  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProjectCall(String projectId, ProjectRevision projectRevision, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = projectRevision;

        // create path and map variables
        String localVarPath = "/backoffice/public/projects/{project_id}"
            .replaceAll("\\{" + "project_id" + "\\}", localVarApiClient.escapeString(projectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateProjectValidateBeforeCall(String projectId, ProjectRevision projectRevision, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling updateProject(Async)");
        }
        

        okhttp3.Call localVarCall = updateProjectCall(projectId, projectRevision, _callback);
        return localVarCall;

    }

    /**
     * Update a Project
     * Creates a new configuration revision for a project.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param projectRevision  (optional)
     * @return Project
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public Project updateProject(String projectId, ProjectRevision projectRevision) throws ApiException {
        ApiResponse<Project> localVarResp = updateProjectWithHttpInfo(projectId, projectRevision);
        return localVarResp.getData();
    }

    /**
     * Update a Project
     * Creates a new configuration revision for a project.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param projectRevision  (optional)
     * @return ApiResponse&lt;Project&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Project> updateProjectWithHttpInfo(String projectId, ProjectRevision projectRevision) throws ApiException {
        okhttp3.Call localVarCall = updateProjectValidateBeforeCall(projectId, projectRevision, null);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update a Project (asynchronously)
     * Creates a new configuration revision for a project.
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param projectRevision  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProjectAsync(String projectId, ProjectRevision projectRevision, final ApiCallback<Project> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateProjectValidateBeforeCall(projectId, projectRevision, _callback);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateProjectConfig
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param updateProjectConfigConfig  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulProjectConfigUpdate </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProjectConfigCall(String projectId, UpdateProjectConfigConfig updateProjectConfigConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateProjectConfigConfig;

        // create path and map variables
        String localVarPath = "/backoffice/public/projects/{project_id}/configs"
            .replaceAll("\\{" + "project_id" + "\\}", localVarApiClient.escapeString(projectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateProjectConfigValidateBeforeCall(String projectId, UpdateProjectConfigConfig updateProjectConfigConfig, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling updateProjectConfig(Async)");
        }
        

        okhttp3.Call localVarCall = updateProjectConfigCall(projectId, updateProjectConfigConfig, _callback);
        return localVarCall;

    }

    /**
     * Update an Ory Cloud Project Configuration
     * This endpoints allows you to update the Ory Cloud Project configuration for individual services (identity, permission, ...). The configuration is fully compatible with the open source projects for the respective services (e.g. Ory Kratos for Identity, Ory Keto for Permissions).  This endpoint expects the &#x60;version&#x60; key to be set in the payload. If it is unset, it will try to import the config as if it is from the most recent version.  If you have an older version of a configuration, you should set the version key in the payload!  While this endpoint is able to process all configuration items related to features (e.g. password reset), it does not support operational configuration items (e.g. port, tracing, logging) otherwise available in the open source.  For configuration items that can not be translated to Ory Cloud, this endpoint will return a list of warnings to help you understand which parts of your config could not be processed.  Be aware that updating any service&#39;s configuration will completely override your current configuration for that service!
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param updateProjectConfigConfig  (optional)
     * @return SuccessfulProjectConfigUpdate
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulProjectConfigUpdate </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public SuccessfulProjectConfigUpdate updateProjectConfig(String projectId, UpdateProjectConfigConfig updateProjectConfigConfig) throws ApiException {
        ApiResponse<SuccessfulProjectConfigUpdate> localVarResp = updateProjectConfigWithHttpInfo(projectId, updateProjectConfigConfig);
        return localVarResp.getData();
    }

    /**
     * Update an Ory Cloud Project Configuration
     * This endpoints allows you to update the Ory Cloud Project configuration for individual services (identity, permission, ...). The configuration is fully compatible with the open source projects for the respective services (e.g. Ory Kratos for Identity, Ory Keto for Permissions).  This endpoint expects the &#x60;version&#x60; key to be set in the payload. If it is unset, it will try to import the config as if it is from the most recent version.  If you have an older version of a configuration, you should set the version key in the payload!  While this endpoint is able to process all configuration items related to features (e.g. password reset), it does not support operational configuration items (e.g. port, tracing, logging) otherwise available in the open source.  For configuration items that can not be translated to Ory Cloud, this endpoint will return a list of warnings to help you understand which parts of your config could not be processed.  Be aware that updating any service&#39;s configuration will completely override your current configuration for that service!
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param updateProjectConfigConfig  (optional)
     * @return ApiResponse&lt;SuccessfulProjectConfigUpdate&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulProjectConfigUpdate </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SuccessfulProjectConfigUpdate> updateProjectConfigWithHttpInfo(String projectId, UpdateProjectConfigConfig updateProjectConfigConfig) throws ApiException {
        okhttp3.Call localVarCall = updateProjectConfigValidateBeforeCall(projectId, updateProjectConfigConfig, null);
        Type localVarReturnType = new TypeToken<SuccessfulProjectConfigUpdate>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update an Ory Cloud Project Configuration (asynchronously)
     * This endpoints allows you to update the Ory Cloud Project configuration for individual services (identity, permission, ...). The configuration is fully compatible with the open source projects for the respective services (e.g. Ory Kratos for Identity, Ory Keto for Permissions).  This endpoint expects the &#x60;version&#x60; key to be set in the payload. If it is unset, it will try to import the config as if it is from the most recent version.  If you have an older version of a configuration, you should set the version key in the payload!  While this endpoint is able to process all configuration items related to features (e.g. password reset), it does not support operational configuration items (e.g. port, tracing, logging) otherwise available in the open source.  For configuration items that can not be translated to Ory Cloud, this endpoint will return a list of warnings to help you understand which parts of your config could not be processed.  Be aware that updating any service&#39;s configuration will completely override your current configuration for that service!
     * @param projectId Project ID  The project&#39;s ID. (required)
     * @param updateProjectConfigConfig  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulProjectConfigUpdate </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> genericError </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> genericError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProjectConfigAsync(String projectId, UpdateProjectConfigConfig updateProjectConfigConfig, final ApiCallback<SuccessfulProjectConfigUpdate> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateProjectConfigValidateBeforeCall(projectId, updateProjectConfigConfig, _callback);
        Type localVarReturnType = new TypeToken<SuccessfulProjectConfigUpdate>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
