/*
 * Ory APIs
 * Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed with a valid Personal Access Token. Public APIs are mostly used in browsers. 
 *
 * The version of the OpenAPI document: v0.0.1-alpha.49
 * Contact: support@ory.sh
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package sh.ory.api;

import sh.ory.ApiCallback;
import sh.ory.ApiClient;
import sh.ory.ApiException;
import sh.ory.ApiResponse;
import sh.ory.Configuration;
import sh.ory.Pair;
import sh.ory.ProgressRequestBody;
import sh.ory.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import sh.ory.model.AdminCreateIdentityBody;
import sh.ory.model.AdminCreateSelfServiceRecoveryLinkBody;
import sh.ory.model.AdminUpdateIdentityBody;
import sh.ory.model.Identity;
import sh.ory.model.IdentitySchema;
import sh.ory.model.JsonError;
import sh.ory.model.RevokedSessions;
import sh.ory.model.SelfServiceBrowserLocationChangeRequiredError;
import sh.ory.model.SelfServiceError;
import sh.ory.model.SelfServiceLoginFlow;
import sh.ory.model.SelfServiceLogoutUrl;
import sh.ory.model.SelfServiceRecoveryFlow;
import sh.ory.model.SelfServiceRecoveryLink;
import sh.ory.model.SelfServiceRegistrationFlow;
import sh.ory.model.SelfServiceSettingsFlow;
import sh.ory.model.SelfServiceVerificationFlow;
import sh.ory.model.Session;
import sh.ory.model.SubmitSelfServiceLoginFlowBody;
import sh.ory.model.SubmitSelfServiceLogoutFlowWithoutBrowserBody;
import sh.ory.model.SubmitSelfServiceRecoveryFlowBody;
import sh.ory.model.SubmitSelfServiceRegistrationFlowBody;
import sh.ory.model.SubmitSelfServiceSettingsFlowBody;
import sh.ory.model.SubmitSelfServiceVerificationFlowBody;
import sh.ory.model.SuccessfulSelfServiceLoginWithoutBrowser;
import sh.ory.model.SuccessfulSelfServiceRegistrationWithoutBrowser;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class V0alpha2Api {
    private ApiClient localVarApiClient;

    public V0alpha2Api() {
        this(Configuration.getDefaultApiClient());
    }

    public V0alpha2Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for adminCreateIdentity
     * @param adminCreateIdentityBody  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminCreateIdentityCall(AdminCreateIdentityBody adminCreateIdentityBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = adminCreateIdentityBody;

        // create path and map variables
        String localVarPath = "/api/kratos/admin/identities";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call adminCreateIdentityValidateBeforeCall(AdminCreateIdentityBody adminCreateIdentityBody, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = adminCreateIdentityCall(adminCreateIdentityBody, _callback);
        return localVarCall;

    }

    /**
     * Create an Identity
     * This endpoint creates an identity. It is NOT possible to set an identity&#39;s credentials (password, ...) using this method! A way to achieve that will be introduced in the future.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param adminCreateIdentityBody  (optional)
     * @return Identity
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public Identity adminCreateIdentity(AdminCreateIdentityBody adminCreateIdentityBody) throws ApiException {
        ApiResponse<Identity> localVarResp = adminCreateIdentityWithHttpInfo(adminCreateIdentityBody);
        return localVarResp.getData();
    }

    /**
     * Create an Identity
     * This endpoint creates an identity. It is NOT possible to set an identity&#39;s credentials (password, ...) using this method! A way to achieve that will be introduced in the future.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param adminCreateIdentityBody  (optional)
     * @return ApiResponse&lt;Identity&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Identity> adminCreateIdentityWithHttpInfo(AdminCreateIdentityBody adminCreateIdentityBody) throws ApiException {
        okhttp3.Call localVarCall = adminCreateIdentityValidateBeforeCall(adminCreateIdentityBody, null);
        Type localVarReturnType = new TypeToken<Identity>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an Identity (asynchronously)
     * This endpoint creates an identity. It is NOT possible to set an identity&#39;s credentials (password, ...) using this method! A way to achieve that will be introduced in the future.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param adminCreateIdentityBody  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminCreateIdentityAsync(AdminCreateIdentityBody adminCreateIdentityBody, final ApiCallback<Identity> _callback) throws ApiException {

        okhttp3.Call localVarCall = adminCreateIdentityValidateBeforeCall(adminCreateIdentityBody, _callback);
        Type localVarReturnType = new TypeToken<Identity>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for adminCreateSelfServiceRecoveryLink
     * @param adminCreateSelfServiceRecoveryLinkBody  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryLink </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminCreateSelfServiceRecoveryLinkCall(AdminCreateSelfServiceRecoveryLinkBody adminCreateSelfServiceRecoveryLinkBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = adminCreateSelfServiceRecoveryLinkBody;

        // create path and map variables
        String localVarPath = "/api/kratos/admin/recovery/link";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call adminCreateSelfServiceRecoveryLinkValidateBeforeCall(AdminCreateSelfServiceRecoveryLinkBody adminCreateSelfServiceRecoveryLinkBody, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = adminCreateSelfServiceRecoveryLinkCall(adminCreateSelfServiceRecoveryLinkBody, _callback);
        return localVarCall;

    }

    /**
     * Create a Recovery Link
     * This endpoint creates a recovery link which should be given to the user in order for them to recover (or activate) their account.
     * @param adminCreateSelfServiceRecoveryLinkBody  (optional)
     * @return SelfServiceRecoveryLink
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryLink </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceRecoveryLink adminCreateSelfServiceRecoveryLink(AdminCreateSelfServiceRecoveryLinkBody adminCreateSelfServiceRecoveryLinkBody) throws ApiException {
        ApiResponse<SelfServiceRecoveryLink> localVarResp = adminCreateSelfServiceRecoveryLinkWithHttpInfo(adminCreateSelfServiceRecoveryLinkBody);
        return localVarResp.getData();
    }

    /**
     * Create a Recovery Link
     * This endpoint creates a recovery link which should be given to the user in order for them to recover (or activate) their account.
     * @param adminCreateSelfServiceRecoveryLinkBody  (optional)
     * @return ApiResponse&lt;SelfServiceRecoveryLink&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryLink </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceRecoveryLink> adminCreateSelfServiceRecoveryLinkWithHttpInfo(AdminCreateSelfServiceRecoveryLinkBody adminCreateSelfServiceRecoveryLinkBody) throws ApiException {
        okhttp3.Call localVarCall = adminCreateSelfServiceRecoveryLinkValidateBeforeCall(adminCreateSelfServiceRecoveryLinkBody, null);
        Type localVarReturnType = new TypeToken<SelfServiceRecoveryLink>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a Recovery Link (asynchronously)
     * This endpoint creates a recovery link which should be given to the user in order for them to recover (or activate) their account.
     * @param adminCreateSelfServiceRecoveryLinkBody  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryLink </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminCreateSelfServiceRecoveryLinkAsync(AdminCreateSelfServiceRecoveryLinkBody adminCreateSelfServiceRecoveryLinkBody, final ApiCallback<SelfServiceRecoveryLink> _callback) throws ApiException {

        okhttp3.Call localVarCall = adminCreateSelfServiceRecoveryLinkValidateBeforeCall(adminCreateSelfServiceRecoveryLinkBody, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceRecoveryLink>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for adminDeleteIdentity
     * @param id ID is the identity&#39;s ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminDeleteIdentityCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/admin/identities/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call adminDeleteIdentityValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling adminDeleteIdentity(Async)");
        }
        

        okhttp3.Call localVarCall = adminDeleteIdentityCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete an Identity
     * Calling this endpoint irrecoverably and permanently deletes the identity given its ID. This action can not be undone. This endpoint returns 204 when the identity was deleted or when the identity was not found, in which case it is assumed that is has been deleted already.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param id ID is the identity&#39;s ID. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public void adminDeleteIdentity(String id) throws ApiException {
        adminDeleteIdentityWithHttpInfo(id);
    }

    /**
     * Delete an Identity
     * Calling this endpoint irrecoverably and permanently deletes the identity given its ID. This action can not be undone. This endpoint returns 204 when the identity was deleted or when the identity was not found, in which case it is assumed that is has been deleted already.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param id ID is the identity&#39;s ID. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> adminDeleteIdentityWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = adminDeleteIdentityValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete an Identity (asynchronously)
     * Calling this endpoint irrecoverably and permanently deletes the identity given its ID. This action can not be undone. This endpoint returns 204 when the identity was deleted or when the identity was not found, in which case it is assumed that is has been deleted already.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param id ID is the identity&#39;s ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminDeleteIdentityAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = adminDeleteIdentityValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for adminDeleteIdentitySessions
     * @param id ID is the identity&#39;s ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminDeleteIdentitySessionsCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/admin/identities/{id}/sessions"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call adminDeleteIdentitySessionsValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling adminDeleteIdentitySessions(Async)");
        }
        

        okhttp3.Call localVarCall = adminDeleteIdentitySessionsCall(id, _callback);
        return localVarCall;

    }

    /**
     * Calling this endpoint irrecoverably and permanently deletes and invalidates all sessions that belong to the given Identity.
     * This endpoint is useful for:  To forcefully logout Identity from all devices and sessions
     * @param id ID is the identity&#39;s ID. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public void adminDeleteIdentitySessions(String id) throws ApiException {
        adminDeleteIdentitySessionsWithHttpInfo(id);
    }

    /**
     * Calling this endpoint irrecoverably and permanently deletes and invalidates all sessions that belong to the given Identity.
     * This endpoint is useful for:  To forcefully logout Identity from all devices and sessions
     * @param id ID is the identity&#39;s ID. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> adminDeleteIdentitySessionsWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = adminDeleteIdentitySessionsValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Calling this endpoint irrecoverably and permanently deletes and invalidates all sessions that belong to the given Identity. (asynchronously)
     * This endpoint is useful for:  To forcefully logout Identity from all devices and sessions
     * @param id ID is the identity&#39;s ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminDeleteIdentitySessionsAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = adminDeleteIdentitySessionsValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for adminGetIdentity
     * @param id ID must be set to the ID of identity you want to get (required)
     * @param includeCredential DeclassifyCredentials will declassify one or more identity&#39;s credentials  Currently, only &#x60;oidc&#x60; is supported. This will return the initial OAuth 2.0 Access, Refresh and (optionally) OpenID Connect ID Token. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminGetIdentityCall(String id, List<String> includeCredential, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/admin/identities/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (includeCredential != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "include_credential", includeCredential));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call adminGetIdentityValidateBeforeCall(String id, List<String> includeCredential, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling adminGetIdentity(Async)");
        }
        

        okhttp3.Call localVarCall = adminGetIdentityCall(id, includeCredential, _callback);
        return localVarCall;

    }

    /**
     * Get an Identity
     * Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param id ID must be set to the ID of identity you want to get (required)
     * @param includeCredential DeclassifyCredentials will declassify one or more identity&#39;s credentials  Currently, only &#x60;oidc&#x60; is supported. This will return the initial OAuth 2.0 Access, Refresh and (optionally) OpenID Connect ID Token. (optional)
     * @return Identity
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public Identity adminGetIdentity(String id, List<String> includeCredential) throws ApiException {
        ApiResponse<Identity> localVarResp = adminGetIdentityWithHttpInfo(id, includeCredential);
        return localVarResp.getData();
    }

    /**
     * Get an Identity
     * Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param id ID must be set to the ID of identity you want to get (required)
     * @param includeCredential DeclassifyCredentials will declassify one or more identity&#39;s credentials  Currently, only &#x60;oidc&#x60; is supported. This will return the initial OAuth 2.0 Access, Refresh and (optionally) OpenID Connect ID Token. (optional)
     * @return ApiResponse&lt;Identity&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Identity> adminGetIdentityWithHttpInfo(String id, List<String> includeCredential) throws ApiException {
        okhttp3.Call localVarCall = adminGetIdentityValidateBeforeCall(id, includeCredential, null);
        Type localVarReturnType = new TypeToken<Identity>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an Identity (asynchronously)
     * Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param id ID must be set to the ID of identity you want to get (required)
     * @param includeCredential DeclassifyCredentials will declassify one or more identity&#39;s credentials  Currently, only &#x60;oidc&#x60; is supported. This will return the initial OAuth 2.0 Access, Refresh and (optionally) OpenID Connect ID Token. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminGetIdentityAsync(String id, List<String> includeCredential, final ApiCallback<Identity> _callback) throws ApiException {

        okhttp3.Call localVarCall = adminGetIdentityValidateBeforeCall(id, includeCredential, _callback);
        Type localVarReturnType = new TypeToken<Identity>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for adminListIdentities
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identityList </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminListIdentitiesCall(Long perPage, Long page, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/admin/identities";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call adminListIdentitiesValidateBeforeCall(Long perPage, Long page, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = adminListIdentitiesCall(perPage, page, _callback);
        return localVarCall;

    }

    /**
     * List Identities
     * Lists all identities. Does not support search at the moment.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @return List&lt;Identity&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identityList </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public List<Identity> adminListIdentities(Long perPage, Long page) throws ApiException {
        ApiResponse<List<Identity>> localVarResp = adminListIdentitiesWithHttpInfo(perPage, page);
        return localVarResp.getData();
    }

    /**
     * List Identities
     * Lists all identities. Does not support search at the moment.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @return ApiResponse&lt;List&lt;Identity&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identityList </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Identity>> adminListIdentitiesWithHttpInfo(Long perPage, Long page) throws ApiException {
        okhttp3.Call localVarCall = adminListIdentitiesValidateBeforeCall(perPage, page, null);
        Type localVarReturnType = new TypeToken<List<Identity>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List Identities (asynchronously)
     * Lists all identities. Does not support search at the moment.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identityList </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminListIdentitiesAsync(Long perPage, Long page, final ApiCallback<List<Identity>> _callback) throws ApiException {

        okhttp3.Call localVarCall = adminListIdentitiesValidateBeforeCall(perPage, page, _callback);
        Type localVarReturnType = new TypeToken<List<Identity>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for adminListIdentitySessions
     * @param id ID is the identity&#39;s ID. (required)
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @param active Active is a boolean flag that filters out sessions based on the state. If no value is provided, all sessions are returned. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> sessionList </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminListIdentitySessionsCall(String id, Long perPage, Long page, Boolean active, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/admin/identities/{id}/sessions"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call adminListIdentitySessionsValidateBeforeCall(String id, Long perPage, Long page, Boolean active, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling adminListIdentitySessions(Async)");
        }
        

        okhttp3.Call localVarCall = adminListIdentitySessionsCall(id, perPage, page, active, _callback);
        return localVarCall;

    }

    /**
     * This endpoint returns all sessions that belong to the given Identity.
     * This endpoint is useful for:  Listing all sessions that belong to an Identity in an administrative context.
     * @param id ID is the identity&#39;s ID. (required)
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @param active Active is a boolean flag that filters out sessions based on the state. If no value is provided, all sessions are returned. (optional)
     * @return List&lt;Session&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> sessionList </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public List<Session> adminListIdentitySessions(String id, Long perPage, Long page, Boolean active) throws ApiException {
        ApiResponse<List<Session>> localVarResp = adminListIdentitySessionsWithHttpInfo(id, perPage, page, active);
        return localVarResp.getData();
    }

    /**
     * This endpoint returns all sessions that belong to the given Identity.
     * This endpoint is useful for:  Listing all sessions that belong to an Identity in an administrative context.
     * @param id ID is the identity&#39;s ID. (required)
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @param active Active is a boolean flag that filters out sessions based on the state. If no value is provided, all sessions are returned. (optional)
     * @return ApiResponse&lt;List&lt;Session&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> sessionList </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Session>> adminListIdentitySessionsWithHttpInfo(String id, Long perPage, Long page, Boolean active) throws ApiException {
        okhttp3.Call localVarCall = adminListIdentitySessionsValidateBeforeCall(id, perPage, page, active, null);
        Type localVarReturnType = new TypeToken<List<Session>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * This endpoint returns all sessions that belong to the given Identity. (asynchronously)
     * This endpoint is useful for:  Listing all sessions that belong to an Identity in an administrative context.
     * @param id ID is the identity&#39;s ID. (required)
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @param active Active is a boolean flag that filters out sessions based on the state. If no value is provided, all sessions are returned. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> sessionList </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminListIdentitySessionsAsync(String id, Long perPage, Long page, Boolean active, final ApiCallback<List<Session>> _callback) throws ApiException {

        okhttp3.Call localVarCall = adminListIdentitySessionsValidateBeforeCall(id, perPage, page, active, _callback);
        Type localVarReturnType = new TypeToken<List<Session>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for adminUpdateIdentity
     * @param id ID must be set to the ID of identity you want to update (required)
     * @param adminUpdateIdentityBody  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminUpdateIdentityCall(String id, AdminUpdateIdentityBody adminUpdateIdentityBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = adminUpdateIdentityBody;

        // create path and map variables
        String localVarPath = "/api/kratos/admin/identities/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "oryAccessToken" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call adminUpdateIdentityValidateBeforeCall(String id, AdminUpdateIdentityBody adminUpdateIdentityBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling adminUpdateIdentity(Async)");
        }
        

        okhttp3.Call localVarCall = adminUpdateIdentityCall(id, adminUpdateIdentityBody, _callback);
        return localVarCall;

    }

    /**
     * Update an Identity
     * This endpoint updates an identity. It is NOT possible to set an identity&#39;s credentials (password, ...) using this method! A way to achieve that will be introduced in the future.  The full identity payload (except credentials) is expected. This endpoint does not support patching.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param id ID must be set to the ID of identity you want to update (required)
     * @param adminUpdateIdentityBody  (optional)
     * @return Identity
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public Identity adminUpdateIdentity(String id, AdminUpdateIdentityBody adminUpdateIdentityBody) throws ApiException {
        ApiResponse<Identity> localVarResp = adminUpdateIdentityWithHttpInfo(id, adminUpdateIdentityBody);
        return localVarResp.getData();
    }

    /**
     * Update an Identity
     * This endpoint updates an identity. It is NOT possible to set an identity&#39;s credentials (password, ...) using this method! A way to achieve that will be introduced in the future.  The full identity payload (except credentials) is expected. This endpoint does not support patching.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param id ID must be set to the ID of identity you want to update (required)
     * @param adminUpdateIdentityBody  (optional)
     * @return ApiResponse&lt;Identity&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Identity> adminUpdateIdentityWithHttpInfo(String id, AdminUpdateIdentityBody adminUpdateIdentityBody) throws ApiException {
        okhttp3.Call localVarCall = adminUpdateIdentityValidateBeforeCall(id, adminUpdateIdentityBody, null);
        Type localVarReturnType = new TypeToken<Identity>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update an Identity (asynchronously)
     * This endpoint updates an identity. It is NOT possible to set an identity&#39;s credentials (password, ...) using this method! A way to achieve that will be introduced in the future.  The full identity payload (except credentials) is expected. This endpoint does not support patching.  Learn how identities work in [Ory Kratos&#39; User And Identity Model Documentation](https://www.ory.sh/docs/next/kratos/concepts/identity-user-model).
     * @param id ID must be set to the ID of identity you want to update (required)
     * @param adminUpdateIdentityBody  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identity </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminUpdateIdentityAsync(String id, AdminUpdateIdentityBody adminUpdateIdentityBody, final ApiCallback<Identity> _callback) throws ApiException {

        okhttp3.Call localVarCall = adminUpdateIdentityValidateBeforeCall(id, adminUpdateIdentityBody, _callback);
        Type localVarReturnType = new TypeToken<Identity>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createSelfServiceLogoutFlowUrlForBrowsers
     * @param cookie HTTP Cookies  If you call this endpoint from a backend, please include the original Cookie header in the request. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLogoutUrl </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSelfServiceLogoutFlowUrlForBrowsersCall(String cookie, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/logout/browser";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (cookie != null) {
            localVarHeaderParams.put("cookie", localVarApiClient.parameterToString(cookie));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createSelfServiceLogoutFlowUrlForBrowsersValidateBeforeCall(String cookie, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createSelfServiceLogoutFlowUrlForBrowsersCall(cookie, _callback);
        return localVarCall;

    }

    /**
     * Create a Logout URL for Browsers
     * This endpoint initializes a browser-based user logout flow and a URL which can be used to log out the user.  This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...). For API clients you can call the &#x60;/self-service/logout/api&#x60; URL directly with the Ory Session Token.  The URL is only valid for the currently signed in user. If no user is signed in, this endpoint returns a 401 error.  When calling this endpoint from a backend, please ensure to properly forward the HTTP cookies.
     * @param cookie HTTP Cookies  If you call this endpoint from a backend, please include the original Cookie header in the request. (optional)
     * @return SelfServiceLogoutUrl
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLogoutUrl </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceLogoutUrl createSelfServiceLogoutFlowUrlForBrowsers(String cookie) throws ApiException {
        ApiResponse<SelfServiceLogoutUrl> localVarResp = createSelfServiceLogoutFlowUrlForBrowsersWithHttpInfo(cookie);
        return localVarResp.getData();
    }

    /**
     * Create a Logout URL for Browsers
     * This endpoint initializes a browser-based user logout flow and a URL which can be used to log out the user.  This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...). For API clients you can call the &#x60;/self-service/logout/api&#x60; URL directly with the Ory Session Token.  The URL is only valid for the currently signed in user. If no user is signed in, this endpoint returns a 401 error.  When calling this endpoint from a backend, please ensure to properly forward the HTTP cookies.
     * @param cookie HTTP Cookies  If you call this endpoint from a backend, please include the original Cookie header in the request. (optional)
     * @return ApiResponse&lt;SelfServiceLogoutUrl&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLogoutUrl </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceLogoutUrl> createSelfServiceLogoutFlowUrlForBrowsersWithHttpInfo(String cookie) throws ApiException {
        okhttp3.Call localVarCall = createSelfServiceLogoutFlowUrlForBrowsersValidateBeforeCall(cookie, null);
        Type localVarReturnType = new TypeToken<SelfServiceLogoutUrl>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a Logout URL for Browsers (asynchronously)
     * This endpoint initializes a browser-based user logout flow and a URL which can be used to log out the user.  This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...). For API clients you can call the &#x60;/self-service/logout/api&#x60; URL directly with the Ory Session Token.  The URL is only valid for the currently signed in user. If no user is signed in, this endpoint returns a 401 error.  When calling this endpoint from a backend, please ensure to properly forward the HTTP cookies.
     * @param cookie HTTP Cookies  If you call this endpoint from a backend, please include the original Cookie header in the request. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLogoutUrl </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSelfServiceLogoutFlowUrlForBrowsersAsync(String cookie, final ApiCallback<SelfServiceLogoutUrl> _callback) throws ApiException {

        okhttp3.Call localVarCall = createSelfServiceLogoutFlowUrlForBrowsersValidateBeforeCall(cookie, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceLogoutUrl>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getJsonSchema
     * @param id ID must be set to the ID of schema you want to get (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> jsonSchema </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJsonSchemaCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/schemas/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getJsonSchemaValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getJsonSchema(Async)");
        }
        

        okhttp3.Call localVarCall = getJsonSchemaCall(id, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get a JSON Schema
     * @param id ID must be set to the ID of schema you want to get (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> jsonSchema </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public Object getJsonSchema(String id) throws ApiException {
        ApiResponse<Object> localVarResp = getJsonSchemaWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * 
     * Get a JSON Schema
     * @param id ID must be set to the ID of schema you want to get (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> jsonSchema </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> getJsonSchemaWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getJsonSchemaValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get a JSON Schema
     * @param id ID must be set to the ID of schema you want to get (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> jsonSchema </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJsonSchemaAsync(String id, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = getJsonSchemaValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSelfServiceError
     * @param id Error is the error&#39;s ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceErrorCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/errors";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSelfServiceErrorValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSelfServiceError(Async)");
        }
        

        okhttp3.Call localVarCall = getSelfServiceErrorCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Self-Service Errors
     * This endpoint returns the error associated with a user-facing self service errors.  This endpoint supports stub values to help you implement the error UI:  &#x60;?id&#x3D;stub:500&#x60; - returns a stub 500 (Internal Server Error) error.  More information can be found at [Ory Kratos User User Facing Error Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-facing-errors).
     * @param id Error is the error&#39;s ID (required)
     * @return SelfServiceError
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceError getSelfServiceError(String id) throws ApiException {
        ApiResponse<SelfServiceError> localVarResp = getSelfServiceErrorWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Self-Service Errors
     * This endpoint returns the error associated with a user-facing self service errors.  This endpoint supports stub values to help you implement the error UI:  &#x60;?id&#x3D;stub:500&#x60; - returns a stub 500 (Internal Server Error) error.  More information can be found at [Ory Kratos User User Facing Error Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-facing-errors).
     * @param id Error is the error&#39;s ID (required)
     * @return ApiResponse&lt;SelfServiceError&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceError> getSelfServiceErrorWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getSelfServiceErrorValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<SelfServiceError>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Self-Service Errors (asynchronously)
     * This endpoint returns the error associated with a user-facing self service errors.  This endpoint supports stub values to help you implement the error UI:  &#x60;?id&#x3D;stub:500&#x60; - returns a stub 500 (Internal Server Error) error.  More information can be found at [Ory Kratos User User Facing Error Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-facing-errors).
     * @param id Error is the error&#39;s ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceErrorAsync(String id, final ApiCallback<SelfServiceError> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSelfServiceErrorValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceError>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSelfServiceLoginFlow
     * @param id The Login Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/login?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceLoginFlowCall(String id, String cookie, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/login/flows";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (cookie != null) {
            localVarHeaderParams.put("cookie", localVarApiClient.parameterToString(cookie));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSelfServiceLoginFlowValidateBeforeCall(String id, String cookie, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSelfServiceLoginFlow(Async)");
        }
        

        okhttp3.Call localVarCall = getSelfServiceLoginFlowCall(id, cookie, _callback);
        return localVarCall;

    }

    /**
     * Get Login Flow
     * This endpoint returns a login flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/login&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceLoginFlow(req.header(&#39;cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;login&#39;, flow) }) &#x60;&#x60;&#x60;  This request may fail due to several reasons. The &#x60;error.id&#x60; can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;self_service_flow_expired&#x60;: The flow is expired and you should request a new one.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param id The Login Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/login?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @return SelfServiceLoginFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceLoginFlow getSelfServiceLoginFlow(String id, String cookie) throws ApiException {
        ApiResponse<SelfServiceLoginFlow> localVarResp = getSelfServiceLoginFlowWithHttpInfo(id, cookie);
        return localVarResp.getData();
    }

    /**
     * Get Login Flow
     * This endpoint returns a login flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/login&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceLoginFlow(req.header(&#39;cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;login&#39;, flow) }) &#x60;&#x60;&#x60;  This request may fail due to several reasons. The &#x60;error.id&#x60; can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;self_service_flow_expired&#x60;: The flow is expired and you should request a new one.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param id The Login Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/login?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @return ApiResponse&lt;SelfServiceLoginFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceLoginFlow> getSelfServiceLoginFlowWithHttpInfo(String id, String cookie) throws ApiException {
        okhttp3.Call localVarCall = getSelfServiceLoginFlowValidateBeforeCall(id, cookie, null);
        Type localVarReturnType = new TypeToken<SelfServiceLoginFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Login Flow (asynchronously)
     * This endpoint returns a login flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/login&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceLoginFlow(req.header(&#39;cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;login&#39;, flow) }) &#x60;&#x60;&#x60;  This request may fail due to several reasons. The &#x60;error.id&#x60; can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;self_service_flow_expired&#x60;: The flow is expired and you should request a new one.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param id The Login Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/login?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceLoginFlowAsync(String id, String cookie, final ApiCallback<SelfServiceLoginFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSelfServiceLoginFlowValidateBeforeCall(id, cookie, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceLoginFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSelfServiceRecoveryFlow
     * @param id The Flow ID  The value for this parameter comes from &#x60;request&#x60; URL Query parameter sent to your application (e.g. &#x60;/recovery?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceRecoveryFlowCall(String id, String cookie, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/recovery/flows";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (cookie != null) {
            localVarHeaderParams.put("cookie", localVarApiClient.parameterToString(cookie));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSelfServiceRecoveryFlowValidateBeforeCall(String id, String cookie, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSelfServiceRecoveryFlow(Async)");
        }
        

        okhttp3.Call localVarCall = getSelfServiceRecoveryFlowCall(id, cookie, _callback);
        return localVarCall;

    }

    /**
     * Get Recovery Flow
     * This endpoint returns a recovery flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/recovery&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceRecoveryFlow(req.header(&#39;Cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;recovery&#39;, flow) }) &#x60;&#x60;&#x60;  More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @param id The Flow ID  The value for this parameter comes from &#x60;request&#x60; URL Query parameter sent to your application (e.g. &#x60;/recovery?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @return SelfServiceRecoveryFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceRecoveryFlow getSelfServiceRecoveryFlow(String id, String cookie) throws ApiException {
        ApiResponse<SelfServiceRecoveryFlow> localVarResp = getSelfServiceRecoveryFlowWithHttpInfo(id, cookie);
        return localVarResp.getData();
    }

    /**
     * Get Recovery Flow
     * This endpoint returns a recovery flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/recovery&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceRecoveryFlow(req.header(&#39;Cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;recovery&#39;, flow) }) &#x60;&#x60;&#x60;  More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @param id The Flow ID  The value for this parameter comes from &#x60;request&#x60; URL Query parameter sent to your application (e.g. &#x60;/recovery?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @return ApiResponse&lt;SelfServiceRecoveryFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceRecoveryFlow> getSelfServiceRecoveryFlowWithHttpInfo(String id, String cookie) throws ApiException {
        okhttp3.Call localVarCall = getSelfServiceRecoveryFlowValidateBeforeCall(id, cookie, null);
        Type localVarReturnType = new TypeToken<SelfServiceRecoveryFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Recovery Flow (asynchronously)
     * This endpoint returns a recovery flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/recovery&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceRecoveryFlow(req.header(&#39;Cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;recovery&#39;, flow) }) &#x60;&#x60;&#x60;  More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @param id The Flow ID  The value for this parameter comes from &#x60;request&#x60; URL Query parameter sent to your application (e.g. &#x60;/recovery?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceRecoveryFlowAsync(String id, String cookie, final ApiCallback<SelfServiceRecoveryFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSelfServiceRecoveryFlowValidateBeforeCall(id, cookie, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceRecoveryFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSelfServiceRegistrationFlow
     * @param id The Registration Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/registration?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceRegistrationFlowCall(String id, String cookie, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/registration/flows";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (cookie != null) {
            localVarHeaderParams.put("cookie", localVarApiClient.parameterToString(cookie));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSelfServiceRegistrationFlowValidateBeforeCall(String id, String cookie, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSelfServiceRegistrationFlow(Async)");
        }
        

        okhttp3.Call localVarCall = getSelfServiceRegistrationFlowCall(id, cookie, _callback);
        return localVarCall;

    }

    /**
     * Get Registration Flow
     * This endpoint returns a registration flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/registration&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceRegistrationFlow(req.header(&#39;cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;registration&#39;, flow) }) &#x60;&#x60;&#x60;  This request may fail due to several reasons. The &#x60;error.id&#x60; can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;self_service_flow_expired&#x60;: The flow is expired and you should request a new one.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param id The Registration Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/registration?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @return SelfServiceRegistrationFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceRegistrationFlow getSelfServiceRegistrationFlow(String id, String cookie) throws ApiException {
        ApiResponse<SelfServiceRegistrationFlow> localVarResp = getSelfServiceRegistrationFlowWithHttpInfo(id, cookie);
        return localVarResp.getData();
    }

    /**
     * Get Registration Flow
     * This endpoint returns a registration flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/registration&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceRegistrationFlow(req.header(&#39;cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;registration&#39;, flow) }) &#x60;&#x60;&#x60;  This request may fail due to several reasons. The &#x60;error.id&#x60; can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;self_service_flow_expired&#x60;: The flow is expired and you should request a new one.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param id The Registration Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/registration?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @return ApiResponse&lt;SelfServiceRegistrationFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceRegistrationFlow> getSelfServiceRegistrationFlowWithHttpInfo(String id, String cookie) throws ApiException {
        okhttp3.Call localVarCall = getSelfServiceRegistrationFlowValidateBeforeCall(id, cookie, null);
        Type localVarReturnType = new TypeToken<SelfServiceRegistrationFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Registration Flow (asynchronously)
     * This endpoint returns a registration flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/registration&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceRegistrationFlow(req.header(&#39;cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;registration&#39;, flow) }) &#x60;&#x60;&#x60;  This request may fail due to several reasons. The &#x60;error.id&#x60; can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;self_service_flow_expired&#x60;: The flow is expired and you should request a new one.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param id The Registration Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/registration?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceRegistrationFlowAsync(String id, String cookie, final ApiCallback<SelfServiceRegistrationFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSelfServiceRegistrationFlowValidateBeforeCall(id, cookie, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceRegistrationFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSelfServiceSettingsFlow
     * @param id ID is the Settings Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/settings?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token  When using the SDK in an app without a browser, please include the session token here. (optional)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. You only need to do this for browser- based flows. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceSettingsFlowCall(String id, String xSessionToken, String cookie, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/settings/flows";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (xSessionToken != null) {
            localVarHeaderParams.put("X-Session-Token", localVarApiClient.parameterToString(xSessionToken));
        }

        if (cookie != null) {
            localVarHeaderParams.put("cookie", localVarApiClient.parameterToString(cookie));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSelfServiceSettingsFlowValidateBeforeCall(String id, String xSessionToken, String cookie, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSelfServiceSettingsFlow(Async)");
        }
        

        okhttp3.Call localVarCall = getSelfServiceSettingsFlowCall(id, xSessionToken, cookie, _callback);
        return localVarCall;

    }

    /**
     * Get Settings Flow
     * When accessing this endpoint through Ory Kratos&#39; Public API you must ensure that either the Ory Kratos Session Cookie or the Ory Kratos Session Token are set.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor or change the configuration.  You can access this endpoint without credentials when using Ory Kratos&#39; Admin API.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first. &#x60;security_identity_mismatch&#x60;: The flow was interrupted with &#x60;session_refresh_required&#x60; but apparently some other identity logged in instead.  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param id ID is the Settings Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/settings?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token  When using the SDK in an app without a browser, please include the session token here. (optional)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. You only need to do this for browser- based flows. (optional)
     * @return SelfServiceSettingsFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceSettingsFlow getSelfServiceSettingsFlow(String id, String xSessionToken, String cookie) throws ApiException {
        ApiResponse<SelfServiceSettingsFlow> localVarResp = getSelfServiceSettingsFlowWithHttpInfo(id, xSessionToken, cookie);
        return localVarResp.getData();
    }

    /**
     * Get Settings Flow
     * When accessing this endpoint through Ory Kratos&#39; Public API you must ensure that either the Ory Kratos Session Cookie or the Ory Kratos Session Token are set.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor or change the configuration.  You can access this endpoint without credentials when using Ory Kratos&#39; Admin API.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first. &#x60;security_identity_mismatch&#x60;: The flow was interrupted with &#x60;session_refresh_required&#x60; but apparently some other identity logged in instead.  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param id ID is the Settings Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/settings?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token  When using the SDK in an app without a browser, please include the session token here. (optional)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. You only need to do this for browser- based flows. (optional)
     * @return ApiResponse&lt;SelfServiceSettingsFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceSettingsFlow> getSelfServiceSettingsFlowWithHttpInfo(String id, String xSessionToken, String cookie) throws ApiException {
        okhttp3.Call localVarCall = getSelfServiceSettingsFlowValidateBeforeCall(id, xSessionToken, cookie, null);
        Type localVarReturnType = new TypeToken<SelfServiceSettingsFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Settings Flow (asynchronously)
     * When accessing this endpoint through Ory Kratos&#39; Public API you must ensure that either the Ory Kratos Session Cookie or the Ory Kratos Session Token are set.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor or change the configuration.  You can access this endpoint without credentials when using Ory Kratos&#39; Admin API.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first. &#x60;security_identity_mismatch&#x60;: The flow was interrupted with &#x60;session_refresh_required&#x60; but apparently some other identity logged in instead.  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param id ID is the Settings Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/settings?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token  When using the SDK in an app without a browser, please include the session token here. (optional)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. You only need to do this for browser- based flows. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceSettingsFlowAsync(String id, String xSessionToken, String cookie, final ApiCallback<SelfServiceSettingsFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSelfServiceSettingsFlowValidateBeforeCall(id, xSessionToken, cookie, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceSettingsFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSelfServiceVerificationFlow
     * @param id The Flow ID  The value for this parameter comes from &#x60;request&#x60; URL Query parameter sent to your application (e.g. &#x60;/verification?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceVerificationFlowCall(String id, String cookie, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/verification/flows";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (cookie != null) {
            localVarHeaderParams.put("cookie", localVarApiClient.parameterToString(cookie));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSelfServiceVerificationFlowValidateBeforeCall(String id, String cookie, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSelfServiceVerificationFlow(Async)");
        }
        

        okhttp3.Call localVarCall = getSelfServiceVerificationFlowCall(id, cookie, _callback);
        return localVarCall;

    }

    /**
     * Get Verification Flow
     * This endpoint returns a verification flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/recovery&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceVerificationFlow(req.header(&#39;cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;verification&#39;, flow) })  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @param id The Flow ID  The value for this parameter comes from &#x60;request&#x60; URL Query parameter sent to your application (e.g. &#x60;/verification?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @return SelfServiceVerificationFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceVerificationFlow getSelfServiceVerificationFlow(String id, String cookie) throws ApiException {
        ApiResponse<SelfServiceVerificationFlow> localVarResp = getSelfServiceVerificationFlowWithHttpInfo(id, cookie);
        return localVarResp.getData();
    }

    /**
     * Get Verification Flow
     * This endpoint returns a verification flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/recovery&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceVerificationFlow(req.header(&#39;cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;verification&#39;, flow) })  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @param id The Flow ID  The value for this parameter comes from &#x60;request&#x60; URL Query parameter sent to your application (e.g. &#x60;/verification?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @return ApiResponse&lt;SelfServiceVerificationFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceVerificationFlow> getSelfServiceVerificationFlowWithHttpInfo(String id, String cookie) throws ApiException {
        okhttp3.Call localVarCall = getSelfServiceVerificationFlowValidateBeforeCall(id, cookie, null);
        Type localVarReturnType = new TypeToken<SelfServiceVerificationFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Verification Flow (asynchronously)
     * This endpoint returns a verification flow&#39;s context with, for example, error details and other information.  Browser flows expect the anti-CSRF cookie to be included in the request&#39;s HTTP Cookie Header. For AJAX requests you must ensure that cookies are included in the request or requests will fail.  If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain and you need to forward the incoming HTTP Cookie header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/recovery&#39;, async function (req, res) { const flow &#x3D; await client.getSelfServiceVerificationFlow(req.header(&#39;cookie&#39;), req.query[&#39;flow&#39;])  res.render(&#39;verification&#39;, flow) })  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @param id The Flow ID  The value for this parameter comes from &#x60;request&#x60; URL Query parameter sent to your application (e.g. &#x60;/verification?flow&#x3D;abcde&#x60;). (required)
     * @param cookie HTTP Cookies  When using the SDK on the server side you must include the HTTP Cookie Header originally sent to your HTTP handler here. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSelfServiceVerificationFlowAsync(String id, String cookie, final ApiCallback<SelfServiceVerificationFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSelfServiceVerificationFlowValidateBeforeCall(id, cookie, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceVerificationFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWebAuthnJavaScript
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> webAuthnJavaScript </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebAuthnJavaScriptCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/.well-known/ory/webauthn.js";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWebAuthnJavaScriptValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getWebAuthnJavaScriptCall(_callback);
        return localVarCall;

    }

    /**
     * Get WebAuthn JavaScript
     * This endpoint provides JavaScript which is needed in order to perform WebAuthn login and registration.  If you are building a JavaScript Browser App (e.g. in ReactJS or AngularJS) you will need to load this file:  &#x60;&#x60;&#x60;html &lt;script src&#x3D;\&quot;https://public-kratos.example.org/.well-known/ory/webauthn.js\&quot; type&#x3D;\&quot;script\&quot; async /&gt; &#x60;&#x60;&#x60;  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> webAuthnJavaScript </td><td>  -  </td></tr>
     </table>
     */
    public String getWebAuthnJavaScript() throws ApiException {
        ApiResponse<String> localVarResp = getWebAuthnJavaScriptWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get WebAuthn JavaScript
     * This endpoint provides JavaScript which is needed in order to perform WebAuthn login and registration.  If you are building a JavaScript Browser App (e.g. in ReactJS or AngularJS) you will need to load this file:  &#x60;&#x60;&#x60;html &lt;script src&#x3D;\&quot;https://public-kratos.example.org/.well-known/ory/webauthn.js\&quot; type&#x3D;\&quot;script\&quot; async /&gt; &#x60;&#x60;&#x60;  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> webAuthnJavaScript </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> getWebAuthnJavaScriptWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getWebAuthnJavaScriptValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get WebAuthn JavaScript (asynchronously)
     * This endpoint provides JavaScript which is needed in order to perform WebAuthn login and registration.  If you are building a JavaScript Browser App (e.g. in ReactJS or AngularJS) you will need to load this file:  &#x60;&#x60;&#x60;html &lt;script src&#x3D;\&quot;https://public-kratos.example.org/.well-known/ory/webauthn.js\&quot; type&#x3D;\&quot;script\&quot; async /&gt; &#x60;&#x60;&#x60;  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> webAuthnJavaScript </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebAuthnJavaScriptAsync(final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWebAuthnJavaScriptValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for initializeSelfServiceLoginFlowForBrowsers
     * @param refresh Refresh a login session  If set to true, this will refresh an existing login session by asking the user to sign in again. This will reset the authenticated_at time of the session. (optional)
     * @param aal Request a Specific AuthenticationMethod Assurance Level  Use this parameter to upgrade an existing session&#39;s authenticator assurance level (AAL). This allows you to ask for multi-factor authentication. When an identity sign in using e.g. username+password, the AAL is 1. If you wish to \&quot;upgrade\&quot; the session&#39;s security by asking the user to perform TOTP / WebAuth/ ... you would set this to \&quot;aal2\&quot;. (optional)
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceLoginFlowForBrowsersCall(Boolean refresh, String aal, String returnTo, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/login/browser";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (refresh != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("refresh", refresh));
        }

        if (aal != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("aal", aal));
        }

        if (returnTo != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("return_to", returnTo));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call initializeSelfServiceLoginFlowForBrowsersValidateBeforeCall(Boolean refresh, String aal, String returnTo, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = initializeSelfServiceLoginFlowForBrowsersCall(refresh, aal, returnTo, _callback);
        return localVarCall;

    }

    /**
     * Initialize Login Flow for Browsers
     * This endpoint initializes a browser-based user login flow. This endpoint will set the appropriate cookies and anti-CSRF measures required for browser-based flows.  If this endpoint is opened as a link in the browser, it will be redirected to &#x60;selfservice.flows.login.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If a valid user session exists already, the browser will be redirected to &#x60;urls.default_redirect_url&#x60; unless the query parameter &#x60;?refresh&#x3D;true&#x60; was set.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;session_aal1_required&#x60;: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration!  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param refresh Refresh a login session  If set to true, this will refresh an existing login session by asking the user to sign in again. This will reset the authenticated_at time of the session. (optional)
     * @param aal Request a Specific AuthenticationMethod Assurance Level  Use this parameter to upgrade an existing session&#39;s authenticator assurance level (AAL). This allows you to ask for multi-factor authentication. When an identity sign in using e.g. username+password, the AAL is 1. If you wish to \&quot;upgrade\&quot; the session&#39;s security by asking the user to perform TOTP / WebAuth/ ... you would set this to \&quot;aal2\&quot;. (optional)
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @return SelfServiceLoginFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceLoginFlow initializeSelfServiceLoginFlowForBrowsers(Boolean refresh, String aal, String returnTo) throws ApiException {
        ApiResponse<SelfServiceLoginFlow> localVarResp = initializeSelfServiceLoginFlowForBrowsersWithHttpInfo(refresh, aal, returnTo);
        return localVarResp.getData();
    }

    /**
     * Initialize Login Flow for Browsers
     * This endpoint initializes a browser-based user login flow. This endpoint will set the appropriate cookies and anti-CSRF measures required for browser-based flows.  If this endpoint is opened as a link in the browser, it will be redirected to &#x60;selfservice.flows.login.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If a valid user session exists already, the browser will be redirected to &#x60;urls.default_redirect_url&#x60; unless the query parameter &#x60;?refresh&#x3D;true&#x60; was set.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;session_aal1_required&#x60;: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration!  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param refresh Refresh a login session  If set to true, this will refresh an existing login session by asking the user to sign in again. This will reset the authenticated_at time of the session. (optional)
     * @param aal Request a Specific AuthenticationMethod Assurance Level  Use this parameter to upgrade an existing session&#39;s authenticator assurance level (AAL). This allows you to ask for multi-factor authentication. When an identity sign in using e.g. username+password, the AAL is 1. If you wish to \&quot;upgrade\&quot; the session&#39;s security by asking the user to perform TOTP / WebAuth/ ... you would set this to \&quot;aal2\&quot;. (optional)
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @return ApiResponse&lt;SelfServiceLoginFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceLoginFlow> initializeSelfServiceLoginFlowForBrowsersWithHttpInfo(Boolean refresh, String aal, String returnTo) throws ApiException {
        okhttp3.Call localVarCall = initializeSelfServiceLoginFlowForBrowsersValidateBeforeCall(refresh, aal, returnTo, null);
        Type localVarReturnType = new TypeToken<SelfServiceLoginFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initialize Login Flow for Browsers (asynchronously)
     * This endpoint initializes a browser-based user login flow. This endpoint will set the appropriate cookies and anti-CSRF measures required for browser-based flows.  If this endpoint is opened as a link in the browser, it will be redirected to &#x60;selfservice.flows.login.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If a valid user session exists already, the browser will be redirected to &#x60;urls.default_redirect_url&#x60; unless the query parameter &#x60;?refresh&#x3D;true&#x60; was set.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;session_aal1_required&#x60;: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration!  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param refresh Refresh a login session  If set to true, this will refresh an existing login session by asking the user to sign in again. This will reset the authenticated_at time of the session. (optional)
     * @param aal Request a Specific AuthenticationMethod Assurance Level  Use this parameter to upgrade an existing session&#39;s authenticator assurance level (AAL). This allows you to ask for multi-factor authentication. When an identity sign in using e.g. username+password, the AAL is 1. If you wish to \&quot;upgrade\&quot; the session&#39;s security by asking the user to perform TOTP / WebAuth/ ... you would set this to \&quot;aal2\&quot;. (optional)
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceLoginFlowForBrowsersAsync(Boolean refresh, String aal, String returnTo, final ApiCallback<SelfServiceLoginFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = initializeSelfServiceLoginFlowForBrowsersValidateBeforeCall(refresh, aal, returnTo, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceLoginFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for initializeSelfServiceLoginFlowWithoutBrowser
     * @param refresh Refresh a login session  If set to true, this will refresh an existing login session by asking the user to sign in again. This will reset the authenticated_at time of the session. (optional)
     * @param aal Request a Specific AuthenticationMethod Assurance Level  Use this parameter to upgrade an existing session&#39;s authenticator assurance level (AAL). This allows you to ask for multi-factor authentication. When an identity sign in using e.g. username+password, the AAL is 1. If you wish to \&quot;upgrade\&quot; the session&#39;s security by asking the user to perform TOTP / WebAuth/ ... you would set this to \&quot;aal2\&quot;. (optional)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceLoginFlowWithoutBrowserCall(Boolean refresh, String aal, String xSessionToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/login/api";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (refresh != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("refresh", refresh));
        }

        if (aal != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("aal", aal));
        }

        if (xSessionToken != null) {
            localVarHeaderParams.put("X-Session-Token", localVarApiClient.parameterToString(xSessionToken));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call initializeSelfServiceLoginFlowWithoutBrowserValidateBeforeCall(Boolean refresh, String aal, String xSessionToken, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = initializeSelfServiceLoginFlowWithoutBrowserCall(refresh, aal, xSessionToken, _callback);
        return localVarCall;

    }

    /**
     * Initialize Login Flow for APIs, Services, Apps, ...
     * This endpoint initiates a login flow for API clients that do not use a browser, such as mobile devices, smart TVs, and so on.  If a valid provided session cookie or session token is provided, a 400 Bad Request error will be returned unless the URL query parameter &#x60;?refresh&#x3D;true&#x60; is set.  To fetch an existing login flow call &#x60;/self-service/login/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks, including CSRF login attacks.  In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;session_aal1_required&#x60;: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param refresh Refresh a login session  If set to true, this will refresh an existing login session by asking the user to sign in again. This will reset the authenticated_at time of the session. (optional)
     * @param aal Request a Specific AuthenticationMethod Assurance Level  Use this parameter to upgrade an existing session&#39;s authenticator assurance level (AAL). This allows you to ask for multi-factor authentication. When an identity sign in using e.g. username+password, the AAL is 1. If you wish to \&quot;upgrade\&quot; the session&#39;s security by asking the user to perform TOTP / WebAuth/ ... you would set this to \&quot;aal2\&quot;. (optional)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @return SelfServiceLoginFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceLoginFlow initializeSelfServiceLoginFlowWithoutBrowser(Boolean refresh, String aal, String xSessionToken) throws ApiException {
        ApiResponse<SelfServiceLoginFlow> localVarResp = initializeSelfServiceLoginFlowWithoutBrowserWithHttpInfo(refresh, aal, xSessionToken);
        return localVarResp.getData();
    }

    /**
     * Initialize Login Flow for APIs, Services, Apps, ...
     * This endpoint initiates a login flow for API clients that do not use a browser, such as mobile devices, smart TVs, and so on.  If a valid provided session cookie or session token is provided, a 400 Bad Request error will be returned unless the URL query parameter &#x60;?refresh&#x3D;true&#x60; is set.  To fetch an existing login flow call &#x60;/self-service/login/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks, including CSRF login attacks.  In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;session_aal1_required&#x60;: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param refresh Refresh a login session  If set to true, this will refresh an existing login session by asking the user to sign in again. This will reset the authenticated_at time of the session. (optional)
     * @param aal Request a Specific AuthenticationMethod Assurance Level  Use this parameter to upgrade an existing session&#39;s authenticator assurance level (AAL). This allows you to ask for multi-factor authentication. When an identity sign in using e.g. username+password, the AAL is 1. If you wish to \&quot;upgrade\&quot; the session&#39;s security by asking the user to perform TOTP / WebAuth/ ... you would set this to \&quot;aal2\&quot;. (optional)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @return ApiResponse&lt;SelfServiceLoginFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceLoginFlow> initializeSelfServiceLoginFlowWithoutBrowserWithHttpInfo(Boolean refresh, String aal, String xSessionToken) throws ApiException {
        okhttp3.Call localVarCall = initializeSelfServiceLoginFlowWithoutBrowserValidateBeforeCall(refresh, aal, xSessionToken, null);
        Type localVarReturnType = new TypeToken<SelfServiceLoginFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initialize Login Flow for APIs, Services, Apps, ... (asynchronously)
     * This endpoint initiates a login flow for API clients that do not use a browser, such as mobile devices, smart TVs, and so on.  If a valid provided session cookie or session token is provided, a 400 Bad Request error will be returned unless the URL query parameter &#x60;?refresh&#x3D;true&#x60; is set.  To fetch an existing login flow call &#x60;/self-service/login/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks, including CSRF login attacks.  In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;session_aal1_required&#x60;: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param refresh Refresh a login session  If set to true, this will refresh an existing login session by asking the user to sign in again. This will reset the authenticated_at time of the session. (optional)
     * @param aal Request a Specific AuthenticationMethod Assurance Level  Use this parameter to upgrade an existing session&#39;s authenticator assurance level (AAL). This allows you to ask for multi-factor authentication. When an identity sign in using e.g. username+password, the AAL is 1. If you wish to \&quot;upgrade\&quot; the session&#39;s security by asking the user to perform TOTP / WebAuth/ ... you would set this to \&quot;aal2\&quot;. (optional)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceLoginFlowWithoutBrowserAsync(Boolean refresh, String aal, String xSessionToken, final ApiCallback<SelfServiceLoginFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = initializeSelfServiceLoginFlowWithoutBrowserValidateBeforeCall(refresh, aal, xSessionToken, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceLoginFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for initializeSelfServiceRecoveryFlowForBrowsers
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceRecoveryFlowForBrowsersCall(String returnTo, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/recovery/browser";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (returnTo != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("return_to", returnTo));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call initializeSelfServiceRecoveryFlowForBrowsersValidateBeforeCall(String returnTo, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = initializeSelfServiceRecoveryFlowForBrowsersCall(returnTo, _callback);
        return localVarCall;

    }

    /**
     * Initialize Recovery Flow for Browsers
     * This endpoint initializes a browser-based account recovery flow. Once initialized, the browser will be redirected to &#x60;selfservice.flows.recovery.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If a valid user session exists, the browser is returned to the configured return URL.  If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects or a 400 bad request error if the user is already authenticated.  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @return SelfServiceRecoveryFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceRecoveryFlow initializeSelfServiceRecoveryFlowForBrowsers(String returnTo) throws ApiException {
        ApiResponse<SelfServiceRecoveryFlow> localVarResp = initializeSelfServiceRecoveryFlowForBrowsersWithHttpInfo(returnTo);
        return localVarResp.getData();
    }

    /**
     * Initialize Recovery Flow for Browsers
     * This endpoint initializes a browser-based account recovery flow. Once initialized, the browser will be redirected to &#x60;selfservice.flows.recovery.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If a valid user session exists, the browser is returned to the configured return URL.  If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects or a 400 bad request error if the user is already authenticated.  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @return ApiResponse&lt;SelfServiceRecoveryFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceRecoveryFlow> initializeSelfServiceRecoveryFlowForBrowsersWithHttpInfo(String returnTo) throws ApiException {
        okhttp3.Call localVarCall = initializeSelfServiceRecoveryFlowForBrowsersValidateBeforeCall(returnTo, null);
        Type localVarReturnType = new TypeToken<SelfServiceRecoveryFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initialize Recovery Flow for Browsers (asynchronously)
     * This endpoint initializes a browser-based account recovery flow. Once initialized, the browser will be redirected to &#x60;selfservice.flows.recovery.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If a valid user session exists, the browser is returned to the configured return URL.  If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects or a 400 bad request error if the user is already authenticated.  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceRecoveryFlowForBrowsersAsync(String returnTo, final ApiCallback<SelfServiceRecoveryFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = initializeSelfServiceRecoveryFlowForBrowsersValidateBeforeCall(returnTo, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceRecoveryFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for initializeSelfServiceRecoveryFlowWithoutBrowser
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceRecoveryFlowWithoutBrowserCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/recovery/api";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call initializeSelfServiceRecoveryFlowWithoutBrowserValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = initializeSelfServiceRecoveryFlowWithoutBrowserCall(_callback);
        return localVarCall;

    }

    /**
     * Initialize Recovery Flow for APIs, Services, Apps, ...
     * This endpoint initiates a recovery flow for API clients such as mobile devices, smart TVs, and so on.  If a valid provided session cookie or session token is provided, a 400 Bad Request error.  To fetch an existing recovery flow call &#x60;/self-service/recovery/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).   More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @return SelfServiceRecoveryFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceRecoveryFlow initializeSelfServiceRecoveryFlowWithoutBrowser() throws ApiException {
        ApiResponse<SelfServiceRecoveryFlow> localVarResp = initializeSelfServiceRecoveryFlowWithoutBrowserWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Initialize Recovery Flow for APIs, Services, Apps, ...
     * This endpoint initiates a recovery flow for API clients such as mobile devices, smart TVs, and so on.  If a valid provided session cookie or session token is provided, a 400 Bad Request error.  To fetch an existing recovery flow call &#x60;/self-service/recovery/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).   More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @return ApiResponse&lt;SelfServiceRecoveryFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceRecoveryFlow> initializeSelfServiceRecoveryFlowWithoutBrowserWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = initializeSelfServiceRecoveryFlowWithoutBrowserValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SelfServiceRecoveryFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initialize Recovery Flow for APIs, Services, Apps, ... (asynchronously)
     * This endpoint initiates a recovery flow for API clients such as mobile devices, smart TVs, and so on.  If a valid provided session cookie or session token is provided, a 400 Bad Request error.  To fetch an existing recovery flow call &#x60;/self-service/recovery/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).   More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceRecoveryFlowWithoutBrowserAsync(final ApiCallback<SelfServiceRecoveryFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = initializeSelfServiceRecoveryFlowWithoutBrowserValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SelfServiceRecoveryFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for initializeSelfServiceRegistrationFlowForBrowsers
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceRegistrationFlowForBrowsersCall(String returnTo, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/registration/browser";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (returnTo != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("return_to", returnTo));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call initializeSelfServiceRegistrationFlowForBrowsersValidateBeforeCall(String returnTo, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = initializeSelfServiceRegistrationFlowForBrowsersCall(returnTo, _callback);
        return localVarCall;

    }

    /**
     * Initialize Registration Flow for Browsers
     * This endpoint initializes a browser-based user registration flow. This endpoint will set the appropriate cookies and anti-CSRF measures required for browser-based flows.  :::info  This endpoint is EXPERIMENTAL and subject to potential breaking changes in the future.  :::  If this endpoint is opened as a link in the browser, it will be redirected to &#x60;selfservice.flows.registration.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If a valid user session exists already, the browser will be redirected to &#x60;urls.default_redirect_url&#x60;.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration!  If this endpoint is called via an AJAX request, the response contains the registration flow without a redirect.  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @return SelfServiceRegistrationFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceRegistrationFlow initializeSelfServiceRegistrationFlowForBrowsers(String returnTo) throws ApiException {
        ApiResponse<SelfServiceRegistrationFlow> localVarResp = initializeSelfServiceRegistrationFlowForBrowsersWithHttpInfo(returnTo);
        return localVarResp.getData();
    }

    /**
     * Initialize Registration Flow for Browsers
     * This endpoint initializes a browser-based user registration flow. This endpoint will set the appropriate cookies and anti-CSRF measures required for browser-based flows.  :::info  This endpoint is EXPERIMENTAL and subject to potential breaking changes in the future.  :::  If this endpoint is opened as a link in the browser, it will be redirected to &#x60;selfservice.flows.registration.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If a valid user session exists already, the browser will be redirected to &#x60;urls.default_redirect_url&#x60;.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration!  If this endpoint is called via an AJAX request, the response contains the registration flow without a redirect.  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @return ApiResponse&lt;SelfServiceRegistrationFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceRegistrationFlow> initializeSelfServiceRegistrationFlowForBrowsersWithHttpInfo(String returnTo) throws ApiException {
        okhttp3.Call localVarCall = initializeSelfServiceRegistrationFlowForBrowsersValidateBeforeCall(returnTo, null);
        Type localVarReturnType = new TypeToken<SelfServiceRegistrationFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initialize Registration Flow for Browsers (asynchronously)
     * This endpoint initializes a browser-based user registration flow. This endpoint will set the appropriate cookies and anti-CSRF measures required for browser-based flows.  :::info  This endpoint is EXPERIMENTAL and subject to potential breaking changes in the future.  :::  If this endpoint is opened as a link in the browser, it will be redirected to &#x60;selfservice.flows.registration.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If a valid user session exists already, the browser will be redirected to &#x60;urls.default_redirect_url&#x60;.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration!  If this endpoint is called via an AJAX request, the response contains the registration flow without a redirect.  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceRegistrationFlowForBrowsersAsync(String returnTo, final ApiCallback<SelfServiceRegistrationFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = initializeSelfServiceRegistrationFlowForBrowsersValidateBeforeCall(returnTo, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceRegistrationFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for initializeSelfServiceRegistrationFlowWithoutBrowser
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceRegistrationFlowWithoutBrowserCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/registration/api";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call initializeSelfServiceRegistrationFlowWithoutBrowserValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = initializeSelfServiceRegistrationFlowWithoutBrowserCall(_callback);
        return localVarCall;

    }

    /**
     * Initialize Registration Flow for APIs, Services, Apps, ...
     * This endpoint initiates a registration flow for API clients such as mobile devices, smart TVs, and so on.  If a valid provided session cookie or session token is provided, a 400 Bad Request error will be returned unless the URL query parameter &#x60;?refresh&#x3D;true&#x60; is set.  To fetch an existing registration flow call &#x60;/self-service/registration/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @return SelfServiceRegistrationFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceRegistrationFlow initializeSelfServiceRegistrationFlowWithoutBrowser() throws ApiException {
        ApiResponse<SelfServiceRegistrationFlow> localVarResp = initializeSelfServiceRegistrationFlowWithoutBrowserWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Initialize Registration Flow for APIs, Services, Apps, ...
     * This endpoint initiates a registration flow for API clients such as mobile devices, smart TVs, and so on.  If a valid provided session cookie or session token is provided, a 400 Bad Request error will be returned unless the URL query parameter &#x60;?refresh&#x3D;true&#x60; is set.  To fetch an existing registration flow call &#x60;/self-service/registration/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @return ApiResponse&lt;SelfServiceRegistrationFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceRegistrationFlow> initializeSelfServiceRegistrationFlowWithoutBrowserWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = initializeSelfServiceRegistrationFlowWithoutBrowserValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SelfServiceRegistrationFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initialize Registration Flow for APIs, Services, Apps, ... (asynchronously)
     * This endpoint initiates a registration flow for API clients such as mobile devices, smart TVs, and so on.  If a valid provided session cookie or session token is provided, a 400 Bad Request error will be returned unless the URL query parameter &#x60;?refresh&#x3D;true&#x60; is set.  To fetch an existing registration flow call &#x60;/self-service/registration/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceRegistrationFlowWithoutBrowserAsync(final ApiCallback<SelfServiceRegistrationFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = initializeSelfServiceRegistrationFlowWithoutBrowserValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SelfServiceRegistrationFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for initializeSelfServiceSettingsFlowForBrowsers
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceSettingsFlowForBrowsersCall(String returnTo, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/settings/browser";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (returnTo != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("return_to", returnTo));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call initializeSelfServiceSettingsFlowForBrowsersValidateBeforeCall(String returnTo, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = initializeSelfServiceSettingsFlowForBrowsersCall(returnTo, _callback);
        return localVarCall;

    }

    /**
     * Initialize Settings Flow for Browsers
     * This endpoint initializes a browser-based user settings flow. Once initialized, the browser will be redirected to &#x60;selfservice.flows.settings.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If no valid Ory Kratos Session Cookie is included in the request, a login flow will be initialized.  If this endpoint is opened as a link in the browser, it will be redirected to &#x60;selfservice.flows.settings.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If no valid user session was set, the browser will be redirected to the login endpoint.  If this endpoint is called via an AJAX request, the response contains the settings flow without any redirects or a 401 forbidden error if no valid session was set.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration!  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @return SelfServiceSettingsFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceSettingsFlow initializeSelfServiceSettingsFlowForBrowsers(String returnTo) throws ApiException {
        ApiResponse<SelfServiceSettingsFlow> localVarResp = initializeSelfServiceSettingsFlowForBrowsersWithHttpInfo(returnTo);
        return localVarResp.getData();
    }

    /**
     * Initialize Settings Flow for Browsers
     * This endpoint initializes a browser-based user settings flow. Once initialized, the browser will be redirected to &#x60;selfservice.flows.settings.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If no valid Ory Kratos Session Cookie is included in the request, a login flow will be initialized.  If this endpoint is opened as a link in the browser, it will be redirected to &#x60;selfservice.flows.settings.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If no valid user session was set, the browser will be redirected to the login endpoint.  If this endpoint is called via an AJAX request, the response contains the settings flow without any redirects or a 401 forbidden error if no valid session was set.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration!  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @return ApiResponse&lt;SelfServiceSettingsFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceSettingsFlow> initializeSelfServiceSettingsFlowForBrowsersWithHttpInfo(String returnTo) throws ApiException {
        okhttp3.Call localVarCall = initializeSelfServiceSettingsFlowForBrowsersValidateBeforeCall(returnTo, null);
        Type localVarReturnType = new TypeToken<SelfServiceSettingsFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initialize Settings Flow for Browsers (asynchronously)
     * This endpoint initializes a browser-based user settings flow. Once initialized, the browser will be redirected to &#x60;selfservice.flows.settings.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If no valid Ory Kratos Session Cookie is included in the request, a login flow will be initialized.  If this endpoint is opened as a link in the browser, it will be redirected to &#x60;selfservice.flows.settings.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;. If no valid user session was set, the browser will be redirected to the login endpoint.  If this endpoint is called via an AJAX request, the response contains the settings flow without any redirects or a 401 forbidden error if no valid session was set.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.  If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration!  This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceSettingsFlowForBrowsersAsync(String returnTo, final ApiCallback<SelfServiceSettingsFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = initializeSelfServiceSettingsFlowForBrowsersValidateBeforeCall(returnTo, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceSettingsFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for initializeSelfServiceSettingsFlowWithoutBrowser
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceSettingsFlowWithoutBrowserCall(String xSessionToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/settings/api";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSessionToken != null) {
            localVarHeaderParams.put("X-Session-Token", localVarApiClient.parameterToString(xSessionToken));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call initializeSelfServiceSettingsFlowWithoutBrowserValidateBeforeCall(String xSessionToken, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = initializeSelfServiceSettingsFlowWithoutBrowserCall(xSessionToken, _callback);
        return localVarCall;

    }

    /**
     * Initialize Settings Flow for APIs, Services, Apps, ...
     * This endpoint initiates a settings flow for API clients such as mobile devices, smart TVs, and so on. You must provide a valid Ory Kratos Session Token for this endpoint to respond with HTTP 200 OK.  To fetch an existing settings flow call &#x60;/self-service/settings/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor or change the configuration.  In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @return SelfServiceSettingsFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceSettingsFlow initializeSelfServiceSettingsFlowWithoutBrowser(String xSessionToken) throws ApiException {
        ApiResponse<SelfServiceSettingsFlow> localVarResp = initializeSelfServiceSettingsFlowWithoutBrowserWithHttpInfo(xSessionToken);
        return localVarResp.getData();
    }

    /**
     * Initialize Settings Flow for APIs, Services, Apps, ...
     * This endpoint initiates a settings flow for API clients such as mobile devices, smart TVs, and so on. You must provide a valid Ory Kratos Session Token for this endpoint to respond with HTTP 200 OK.  To fetch an existing settings flow call &#x60;/self-service/settings/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor or change the configuration.  In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @return ApiResponse&lt;SelfServiceSettingsFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceSettingsFlow> initializeSelfServiceSettingsFlowWithoutBrowserWithHttpInfo(String xSessionToken) throws ApiException {
        okhttp3.Call localVarCall = initializeSelfServiceSettingsFlowWithoutBrowserValidateBeforeCall(xSessionToken, null);
        Type localVarReturnType = new TypeToken<SelfServiceSettingsFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initialize Settings Flow for APIs, Services, Apps, ... (asynchronously)
     * This endpoint initiates a settings flow for API clients such as mobile devices, smart TVs, and so on. You must provide a valid Ory Kratos Session Token for this endpoint to respond with HTTP 200 OK.  To fetch an existing settings flow call &#x60;/self-service/settings/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor or change the configuration.  In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceSettingsFlowWithoutBrowserAsync(String xSessionToken, final ApiCallback<SelfServiceSettingsFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = initializeSelfServiceSettingsFlowWithoutBrowserValidateBeforeCall(xSessionToken, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceSettingsFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for initializeSelfServiceVerificationFlowForBrowsers
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceVerificationFlowForBrowsersCall(String returnTo, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/verification/browser";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (returnTo != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("return_to", returnTo));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call initializeSelfServiceVerificationFlowForBrowsersValidateBeforeCall(String returnTo, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = initializeSelfServiceVerificationFlowForBrowsersCall(returnTo, _callback);
        return localVarCall;

    }

    /**
     * Initialize Verification Flow for Browser Clients
     * This endpoint initializes a browser-based account verification flow. Once initialized, the browser will be redirected to &#x60;selfservice.flows.verification.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;.  If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects.  This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...).  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @return SelfServiceVerificationFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceVerificationFlow initializeSelfServiceVerificationFlowForBrowsers(String returnTo) throws ApiException {
        ApiResponse<SelfServiceVerificationFlow> localVarResp = initializeSelfServiceVerificationFlowForBrowsersWithHttpInfo(returnTo);
        return localVarResp.getData();
    }

    /**
     * Initialize Verification Flow for Browser Clients
     * This endpoint initializes a browser-based account verification flow. Once initialized, the browser will be redirected to &#x60;selfservice.flows.verification.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;.  If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects.  This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...).  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @return ApiResponse&lt;SelfServiceVerificationFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceVerificationFlow> initializeSelfServiceVerificationFlowForBrowsersWithHttpInfo(String returnTo) throws ApiException {
        okhttp3.Call localVarCall = initializeSelfServiceVerificationFlowForBrowsersValidateBeforeCall(returnTo, null);
        Type localVarReturnType = new TypeToken<SelfServiceVerificationFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initialize Verification Flow for Browser Clients (asynchronously)
     * This endpoint initializes a browser-based account verification flow. Once initialized, the browser will be redirected to &#x60;selfservice.flows.verification.ui_url&#x60; with the flow ID set as the query parameter &#x60;?flow&#x3D;&#x60;.  If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects.  This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...).  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @param returnTo The URL to return the browser to after the flow was completed. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceVerificationFlowForBrowsersAsync(String returnTo, final ApiCallback<SelfServiceVerificationFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = initializeSelfServiceVerificationFlowForBrowsersValidateBeforeCall(returnTo, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceVerificationFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for initializeSelfServiceVerificationFlowWithoutBrowser
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceVerificationFlowWithoutBrowserCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/verification/api";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call initializeSelfServiceVerificationFlowWithoutBrowserValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = initializeSelfServiceVerificationFlowWithoutBrowserCall(_callback);
        return localVarCall;

    }

    /**
     * Initialize Verification Flow for APIs, Services, Apps, ...
     * This endpoint initiates a verification flow for API clients such as mobile devices, smart TVs, and so on.  To fetch an existing verification flow call &#x60;/self-service/verification/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @return SelfServiceVerificationFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceVerificationFlow initializeSelfServiceVerificationFlowWithoutBrowser() throws ApiException {
        ApiResponse<SelfServiceVerificationFlow> localVarResp = initializeSelfServiceVerificationFlowWithoutBrowserWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Initialize Verification Flow for APIs, Services, Apps, ...
     * This endpoint initiates a verification flow for API clients such as mobile devices, smart TVs, and so on.  To fetch an existing verification flow call &#x60;/self-service/verification/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @return ApiResponse&lt;SelfServiceVerificationFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceVerificationFlow> initializeSelfServiceVerificationFlowWithoutBrowserWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = initializeSelfServiceVerificationFlowWithoutBrowserValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SelfServiceVerificationFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initialize Verification Flow for APIs, Services, Apps, ... (asynchronously)
     * This endpoint initiates a verification flow for API clients such as mobile devices, smart TVs, and so on.  To fetch an existing verification flow call &#x60;/self-service/verification/flows?flow&#x3D;&lt;flow_id&gt;&#x60;.  You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make you vulnerable to a variety of CSRF attacks.  This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call initializeSelfServiceVerificationFlowWithoutBrowserAsync(final ApiCallback<SelfServiceVerificationFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = initializeSelfServiceVerificationFlowWithoutBrowserValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SelfServiceVerificationFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listIdentitySchemas
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identitySchemas </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIdentitySchemasCall(Long perPage, Long page, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/schemas";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listIdentitySchemasValidateBeforeCall(Long perPage, Long page, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listIdentitySchemasCall(perPage, page, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get all Identity Schemas
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @return List&lt;IdentitySchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identitySchemas </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public List<IdentitySchema> listIdentitySchemas(Long perPage, Long page) throws ApiException {
        ApiResponse<List<IdentitySchema>> localVarResp = listIdentitySchemasWithHttpInfo(perPage, page);
        return localVarResp.getData();
    }

    /**
     * 
     * Get all Identity Schemas
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @return ApiResponse&lt;List&lt;IdentitySchema&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identitySchemas </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<IdentitySchema>> listIdentitySchemasWithHttpInfo(Long perPage, Long page) throws ApiException {
        okhttp3.Call localVarCall = listIdentitySchemasValidateBeforeCall(perPage, page, null);
        Type localVarReturnType = new TypeToken<List<IdentitySchema>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get all Identity Schemas
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> identitySchemas </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIdentitySchemasAsync(Long perPage, Long page, final ApiCallback<List<IdentitySchema>> _callback) throws ApiException {

        okhttp3.Call localVarCall = listIdentitySchemasValidateBeforeCall(perPage, page, _callback);
        Type localVarReturnType = new TypeToken<List<IdentitySchema>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listSessions
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> sessionList </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listSessionsCall(String xSessionToken, String cookie, Long perPage, Long page, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/sessions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (xSessionToken != null) {
            localVarHeaderParams.put("X-Session-Token", localVarApiClient.parameterToString(xSessionToken));
        }

        if (cookie != null) {
            localVarHeaderParams.put("Cookie", localVarApiClient.parameterToString(cookie));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSessionsValidateBeforeCall(String xSessionToken, String cookie, Long perPage, Long page, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listSessionsCall(xSessionToken, cookie, perPage, page, _callback);
        return localVarCall;

    }

    /**
     * This endpoints returns all other active sessions that belong to the logged-in user. The current session can be retrieved by calling the &#x60;/sessions/whoami&#x60; endpoint.
     * This endpoint is useful for:  Displaying all other sessions that belong to the logged-in user
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @return List&lt;Session&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> sessionList </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public List<Session> listSessions(String xSessionToken, String cookie, Long perPage, Long page) throws ApiException {
        ApiResponse<List<Session>> localVarResp = listSessionsWithHttpInfo(xSessionToken, cookie, perPage, page);
        return localVarResp.getData();
    }

    /**
     * This endpoints returns all other active sessions that belong to the logged-in user. The current session can be retrieved by calling the &#x60;/sessions/whoami&#x60; endpoint.
     * This endpoint is useful for:  Displaying all other sessions that belong to the logged-in user
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @return ApiResponse&lt;List&lt;Session&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> sessionList </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Session>> listSessionsWithHttpInfo(String xSessionToken, String cookie, Long perPage, Long page) throws ApiException {
        okhttp3.Call localVarCall = listSessionsValidateBeforeCall(xSessionToken, cookie, perPage, page, null);
        Type localVarReturnType = new TypeToken<List<Session>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * This endpoints returns all other active sessions that belong to the logged-in user. The current session can be retrieved by calling the &#x60;/sessions/whoami&#x60; endpoint. (asynchronously)
     * This endpoint is useful for:  Displaying all other sessions that belong to the logged-in user
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @param perPage Items per Page  This is the number of items per page. (optional, default to 250)
     * @param page Pagination Page (optional, default to 0)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> sessionList </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listSessionsAsync(String xSessionToken, String cookie, Long perPage, Long page, final ApiCallback<List<Session>> _callback) throws ApiException {

        okhttp3.Call localVarCall = listSessionsValidateBeforeCall(xSessionToken, cookie, perPage, page, _callback);
        Type localVarReturnType = new TypeToken<List<Session>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for revokeSession
     * @param id ID is the session&#39;s ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call revokeSessionCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/sessions/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call revokeSessionValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling revokeSession(Async)");
        }
        

        okhttp3.Call localVarCall = revokeSessionCall(id, _callback);
        return localVarCall;

    }

    /**
     * Calling this endpoint invalidates the specified session. The current session cannot be revoked. Session data are not deleted.
     * This endpoint is useful for:  To forcefully logout the current user from another device or session
     * @param id ID is the session&#39;s ID. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public void revokeSession(String id) throws ApiException {
        revokeSessionWithHttpInfo(id);
    }

    /**
     * Calling this endpoint invalidates the specified session. The current session cannot be revoked. Session data are not deleted.
     * This endpoint is useful for:  To forcefully logout the current user from another device or session
     * @param id ID is the session&#39;s ID. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> revokeSessionWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = revokeSessionValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Calling this endpoint invalidates the specified session. The current session cannot be revoked. Session data are not deleted. (asynchronously)
     * This endpoint is useful for:  To forcefully logout the current user from another device or session
     * @param id ID is the session&#39;s ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call revokeSessionAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = revokeSessionValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for revokeSessions
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> revokedSessions </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call revokeSessionsCall(String xSessionToken, String cookie, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/sessions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSessionToken != null) {
            localVarHeaderParams.put("X-Session-Token", localVarApiClient.parameterToString(xSessionToken));
        }

        if (cookie != null) {
            localVarHeaderParams.put("Cookie", localVarApiClient.parameterToString(cookie));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call revokeSessionsValidateBeforeCall(String xSessionToken, String cookie, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = revokeSessionsCall(xSessionToken, cookie, _callback);
        return localVarCall;

    }

    /**
     * Calling this endpoint invalidates all except the current session that belong to the logged-in user. Session data are not deleted.
     * This endpoint is useful for:  To forcefully logout the current user from all other devices and sessions
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @return RevokedSessions
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> revokedSessions </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public RevokedSessions revokeSessions(String xSessionToken, String cookie) throws ApiException {
        ApiResponse<RevokedSessions> localVarResp = revokeSessionsWithHttpInfo(xSessionToken, cookie);
        return localVarResp.getData();
    }

    /**
     * Calling this endpoint invalidates all except the current session that belong to the logged-in user. Session data are not deleted.
     * This endpoint is useful for:  To forcefully logout the current user from all other devices and sessions
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @return ApiResponse&lt;RevokedSessions&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> revokedSessions </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<RevokedSessions> revokeSessionsWithHttpInfo(String xSessionToken, String cookie) throws ApiException {
        okhttp3.Call localVarCall = revokeSessionsValidateBeforeCall(xSessionToken, cookie, null);
        Type localVarReturnType = new TypeToken<RevokedSessions>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Calling this endpoint invalidates all except the current session that belong to the logged-in user. Session data are not deleted. (asynchronously)
     * This endpoint is useful for:  To forcefully logout the current user from all other devices and sessions
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> revokedSessions </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call revokeSessionsAsync(String xSessionToken, String cookie, final ApiCallback<RevokedSessions> _callback) throws ApiException {

        okhttp3.Call localVarCall = revokeSessionsValidateBeforeCall(xSessionToken, cookie, _callback);
        Type localVarReturnType = new TypeToken<RevokedSessions>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitSelfServiceLoginFlow
     * @param flow The Login Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/login?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param submitSelfServiceLoginFlowBody  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulSelfServiceLoginWithoutBrowser </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceLoginFlowCall(String flow, String xSessionToken, SubmitSelfServiceLoginFlowBody submitSelfServiceLoginFlowBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = submitSelfServiceLoginFlowBody;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/login";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (flow != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("flow", flow));
        }

        if (xSessionToken != null) {
            localVarHeaderParams.put("X-Session-Token", localVarApiClient.parameterToString(xSessionToken));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-www-form-urlencoded"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitSelfServiceLoginFlowValidateBeforeCall(String flow, String xSessionToken, SubmitSelfServiceLoginFlowBody submitSelfServiceLoginFlowBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'flow' is set
        if (flow == null) {
            throw new ApiException("Missing the required parameter 'flow' when calling submitSelfServiceLoginFlow(Async)");
        }
        

        okhttp3.Call localVarCall = submitSelfServiceLoginFlowCall(flow, xSessionToken, submitSelfServiceLoginFlowBody, _callback);
        return localVarCall;

    }

    /**
     * Submit a Login Flow
     * :::info  This endpoint is EXPERIMENTAL and subject to potential breaking changes in the future.  :::  Use this endpoint to complete a login flow. This endpoint behaves differently for API and browser flows.  API flows expect &#x60;application/json&#x60; to be sent in the body and responds with HTTP 200 and a application/json body with the session token on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  Browser flows expect a Content-Type of &#x60;application/x-www-form-urlencoded&#x60; or &#x60;application/json&#x60; to be sent in the body and respond with a HTTP 302 redirect to the post/after login URL or the &#x60;return_to&#x60; value if it was set and if the login succeeded; a HTTP 302 redirect to the login UI URL with the flow ID containing the validation errors otherwise.  Browser flows with an accept header of &#x60;application/json&#x60; will not redirect but instead respond with HTTP 200 and a application/json body with the signed in identity and a &#x60;Set-Cookie&#x60; header on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  If this endpoint is called with &#x60;Accept: application/json&#x60; in the header, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration! &#x60;browser_location_change_required&#x60;: Usually sent when an AJAX request indicates that the browser needs to open a specific URL. Most likely used in Social Sign In flows.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param flow The Login Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/login?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param submitSelfServiceLoginFlowBody  (optional)
     * @return SuccessfulSelfServiceLoginWithoutBrowser
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulSelfServiceLoginWithoutBrowser </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SuccessfulSelfServiceLoginWithoutBrowser submitSelfServiceLoginFlow(String flow, String xSessionToken, SubmitSelfServiceLoginFlowBody submitSelfServiceLoginFlowBody) throws ApiException {
        ApiResponse<SuccessfulSelfServiceLoginWithoutBrowser> localVarResp = submitSelfServiceLoginFlowWithHttpInfo(flow, xSessionToken, submitSelfServiceLoginFlowBody);
        return localVarResp.getData();
    }

    /**
     * Submit a Login Flow
     * :::info  This endpoint is EXPERIMENTAL and subject to potential breaking changes in the future.  :::  Use this endpoint to complete a login flow. This endpoint behaves differently for API and browser flows.  API flows expect &#x60;application/json&#x60; to be sent in the body and responds with HTTP 200 and a application/json body with the session token on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  Browser flows expect a Content-Type of &#x60;application/x-www-form-urlencoded&#x60; or &#x60;application/json&#x60; to be sent in the body and respond with a HTTP 302 redirect to the post/after login URL or the &#x60;return_to&#x60; value if it was set and if the login succeeded; a HTTP 302 redirect to the login UI URL with the flow ID containing the validation errors otherwise.  Browser flows with an accept header of &#x60;application/json&#x60; will not redirect but instead respond with HTTP 200 and a application/json body with the signed in identity and a &#x60;Set-Cookie&#x60; header on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  If this endpoint is called with &#x60;Accept: application/json&#x60; in the header, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration! &#x60;browser_location_change_required&#x60;: Usually sent when an AJAX request indicates that the browser needs to open a specific URL. Most likely used in Social Sign In flows.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param flow The Login Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/login?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param submitSelfServiceLoginFlowBody  (optional)
     * @return ApiResponse&lt;SuccessfulSelfServiceLoginWithoutBrowser&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulSelfServiceLoginWithoutBrowser </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SuccessfulSelfServiceLoginWithoutBrowser> submitSelfServiceLoginFlowWithHttpInfo(String flow, String xSessionToken, SubmitSelfServiceLoginFlowBody submitSelfServiceLoginFlowBody) throws ApiException {
        okhttp3.Call localVarCall = submitSelfServiceLoginFlowValidateBeforeCall(flow, xSessionToken, submitSelfServiceLoginFlowBody, null);
        Type localVarReturnType = new TypeToken<SuccessfulSelfServiceLoginWithoutBrowser>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Submit a Login Flow (asynchronously)
     * :::info  This endpoint is EXPERIMENTAL and subject to potential breaking changes in the future.  :::  Use this endpoint to complete a login flow. This endpoint behaves differently for API and browser flows.  API flows expect &#x60;application/json&#x60; to be sent in the body and responds with HTTP 200 and a application/json body with the session token on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  Browser flows expect a Content-Type of &#x60;application/x-www-form-urlencoded&#x60; or &#x60;application/json&#x60; to be sent in the body and respond with a HTTP 302 redirect to the post/after login URL or the &#x60;return_to&#x60; value if it was set and if the login succeeded; a HTTP 302 redirect to the login UI URL with the flow ID containing the validation errors otherwise.  Browser flows with an accept header of &#x60;application/json&#x60; will not redirect but instead respond with HTTP 200 and a application/json body with the signed in identity and a &#x60;Set-Cookie&#x60; header on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  If this endpoint is called with &#x60;Accept: application/json&#x60; in the header, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration! &#x60;browser_location_change_required&#x60;: Usually sent when an AJAX request indicates that the browser needs to open a specific URL. Most likely used in Social Sign In flows.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param flow The Login Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/login?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param submitSelfServiceLoginFlowBody  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulSelfServiceLoginWithoutBrowser </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceLoginFlow </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceLoginFlowAsync(String flow, String xSessionToken, SubmitSelfServiceLoginFlowBody submitSelfServiceLoginFlowBody, final ApiCallback<SuccessfulSelfServiceLoginWithoutBrowser> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitSelfServiceLoginFlowValidateBeforeCall(flow, xSessionToken, submitSelfServiceLoginFlowBody, _callback);
        Type localVarReturnType = new TypeToken<SuccessfulSelfServiceLoginWithoutBrowser>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitSelfServiceLogoutFlow
     * @param token A Valid Logout Token  If you do not have a logout token because you only have a session cookie, call &#x60;/self-service/logout/urls&#x60; to generate a URL for this endpoint. (optional)
     * @param returnTo The URL to return to after the logout was completed. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceLogoutFlowCall(String token, String returnTo, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/logout";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        if (returnTo != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("return_to", returnTo));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitSelfServiceLogoutFlowValidateBeforeCall(String token, String returnTo, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = submitSelfServiceLogoutFlowCall(token, returnTo, _callback);
        return localVarCall;

    }

    /**
     * Complete Self-Service Logout
     * This endpoint logs out an identity in a self-service manner.  If the &#x60;Accept&#x60; HTTP header is not set to &#x60;application/json&#x60;, the browser will be redirected (HTTP 302 Found) to the &#x60;return_to&#x60; parameter of the initial request or fall back to &#x60;urls.default_return_to&#x60;.  If the &#x60;Accept&#x60; HTTP header is set to &#x60;application/json&#x60;, a 204 No Content response will be sent on successful logout instead.  This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...). For API clients you can call the &#x60;/self-service/logout/api&#x60; URL directly with the Ory Session Token.  More information can be found at [Ory Kratos User Logout Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-logout).
     * @param token A Valid Logout Token  If you do not have a logout token because you only have a session cookie, call &#x60;/self-service/logout/urls&#x60; to generate a URL for this endpoint. (optional)
     * @param returnTo The URL to return to after the logout was completed. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public void submitSelfServiceLogoutFlow(String token, String returnTo) throws ApiException {
        submitSelfServiceLogoutFlowWithHttpInfo(token, returnTo);
    }

    /**
     * Complete Self-Service Logout
     * This endpoint logs out an identity in a self-service manner.  If the &#x60;Accept&#x60; HTTP header is not set to &#x60;application/json&#x60;, the browser will be redirected (HTTP 302 Found) to the &#x60;return_to&#x60; parameter of the initial request or fall back to &#x60;urls.default_return_to&#x60;.  If the &#x60;Accept&#x60; HTTP header is set to &#x60;application/json&#x60;, a 204 No Content response will be sent on successful logout instead.  This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...). For API clients you can call the &#x60;/self-service/logout/api&#x60; URL directly with the Ory Session Token.  More information can be found at [Ory Kratos User Logout Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-logout).
     * @param token A Valid Logout Token  If you do not have a logout token because you only have a session cookie, call &#x60;/self-service/logout/urls&#x60; to generate a URL for this endpoint. (optional)
     * @param returnTo The URL to return to after the logout was completed. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> submitSelfServiceLogoutFlowWithHttpInfo(String token, String returnTo) throws ApiException {
        okhttp3.Call localVarCall = submitSelfServiceLogoutFlowValidateBeforeCall(token, returnTo, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Complete Self-Service Logout (asynchronously)
     * This endpoint logs out an identity in a self-service manner.  If the &#x60;Accept&#x60; HTTP header is not set to &#x60;application/json&#x60;, the browser will be redirected (HTTP 302 Found) to the &#x60;return_to&#x60; parameter of the initial request or fall back to &#x60;urls.default_return_to&#x60;.  If the &#x60;Accept&#x60; HTTP header is set to &#x60;application/json&#x60;, a 204 No Content response will be sent on successful logout instead.  This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...). For API clients you can call the &#x60;/self-service/logout/api&#x60; URL directly with the Ory Session Token.  More information can be found at [Ory Kratos User Logout Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-logout).
     * @param token A Valid Logout Token  If you do not have a logout token because you only have a session cookie, call &#x60;/self-service/logout/urls&#x60; to generate a URL for this endpoint. (optional)
     * @param returnTo The URL to return to after the logout was completed. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceLogoutFlowAsync(String token, String returnTo, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitSelfServiceLogoutFlowValidateBeforeCall(token, returnTo, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitSelfServiceLogoutFlowWithoutBrowser
     * @param submitSelfServiceLogoutFlowWithoutBrowserBody  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceLogoutFlowWithoutBrowserCall(SubmitSelfServiceLogoutFlowWithoutBrowserBody submitSelfServiceLogoutFlowWithoutBrowserBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = submitSelfServiceLogoutFlowWithoutBrowserBody;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/logout/api";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitSelfServiceLogoutFlowWithoutBrowserValidateBeforeCall(SubmitSelfServiceLogoutFlowWithoutBrowserBody submitSelfServiceLogoutFlowWithoutBrowserBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'submitSelfServiceLogoutFlowWithoutBrowserBody' is set
        if (submitSelfServiceLogoutFlowWithoutBrowserBody == null) {
            throw new ApiException("Missing the required parameter 'submitSelfServiceLogoutFlowWithoutBrowserBody' when calling submitSelfServiceLogoutFlowWithoutBrowser(Async)");
        }
        

        okhttp3.Call localVarCall = submitSelfServiceLogoutFlowWithoutBrowserCall(submitSelfServiceLogoutFlowWithoutBrowserBody, _callback);
        return localVarCall;

    }

    /**
     * Perform Logout for APIs, Services, Apps, ...
     * Use this endpoint to log out an identity using an Ory Session Token. If the Ory Session Token was successfully revoked, the server returns a 204 No Content response. A 204 No Content response is also sent when the Ory Session Token has been revoked already before.  If the Ory Session Token is malformed or does not exist a 403 Forbidden response will be returned.  This endpoint does not remove any HTTP Cookies - use the Browser-Based Self-Service Logout Flow instead.
     * @param submitSelfServiceLogoutFlowWithoutBrowserBody  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public void submitSelfServiceLogoutFlowWithoutBrowser(SubmitSelfServiceLogoutFlowWithoutBrowserBody submitSelfServiceLogoutFlowWithoutBrowserBody) throws ApiException {
        submitSelfServiceLogoutFlowWithoutBrowserWithHttpInfo(submitSelfServiceLogoutFlowWithoutBrowserBody);
    }

    /**
     * Perform Logout for APIs, Services, Apps, ...
     * Use this endpoint to log out an identity using an Ory Session Token. If the Ory Session Token was successfully revoked, the server returns a 204 No Content response. A 204 No Content response is also sent when the Ory Session Token has been revoked already before.  If the Ory Session Token is malformed or does not exist a 403 Forbidden response will be returned.  This endpoint does not remove any HTTP Cookies - use the Browser-Based Self-Service Logout Flow instead.
     * @param submitSelfServiceLogoutFlowWithoutBrowserBody  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> submitSelfServiceLogoutFlowWithoutBrowserWithHttpInfo(SubmitSelfServiceLogoutFlowWithoutBrowserBody submitSelfServiceLogoutFlowWithoutBrowserBody) throws ApiException {
        okhttp3.Call localVarCall = submitSelfServiceLogoutFlowWithoutBrowserValidateBeforeCall(submitSelfServiceLogoutFlowWithoutBrowserBody, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Perform Logout for APIs, Services, Apps, ... (asynchronously)
     * Use this endpoint to log out an identity using an Ory Session Token. If the Ory Session Token was successfully revoked, the server returns a 204 No Content response. A 204 No Content response is also sent when the Ory Session Token has been revoked already before.  If the Ory Session Token is malformed or does not exist a 403 Forbidden response will be returned.  This endpoint does not remove any HTTP Cookies - use the Browser-Based Self-Service Logout Flow instead.
     * @param submitSelfServiceLogoutFlowWithoutBrowserBody  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceLogoutFlowWithoutBrowserAsync(SubmitSelfServiceLogoutFlowWithoutBrowserBody submitSelfServiceLogoutFlowWithoutBrowserBody, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitSelfServiceLogoutFlowWithoutBrowserValidateBeforeCall(submitSelfServiceLogoutFlowWithoutBrowserBody, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitSelfServiceRecoveryFlow
     * @param flow The Recovery Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/recovery?flow&#x3D;abcde&#x60;). (required)
     * @param token Recovery Token  The recovery token which completes the recovery request. If the token is invalid (e.g. expired) an error will be shown to the end-user.  This parameter is usually set in a link and not used by any direct API call. (optional)
     * @param submitSelfServiceRecoveryFlowBody  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceRecoveryFlowCall(String flow, String token, SubmitSelfServiceRecoveryFlowBody submitSelfServiceRecoveryFlowBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = submitSelfServiceRecoveryFlowBody;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/recovery";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (flow != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("flow", flow));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-www-form-urlencoded"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitSelfServiceRecoveryFlowValidateBeforeCall(String flow, String token, SubmitSelfServiceRecoveryFlowBody submitSelfServiceRecoveryFlowBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'flow' is set
        if (flow == null) {
            throw new ApiException("Missing the required parameter 'flow' when calling submitSelfServiceRecoveryFlow(Async)");
        }
        

        okhttp3.Call localVarCall = submitSelfServiceRecoveryFlowCall(flow, token, submitSelfServiceRecoveryFlowBody, _callback);
        return localVarCall;

    }

    /**
     * Complete Recovery Flow
     * Use this endpoint to complete a recovery flow. This endpoint behaves differently for API and browser flows and has several states:  &#x60;choose_method&#x60; expects &#x60;flow&#x60; (in the URL query) and &#x60;email&#x60; (in the body) to be sent and works with API- and Browser-initiated flows. For API clients and Browser clients with HTTP Header &#x60;Accept: application/json&#x60; it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid. and a HTTP 302 Found redirect with a fresh recovery flow if the flow was otherwise invalid (e.g. expired). For Browser clients without HTTP Header &#x60;Accept&#x60; or with &#x60;Accept: text/_*&#x60; it returns a HTTP 302 Found redirect to the Recovery UI URL with the Recovery Flow ID appended. &#x60;sent_email&#x60; is the success state after &#x60;choose_method&#x60; for the &#x60;link&#x60; method and allows the user to request another recovery email. It works for both API and Browser-initiated flows and returns the same responses as the flow in &#x60;choose_method&#x60; state. &#x60;passed_challenge&#x60; expects a &#x60;token&#x60; to be sent in the URL query and given the nature of the flow (\&quot;sending a recovery link\&quot;) does not have any API capabilities. The server responds with a HTTP 302 Found redirect either to the Settings UI URL (if the link was valid) and instructs the user to update their password, or a redirect to the Recover UI URL with a new Recovery Flow ID which contains an error message that the recovery link was invalid.  More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @param flow The Recovery Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/recovery?flow&#x3D;abcde&#x60;). (required)
     * @param token Recovery Token  The recovery token which completes the recovery request. If the token is invalid (e.g. expired) an error will be shown to the end-user.  This parameter is usually set in a link and not used by any direct API call. (optional)
     * @param submitSelfServiceRecoveryFlowBody  (optional)
     * @return SelfServiceRecoveryFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceRecoveryFlow submitSelfServiceRecoveryFlow(String flow, String token, SubmitSelfServiceRecoveryFlowBody submitSelfServiceRecoveryFlowBody) throws ApiException {
        ApiResponse<SelfServiceRecoveryFlow> localVarResp = submitSelfServiceRecoveryFlowWithHttpInfo(flow, token, submitSelfServiceRecoveryFlowBody);
        return localVarResp.getData();
    }

    /**
     * Complete Recovery Flow
     * Use this endpoint to complete a recovery flow. This endpoint behaves differently for API and browser flows and has several states:  &#x60;choose_method&#x60; expects &#x60;flow&#x60; (in the URL query) and &#x60;email&#x60; (in the body) to be sent and works with API- and Browser-initiated flows. For API clients and Browser clients with HTTP Header &#x60;Accept: application/json&#x60; it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid. and a HTTP 302 Found redirect with a fresh recovery flow if the flow was otherwise invalid (e.g. expired). For Browser clients without HTTP Header &#x60;Accept&#x60; or with &#x60;Accept: text/_*&#x60; it returns a HTTP 302 Found redirect to the Recovery UI URL with the Recovery Flow ID appended. &#x60;sent_email&#x60; is the success state after &#x60;choose_method&#x60; for the &#x60;link&#x60; method and allows the user to request another recovery email. It works for both API and Browser-initiated flows and returns the same responses as the flow in &#x60;choose_method&#x60; state. &#x60;passed_challenge&#x60; expects a &#x60;token&#x60; to be sent in the URL query and given the nature of the flow (\&quot;sending a recovery link\&quot;) does not have any API capabilities. The server responds with a HTTP 302 Found redirect either to the Settings UI URL (if the link was valid) and instructs the user to update their password, or a redirect to the Recover UI URL with a new Recovery Flow ID which contains an error message that the recovery link was invalid.  More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @param flow The Recovery Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/recovery?flow&#x3D;abcde&#x60;). (required)
     * @param token Recovery Token  The recovery token which completes the recovery request. If the token is invalid (e.g. expired) an error will be shown to the end-user.  This parameter is usually set in a link and not used by any direct API call. (optional)
     * @param submitSelfServiceRecoveryFlowBody  (optional)
     * @return ApiResponse&lt;SelfServiceRecoveryFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceRecoveryFlow> submitSelfServiceRecoveryFlowWithHttpInfo(String flow, String token, SubmitSelfServiceRecoveryFlowBody submitSelfServiceRecoveryFlowBody) throws ApiException {
        okhttp3.Call localVarCall = submitSelfServiceRecoveryFlowValidateBeforeCall(flow, token, submitSelfServiceRecoveryFlowBody, null);
        Type localVarReturnType = new TypeToken<SelfServiceRecoveryFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Complete Recovery Flow (asynchronously)
     * Use this endpoint to complete a recovery flow. This endpoint behaves differently for API and browser flows and has several states:  &#x60;choose_method&#x60; expects &#x60;flow&#x60; (in the URL query) and &#x60;email&#x60; (in the body) to be sent and works with API- and Browser-initiated flows. For API clients and Browser clients with HTTP Header &#x60;Accept: application/json&#x60; it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid. and a HTTP 302 Found redirect with a fresh recovery flow if the flow was otherwise invalid (e.g. expired). For Browser clients without HTTP Header &#x60;Accept&#x60; or with &#x60;Accept: text/_*&#x60; it returns a HTTP 302 Found redirect to the Recovery UI URL with the Recovery Flow ID appended. &#x60;sent_email&#x60; is the success state after &#x60;choose_method&#x60; for the &#x60;link&#x60; method and allows the user to request another recovery email. It works for both API and Browser-initiated flows and returns the same responses as the flow in &#x60;choose_method&#x60; state. &#x60;passed_challenge&#x60; expects a &#x60;token&#x60; to be sent in the URL query and given the nature of the flow (\&quot;sending a recovery link\&quot;) does not have any API capabilities. The server responds with a HTTP 302 Found redirect either to the Settings UI URL (if the link was valid) and instructs the user to update their password, or a redirect to the Recover UI URL with a new Recovery Flow ID which contains an error message that the recovery link was invalid.  More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery.mdx).
     * @param flow The Recovery Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/recovery?flow&#x3D;abcde&#x60;). (required)
     * @param token Recovery Token  The recovery token which completes the recovery request. If the token is invalid (e.g. expired) an error will be shown to the end-user.  This parameter is usually set in a link and not used by any direct API call. (optional)
     * @param submitSelfServiceRecoveryFlowBody  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceRecoveryFlow </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceRecoveryFlowAsync(String flow, String token, SubmitSelfServiceRecoveryFlowBody submitSelfServiceRecoveryFlowBody, final ApiCallback<SelfServiceRecoveryFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitSelfServiceRecoveryFlowValidateBeforeCall(flow, token, submitSelfServiceRecoveryFlowBody, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceRecoveryFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitSelfServiceRegistrationFlow
     * @param flow The Registration Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/registration?flow&#x3D;abcde&#x60;). (required)
     * @param submitSelfServiceRegistrationFlowBody  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulSelfServiceRegistrationWithoutBrowser </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceRegistrationFlowCall(String flow, SubmitSelfServiceRegistrationFlowBody submitSelfServiceRegistrationFlowBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = submitSelfServiceRegistrationFlowBody;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/registration";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (flow != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("flow", flow));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-www-form-urlencoded"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitSelfServiceRegistrationFlowValidateBeforeCall(String flow, SubmitSelfServiceRegistrationFlowBody submitSelfServiceRegistrationFlowBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'flow' is set
        if (flow == null) {
            throw new ApiException("Missing the required parameter 'flow' when calling submitSelfServiceRegistrationFlow(Async)");
        }
        

        okhttp3.Call localVarCall = submitSelfServiceRegistrationFlowCall(flow, submitSelfServiceRegistrationFlowBody, _callback);
        return localVarCall;

    }

    /**
     * Submit a Registration Flow
     * Use this endpoint to complete a registration flow by sending an identity&#39;s traits and password. This endpoint behaves differently for API and browser flows.  API flows expect &#x60;application/json&#x60; to be sent in the body and respond with HTTP 200 and a application/json body with the created identity success - if the session hook is configured the &#x60;session&#x60; and &#x60;session_token&#x60; will also be included; HTTP 302 redirect to a fresh registration flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  Browser flows expect a Content-Type of &#x60;application/x-www-form-urlencoded&#x60; or &#x60;application/json&#x60; to be sent in the body and respond with a HTTP 302 redirect to the post/after registration URL or the &#x60;return_to&#x60; value if it was set and if the registration succeeded; a HTTP 302 redirect to the registration UI URL with the flow ID containing the validation errors otherwise.  Browser flows with an accept header of &#x60;application/json&#x60; will not redirect but instead respond with HTTP 200 and a application/json body with the signed in identity and a &#x60;Set-Cookie&#x60; header on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  If this endpoint is called with &#x60;Accept: application/json&#x60; in the header, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration! &#x60;browser_location_change_required&#x60;: Usually sent when an AJAX request indicates that the browser needs to open a specific URL. Most likely used in Social Sign In flows.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param flow The Registration Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/registration?flow&#x3D;abcde&#x60;). (required)
     * @param submitSelfServiceRegistrationFlowBody  (optional)
     * @return SuccessfulSelfServiceRegistrationWithoutBrowser
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulSelfServiceRegistrationWithoutBrowser </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SuccessfulSelfServiceRegistrationWithoutBrowser submitSelfServiceRegistrationFlow(String flow, SubmitSelfServiceRegistrationFlowBody submitSelfServiceRegistrationFlowBody) throws ApiException {
        ApiResponse<SuccessfulSelfServiceRegistrationWithoutBrowser> localVarResp = submitSelfServiceRegistrationFlowWithHttpInfo(flow, submitSelfServiceRegistrationFlowBody);
        return localVarResp.getData();
    }

    /**
     * Submit a Registration Flow
     * Use this endpoint to complete a registration flow by sending an identity&#39;s traits and password. This endpoint behaves differently for API and browser flows.  API flows expect &#x60;application/json&#x60; to be sent in the body and respond with HTTP 200 and a application/json body with the created identity success - if the session hook is configured the &#x60;session&#x60; and &#x60;session_token&#x60; will also be included; HTTP 302 redirect to a fresh registration flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  Browser flows expect a Content-Type of &#x60;application/x-www-form-urlencoded&#x60; or &#x60;application/json&#x60; to be sent in the body and respond with a HTTP 302 redirect to the post/after registration URL or the &#x60;return_to&#x60; value if it was set and if the registration succeeded; a HTTP 302 redirect to the registration UI URL with the flow ID containing the validation errors otherwise.  Browser flows with an accept header of &#x60;application/json&#x60; will not redirect but instead respond with HTTP 200 and a application/json body with the signed in identity and a &#x60;Set-Cookie&#x60; header on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  If this endpoint is called with &#x60;Accept: application/json&#x60; in the header, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration! &#x60;browser_location_change_required&#x60;: Usually sent when an AJAX request indicates that the browser needs to open a specific URL. Most likely used in Social Sign In flows.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param flow The Registration Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/registration?flow&#x3D;abcde&#x60;). (required)
     * @param submitSelfServiceRegistrationFlowBody  (optional)
     * @return ApiResponse&lt;SuccessfulSelfServiceRegistrationWithoutBrowser&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulSelfServiceRegistrationWithoutBrowser </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SuccessfulSelfServiceRegistrationWithoutBrowser> submitSelfServiceRegistrationFlowWithHttpInfo(String flow, SubmitSelfServiceRegistrationFlowBody submitSelfServiceRegistrationFlowBody) throws ApiException {
        okhttp3.Call localVarCall = submitSelfServiceRegistrationFlowValidateBeforeCall(flow, submitSelfServiceRegistrationFlowBody, null);
        Type localVarReturnType = new TypeToken<SuccessfulSelfServiceRegistrationWithoutBrowser>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Submit a Registration Flow (asynchronously)
     * Use this endpoint to complete a registration flow by sending an identity&#39;s traits and password. This endpoint behaves differently for API and browser flows.  API flows expect &#x60;application/json&#x60; to be sent in the body and respond with HTTP 200 and a application/json body with the created identity success - if the session hook is configured the &#x60;session&#x60; and &#x60;session_token&#x60; will also be included; HTTP 302 redirect to a fresh registration flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  Browser flows expect a Content-Type of &#x60;application/x-www-form-urlencoded&#x60; or &#x60;application/json&#x60; to be sent in the body and respond with a HTTP 302 redirect to the post/after registration URL or the &#x60;return_to&#x60; value if it was set and if the registration succeeded; a HTTP 302 redirect to the registration UI URL with the flow ID containing the validation errors otherwise.  Browser flows with an accept header of &#x60;application/json&#x60; will not redirect but instead respond with HTTP 200 and a application/json body with the signed in identity and a &#x60;Set-Cookie&#x60; header on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors.  If this endpoint is called with &#x60;Accept: application/json&#x60; in the header, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_already_available&#x60;: The user is already signed in. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration! &#x60;browser_location_change_required&#x60;: Usually sent when an AJAX request indicates that the browser needs to open a specific URL. Most likely used in Social Sign In flows.  More information can be found at [Ory Kratos User Login and User Registration Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-login-user-registration).
     * @param flow The Registration Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/registration?flow&#x3D;abcde&#x60;). (required)
     * @param submitSelfServiceRegistrationFlowBody  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successfulSelfServiceRegistrationWithoutBrowser </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceRegistrationFlow </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceRegistrationFlowAsync(String flow, SubmitSelfServiceRegistrationFlowBody submitSelfServiceRegistrationFlowBody, final ApiCallback<SuccessfulSelfServiceRegistrationWithoutBrowser> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitSelfServiceRegistrationFlowValidateBeforeCall(flow, submitSelfServiceRegistrationFlowBody, _callback);
        Type localVarReturnType = new TypeToken<SuccessfulSelfServiceRegistrationWithoutBrowser>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitSelfServiceSettingsFlow
     * @param flow The Settings Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/settings?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param submitSelfServiceSettingsFlowBody  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceSettingsFlowCall(String flow, String xSessionToken, SubmitSelfServiceSettingsFlowBody submitSelfServiceSettingsFlowBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = submitSelfServiceSettingsFlowBody;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/settings";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (flow != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("flow", flow));
        }

        if (xSessionToken != null) {
            localVarHeaderParams.put("X-Session-Token", localVarApiClient.parameterToString(xSessionToken));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-www-form-urlencoded"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitSelfServiceSettingsFlowValidateBeforeCall(String flow, String xSessionToken, SubmitSelfServiceSettingsFlowBody submitSelfServiceSettingsFlowBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'flow' is set
        if (flow == null) {
            throw new ApiException("Missing the required parameter 'flow' when calling submitSelfServiceSettingsFlow(Async)");
        }
        

        okhttp3.Call localVarCall = submitSelfServiceSettingsFlowCall(flow, xSessionToken, submitSelfServiceSettingsFlowBody, _callback);
        return localVarCall;

    }

    /**
     * Complete Settings Flow
     * Use this endpoint to complete a settings flow by sending an identity&#39;s updated password. This endpoint behaves differently for API and browser flows.  API-initiated flows expect &#x60;application/json&#x60; to be sent in the body and respond with HTTP 200 and an application/json body with the session token on success; HTTP 302 redirect to a fresh settings flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors. HTTP 401 when the endpoint is called without a valid session token. HTTP 403 when &#x60;selfservice.flows.settings.privileged_session_max_age&#x60; was reached or the session&#39;s AAL is too low. Implies that the user needs to re-authenticate.  Browser flows without HTTP Header &#x60;Accept&#x60; or with &#x60;Accept: text/_*&#x60; respond with a HTTP 302 redirect to the post/after settings URL or the &#x60;return_to&#x60; value if it was set and if the flow succeeded; a HTTP 302 redirect to the Settings UI URL with the flow ID containing the validation errors otherwise. a HTTP 302 redirect to the login endpoint when &#x60;selfservice.flows.settings.privileged_session_max_age&#x60; was reached or the session&#39;s AAL is too low.  Browser flows with HTTP Header &#x60;Accept: application/json&#x60; respond with HTTP 200 and a application/json body with the signed in identity and a &#x60;Set-Cookie&#x60; header on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 401 when the endpoint is called without a valid session cookie. HTTP 403 when the page is accessed without a session cookie or the session&#39;s AAL is too low. HTTP 400 on form validation errors.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.  If this endpoint is called with a &#x60;Accept: application/json&#x60; HTTP header, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_refresh_required&#x60;: The identity requested to change something that needs a privileged session. Redirect the identity to the login init endpoint with query parameters &#x60;?refresh&#x3D;true&amp;return_to&#x3D;&lt;the-current-browser-url&gt;&#x60;, or initiate a refresh login flow otherwise. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first. &#x60;security_identity_mismatch&#x60;: The flow was interrupted with &#x60;session_refresh_required&#x60; but apparently some other identity logged in instead. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration! &#x60;browser_location_change_required&#x60;: Usually sent when an AJAX request indicates that the browser needs to open a specific URL. Most likely used in Social Sign In flows.  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param flow The Settings Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/settings?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param submitSelfServiceSettingsFlowBody  (optional)
     * @return SelfServiceSettingsFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceSettingsFlow submitSelfServiceSettingsFlow(String flow, String xSessionToken, SubmitSelfServiceSettingsFlowBody submitSelfServiceSettingsFlowBody) throws ApiException {
        ApiResponse<SelfServiceSettingsFlow> localVarResp = submitSelfServiceSettingsFlowWithHttpInfo(flow, xSessionToken, submitSelfServiceSettingsFlowBody);
        return localVarResp.getData();
    }

    /**
     * Complete Settings Flow
     * Use this endpoint to complete a settings flow by sending an identity&#39;s updated password. This endpoint behaves differently for API and browser flows.  API-initiated flows expect &#x60;application/json&#x60; to be sent in the body and respond with HTTP 200 and an application/json body with the session token on success; HTTP 302 redirect to a fresh settings flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors. HTTP 401 when the endpoint is called without a valid session token. HTTP 403 when &#x60;selfservice.flows.settings.privileged_session_max_age&#x60; was reached or the session&#39;s AAL is too low. Implies that the user needs to re-authenticate.  Browser flows without HTTP Header &#x60;Accept&#x60; or with &#x60;Accept: text/_*&#x60; respond with a HTTP 302 redirect to the post/after settings URL or the &#x60;return_to&#x60; value if it was set and if the flow succeeded; a HTTP 302 redirect to the Settings UI URL with the flow ID containing the validation errors otherwise. a HTTP 302 redirect to the login endpoint when &#x60;selfservice.flows.settings.privileged_session_max_age&#x60; was reached or the session&#39;s AAL is too low.  Browser flows with HTTP Header &#x60;Accept: application/json&#x60; respond with HTTP 200 and a application/json body with the signed in identity and a &#x60;Set-Cookie&#x60; header on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 401 when the endpoint is called without a valid session cookie. HTTP 403 when the page is accessed without a session cookie or the session&#39;s AAL is too low. HTTP 400 on form validation errors.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.  If this endpoint is called with a &#x60;Accept: application/json&#x60; HTTP header, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_refresh_required&#x60;: The identity requested to change something that needs a privileged session. Redirect the identity to the login init endpoint with query parameters &#x60;?refresh&#x3D;true&amp;return_to&#x3D;&lt;the-current-browser-url&gt;&#x60;, or initiate a refresh login flow otherwise. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first. &#x60;security_identity_mismatch&#x60;: The flow was interrupted with &#x60;session_refresh_required&#x60; but apparently some other identity logged in instead. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration! &#x60;browser_location_change_required&#x60;: Usually sent when an AJAX request indicates that the browser needs to open a specific URL. Most likely used in Social Sign In flows.  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param flow The Settings Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/settings?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param submitSelfServiceSettingsFlowBody  (optional)
     * @return ApiResponse&lt;SelfServiceSettingsFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceSettingsFlow> submitSelfServiceSettingsFlowWithHttpInfo(String flow, String xSessionToken, SubmitSelfServiceSettingsFlowBody submitSelfServiceSettingsFlowBody) throws ApiException {
        okhttp3.Call localVarCall = submitSelfServiceSettingsFlowValidateBeforeCall(flow, xSessionToken, submitSelfServiceSettingsFlowBody, null);
        Type localVarReturnType = new TypeToken<SelfServiceSettingsFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Complete Settings Flow (asynchronously)
     * Use this endpoint to complete a settings flow by sending an identity&#39;s updated password. This endpoint behaves differently for API and browser flows.  API-initiated flows expect &#x60;application/json&#x60; to be sent in the body and respond with HTTP 200 and an application/json body with the session token on success; HTTP 302 redirect to a fresh settings flow if the original flow expired with the appropriate error messages set; HTTP 400 on form validation errors. HTTP 401 when the endpoint is called without a valid session token. HTTP 403 when &#x60;selfservice.flows.settings.privileged_session_max_age&#x60; was reached or the session&#39;s AAL is too low. Implies that the user needs to re-authenticate.  Browser flows without HTTP Header &#x60;Accept&#x60; or with &#x60;Accept: text/_*&#x60; respond with a HTTP 302 redirect to the post/after settings URL or the &#x60;return_to&#x60; value if it was set and if the flow succeeded; a HTTP 302 redirect to the Settings UI URL with the flow ID containing the validation errors otherwise. a HTTP 302 redirect to the login endpoint when &#x60;selfservice.flows.settings.privileged_session_max_age&#x60; was reached or the session&#39;s AAL is too low.  Browser flows with HTTP Header &#x60;Accept: application/json&#x60; respond with HTTP 200 and a application/json body with the signed in identity and a &#x60;Set-Cookie&#x60; header on success; HTTP 302 redirect to a fresh login flow if the original flow expired with the appropriate error messages set; HTTP 401 when the endpoint is called without a valid session cookie. HTTP 403 when the page is accessed without a session cookie or the session&#39;s AAL is too low. HTTP 400 on form validation errors.  Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.  If this endpoint is called with a &#x60;Accept: application/json&#x60; HTTP header, the response contains the flow without a redirect. In the case of an error, the &#x60;error.id&#x60; of the JSON response body can be one of:  &#x60;session_refresh_required&#x60;: The identity requested to change something that needs a privileged session. Redirect the identity to the login init endpoint with query parameters &#x60;?refresh&#x3D;true&amp;return_to&#x3D;&lt;the-current-browser-url&gt;&#x60;, or initiate a refresh login flow otherwise. &#x60;security_csrf_violation&#x60;: Unable to fetch the flow because a CSRF violation occurred. &#x60;session_inactive&#x60;: No Ory Session was found - sign in a user first. &#x60;security_identity_mismatch&#x60;: The flow was interrupted with &#x60;session_refresh_required&#x60; but apparently some other identity logged in instead. &#x60;security_identity_mismatch&#x60;: The requested &#x60;?return_to&#x60; address is not allowed to be used. Adjust this in the configuration! &#x60;browser_location_change_required&#x60;: Usually sent when an AJAX request indicates that the browser needs to open a specific URL. Most likely used in Social Sign In flows.  More information can be found at [Ory Kratos User Settings &amp; Profile Management Documentation](../self-service/flows/user-settings).
     * @param flow The Settings Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/settings?flow&#x3D;abcde&#x60;). (required)
     * @param xSessionToken The Session Token of the Identity performing the settings flow. (optional)
     * @param submitSelfServiceSettingsFlowBody  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceSettingsFlow </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> selfServiceBrowserLocationChangeRequiredError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceSettingsFlowAsync(String flow, String xSessionToken, SubmitSelfServiceSettingsFlowBody submitSelfServiceSettingsFlowBody, final ApiCallback<SelfServiceSettingsFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitSelfServiceSettingsFlowValidateBeforeCall(flow, xSessionToken, submitSelfServiceSettingsFlowBody, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceSettingsFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitSelfServiceVerificationFlow
     * @param flow The Verification Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/verification?flow&#x3D;abcde&#x60;). (required)
     * @param token Verification Token  The verification token which completes the verification request. If the token is invalid (e.g. expired) an error will be shown to the end-user.  This parameter is usually set in a link and not used by any direct API call. (optional)
     * @param submitSelfServiceVerificationFlowBody  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceVerificationFlowCall(String flow, String token, SubmitSelfServiceVerificationFlowBody submitSelfServiceVerificationFlowBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = submitSelfServiceVerificationFlowBody;

        // create path and map variables
        String localVarPath = "/api/kratos/public/self-service/verification";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (flow != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("flow", flow));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-www-form-urlencoded"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitSelfServiceVerificationFlowValidateBeforeCall(String flow, String token, SubmitSelfServiceVerificationFlowBody submitSelfServiceVerificationFlowBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'flow' is set
        if (flow == null) {
            throw new ApiException("Missing the required parameter 'flow' when calling submitSelfServiceVerificationFlow(Async)");
        }
        

        okhttp3.Call localVarCall = submitSelfServiceVerificationFlowCall(flow, token, submitSelfServiceVerificationFlowBody, _callback);
        return localVarCall;

    }

    /**
     * Complete Verification Flow
     * Use this endpoint to complete a verification flow. This endpoint behaves differently for API and browser flows and has several states:  &#x60;choose_method&#x60; expects &#x60;flow&#x60; (in the URL query) and &#x60;email&#x60; (in the body) to be sent and works with API- and Browser-initiated flows. For API clients and Browser clients with HTTP Header &#x60;Accept: application/json&#x60; it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid and a HTTP 302 Found redirect with a fresh verification flow if the flow was otherwise invalid (e.g. expired). For Browser clients without HTTP Header &#x60;Accept&#x60; or with &#x60;Accept: text/_*&#x60; it returns a HTTP 302 Found redirect to the Verification UI URL with the Verification Flow ID appended. &#x60;sent_email&#x60; is the success state after &#x60;choose_method&#x60; when using the &#x60;link&#x60; method and allows the user to request another verification email. It works for both API and Browser-initiated flows and returns the same responses as the flow in &#x60;choose_method&#x60; state. &#x60;passed_challenge&#x60; expects a &#x60;token&#x60; to be sent in the URL query and given the nature of the flow (\&quot;sending a verification link\&quot;) does not have any API capabilities. The server responds with a HTTP 302 Found redirect either to the Settings UI URL (if the link was valid) and instructs the user to update their password, or a redirect to the Verification UI URL with a new Verification Flow ID which contains an error message that the verification link was invalid.  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @param flow The Verification Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/verification?flow&#x3D;abcde&#x60;). (required)
     * @param token Verification Token  The verification token which completes the verification request. If the token is invalid (e.g. expired) an error will be shown to the end-user.  This parameter is usually set in a link and not used by any direct API call. (optional)
     * @param submitSelfServiceVerificationFlowBody  (optional)
     * @return SelfServiceVerificationFlow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public SelfServiceVerificationFlow submitSelfServiceVerificationFlow(String flow, String token, SubmitSelfServiceVerificationFlowBody submitSelfServiceVerificationFlowBody) throws ApiException {
        ApiResponse<SelfServiceVerificationFlow> localVarResp = submitSelfServiceVerificationFlowWithHttpInfo(flow, token, submitSelfServiceVerificationFlowBody);
        return localVarResp.getData();
    }

    /**
     * Complete Verification Flow
     * Use this endpoint to complete a verification flow. This endpoint behaves differently for API and browser flows and has several states:  &#x60;choose_method&#x60; expects &#x60;flow&#x60; (in the URL query) and &#x60;email&#x60; (in the body) to be sent and works with API- and Browser-initiated flows. For API clients and Browser clients with HTTP Header &#x60;Accept: application/json&#x60; it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid and a HTTP 302 Found redirect with a fresh verification flow if the flow was otherwise invalid (e.g. expired). For Browser clients without HTTP Header &#x60;Accept&#x60; or with &#x60;Accept: text/_*&#x60; it returns a HTTP 302 Found redirect to the Verification UI URL with the Verification Flow ID appended. &#x60;sent_email&#x60; is the success state after &#x60;choose_method&#x60; when using the &#x60;link&#x60; method and allows the user to request another verification email. It works for both API and Browser-initiated flows and returns the same responses as the flow in &#x60;choose_method&#x60; state. &#x60;passed_challenge&#x60; expects a &#x60;token&#x60; to be sent in the URL query and given the nature of the flow (\&quot;sending a verification link\&quot;) does not have any API capabilities. The server responds with a HTTP 302 Found redirect either to the Settings UI URL (if the link was valid) and instructs the user to update their password, or a redirect to the Verification UI URL with a new Verification Flow ID which contains an error message that the verification link was invalid.  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @param flow The Verification Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/verification?flow&#x3D;abcde&#x60;). (required)
     * @param token Verification Token  The verification token which completes the verification request. If the token is invalid (e.g. expired) an error will be shown to the end-user.  This parameter is usually set in a link and not used by any direct API call. (optional)
     * @param submitSelfServiceVerificationFlowBody  (optional)
     * @return ApiResponse&lt;SelfServiceVerificationFlow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SelfServiceVerificationFlow> submitSelfServiceVerificationFlowWithHttpInfo(String flow, String token, SubmitSelfServiceVerificationFlowBody submitSelfServiceVerificationFlowBody) throws ApiException {
        okhttp3.Call localVarCall = submitSelfServiceVerificationFlowValidateBeforeCall(flow, token, submitSelfServiceVerificationFlowBody, null);
        Type localVarReturnType = new TypeToken<SelfServiceVerificationFlow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Complete Verification Flow (asynchronously)
     * Use this endpoint to complete a verification flow. This endpoint behaves differently for API and browser flows and has several states:  &#x60;choose_method&#x60; expects &#x60;flow&#x60; (in the URL query) and &#x60;email&#x60; (in the body) to be sent and works with API- and Browser-initiated flows. For API clients and Browser clients with HTTP Header &#x60;Accept: application/json&#x60; it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid and a HTTP 302 Found redirect with a fresh verification flow if the flow was otherwise invalid (e.g. expired). For Browser clients without HTTP Header &#x60;Accept&#x60; or with &#x60;Accept: text/_*&#x60; it returns a HTTP 302 Found redirect to the Verification UI URL with the Verification Flow ID appended. &#x60;sent_email&#x60; is the success state after &#x60;choose_method&#x60; when using the &#x60;link&#x60; method and allows the user to request another verification email. It works for both API and Browser-initiated flows and returns the same responses as the flow in &#x60;choose_method&#x60; state. &#x60;passed_challenge&#x60; expects a &#x60;token&#x60; to be sent in the URL query and given the nature of the flow (\&quot;sending a verification link\&quot;) does not have any API capabilities. The server responds with a HTTP 302 Found redirect either to the Settings UI URL (if the link was valid) and instructs the user to update their password, or a redirect to the Verification UI URL with a new Verification Flow ID which contains an error message that the verification link was invalid.  More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/selfservice/flows/verify-email-account-activation).
     * @param flow The Verification Flow ID  The value for this parameter comes from &#x60;flow&#x60; URL Query parameter sent to your application (e.g. &#x60;/verification?flow&#x3D;abcde&#x60;). (required)
     * @param token Verification Token  The verification token which completes the verification request. If the token is invalid (e.g. expired) an error will be shown to the end-user.  This parameter is usually set in a link and not used by any direct API call. (optional)
     * @param submitSelfServiceVerificationFlowBody  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 302 </td><td> Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> selfServiceVerificationFlow </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitSelfServiceVerificationFlowAsync(String flow, String token, SubmitSelfServiceVerificationFlowBody submitSelfServiceVerificationFlowBody, final ApiCallback<SelfServiceVerificationFlow> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitSelfServiceVerificationFlowValidateBeforeCall(flow, token, submitSelfServiceVerificationFlowBody, _callback);
        Type localVarReturnType = new TypeToken<SelfServiceVerificationFlow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for toSession
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> session </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call toSessionCall(String xSessionToken, String cookie, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/kratos/public/sessions/whoami";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSessionToken != null) {
            localVarHeaderParams.put("X-Session-Token", localVarApiClient.parameterToString(xSessionToken));
        }

        if (cookie != null) {
            localVarHeaderParams.put("Cookie", localVarApiClient.parameterToString(cookie));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call toSessionValidateBeforeCall(String xSessionToken, String cookie, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = toSessionCall(xSessionToken, cookie, _callback);
        return localVarCall;

    }

    /**
     * Check Who the Current HTTP Session Belongs To
     * Uses the HTTP Headers in the GET request to determine (e.g. by using checking the cookies) who is authenticated. Returns a session object in the body or 401 if the credentials are invalid or no credentials were sent. Additionally when the request it successful it adds the user ID to the &#39;X-Kratos-Authenticated-Identity-Id&#39; header in the response.  If you call this endpoint from a server-side application, you must forward the HTTP Cookie Header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/protected-endpoint&#39;, async function (req, res) { const session &#x3D; await client.toSession(undefined, req.header(&#39;cookie&#39;))  console.log(session) }) &#x60;&#x60;&#x60;  When calling this endpoint from a non-browser application (e.g. mobile app) you must include the session token:  &#x60;&#x60;&#x60;js pseudo-code example ... const session &#x3D; await client.toSession(\&quot;the-session-token\&quot;)  console.log(session) &#x60;&#x60;&#x60;  Depending on your configuration this endpoint might return a 403 status code if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor or change the configuration.  This endpoint is useful for:  AJAX calls. Remember to send credentials and set up CORS correctly! Reverse proxies and API Gateways Server-side calls - use the &#x60;X-Session-Token&#x60; header!  This endpoint authenticates users by checking  if the &#x60;Cookie&#x60; HTTP header was set containing an Ory Kratos Session Cookie; if the &#x60;Authorization: bearer &lt;ory-session-token&gt;&#x60; HTTP header was set with a valid Ory Kratos Session Token; if the &#x60;X-Session-Token&#x60; HTTP header was set with a valid Ory Kratos Session Token.  If none of these headers are set or the cooke or token are invalid, the endpoint returns a HTTP 401 status code.  As explained above, this request may fail due to several reasons. The &#x60;error.id&#x60; can be one of:  &#x60;session_inactive&#x60;: No active session was found in the request (e.g. no Ory Session Cookie / Ory Session Token). &#x60;session_aal2_required&#x60;: An active session was found but it does not fulfil the Authenticator Assurance Level, implying that the session must (e.g.) authenticate the second factor.
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @return Session
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> session </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public Session toSession(String xSessionToken, String cookie) throws ApiException {
        ApiResponse<Session> localVarResp = toSessionWithHttpInfo(xSessionToken, cookie);
        return localVarResp.getData();
    }

    /**
     * Check Who the Current HTTP Session Belongs To
     * Uses the HTTP Headers in the GET request to determine (e.g. by using checking the cookies) who is authenticated. Returns a session object in the body or 401 if the credentials are invalid or no credentials were sent. Additionally when the request it successful it adds the user ID to the &#39;X-Kratos-Authenticated-Identity-Id&#39; header in the response.  If you call this endpoint from a server-side application, you must forward the HTTP Cookie Header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/protected-endpoint&#39;, async function (req, res) { const session &#x3D; await client.toSession(undefined, req.header(&#39;cookie&#39;))  console.log(session) }) &#x60;&#x60;&#x60;  When calling this endpoint from a non-browser application (e.g. mobile app) you must include the session token:  &#x60;&#x60;&#x60;js pseudo-code example ... const session &#x3D; await client.toSession(\&quot;the-session-token\&quot;)  console.log(session) &#x60;&#x60;&#x60;  Depending on your configuration this endpoint might return a 403 status code if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor or change the configuration.  This endpoint is useful for:  AJAX calls. Remember to send credentials and set up CORS correctly! Reverse proxies and API Gateways Server-side calls - use the &#x60;X-Session-Token&#x60; header!  This endpoint authenticates users by checking  if the &#x60;Cookie&#x60; HTTP header was set containing an Ory Kratos Session Cookie; if the &#x60;Authorization: bearer &lt;ory-session-token&gt;&#x60; HTTP header was set with a valid Ory Kratos Session Token; if the &#x60;X-Session-Token&#x60; HTTP header was set with a valid Ory Kratos Session Token.  If none of these headers are set or the cooke or token are invalid, the endpoint returns a HTTP 401 status code.  As explained above, this request may fail due to several reasons. The &#x60;error.id&#x60; can be one of:  &#x60;session_inactive&#x60;: No active session was found in the request (e.g. no Ory Session Cookie / Ory Session Token). &#x60;session_aal2_required&#x60;: An active session was found but it does not fulfil the Authenticator Assurance Level, implying that the session must (e.g.) authenticate the second factor.
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @return ApiResponse&lt;Session&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> session </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Session> toSessionWithHttpInfo(String xSessionToken, String cookie) throws ApiException {
        okhttp3.Call localVarCall = toSessionValidateBeforeCall(xSessionToken, cookie, null);
        Type localVarReturnType = new TypeToken<Session>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Check Who the Current HTTP Session Belongs To (asynchronously)
     * Uses the HTTP Headers in the GET request to determine (e.g. by using checking the cookies) who is authenticated. Returns a session object in the body or 401 if the credentials are invalid or no credentials were sent. Additionally when the request it successful it adds the user ID to the &#39;X-Kratos-Authenticated-Identity-Id&#39; header in the response.  If you call this endpoint from a server-side application, you must forward the HTTP Cookie Header to this endpoint:  &#x60;&#x60;&#x60;js pseudo-code example router.get(&#39;/protected-endpoint&#39;, async function (req, res) { const session &#x3D; await client.toSession(undefined, req.header(&#39;cookie&#39;))  console.log(session) }) &#x60;&#x60;&#x60;  When calling this endpoint from a non-browser application (e.g. mobile app) you must include the session token:  &#x60;&#x60;&#x60;js pseudo-code example ... const session &#x3D; await client.toSession(\&quot;the-session-token\&quot;)  console.log(session) &#x60;&#x60;&#x60;  Depending on your configuration this endpoint might return a 403 status code if the session has a lower Authenticator Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user to sign in with the second factor or change the configuration.  This endpoint is useful for:  AJAX calls. Remember to send credentials and set up CORS correctly! Reverse proxies and API Gateways Server-side calls - use the &#x60;X-Session-Token&#x60; header!  This endpoint authenticates users by checking  if the &#x60;Cookie&#x60; HTTP header was set containing an Ory Kratos Session Cookie; if the &#x60;Authorization: bearer &lt;ory-session-token&gt;&#x60; HTTP header was set with a valid Ory Kratos Session Token; if the &#x60;X-Session-Token&#x60; HTTP header was set with a valid Ory Kratos Session Token.  If none of these headers are set or the cooke or token are invalid, the endpoint returns a HTTP 401 status code.  As explained above, this request may fail due to several reasons. The &#x60;error.id&#x60; can be one of:  &#x60;session_inactive&#x60;: No active session was found in the request (e.g. no Ory Session Cookie / Ory Session Token). &#x60;session_aal2_required&#x60;: An active session was found but it does not fulfil the Authenticator Assurance Level, implying that the session must (e.g.) authenticate the second factor.
     * @param xSessionToken Set the Session Token when calling from non-browser clients. A session token has a format of &#x60;MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj&#x60;. (optional)
     * @param cookie Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that scenario you must include the HTTP Cookie Header which originally was included in the request to your server. An example of a session in the HTTP Cookie Header is: &#x60;ory_kratos_session&#x3D;a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f&#x3D;&#x3D;&#x60;.  It is ok if more than one cookie are included here as all other cookies will be ignored. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> session </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> jsonError </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> jsonError </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call toSessionAsync(String xSessionToken, String cookie, final ApiCallback<Session> _callback) throws ApiException {

        okhttp3.Call localVarCall = toSessionValidateBeforeCall(xSessionToken, cookie, _callback);
        Type localVarReturnType = new TypeToken<Session>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
