package site.howaric.encryption;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {

    private static final String algorithm = "MD5";

    /**
     * do MD5 encode
     *
     * @param plainText target text
     * @return md5 encoded string
     */
    public static String MD5(String plainText) {
        byte[] secretBytes = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance(algorithm);
            md5.update(plainText.getBytes());
            secretBytes = md5.digest();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return bytesToHex(secretBytes).toUpperCase();
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; i++) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

}
