package site.howaric.encryption;

public interface Signed {

    /**
     * Sign data with specific key
     *
     * @param secretKey RSA publicKey or privateKey
     * @param keyType   key type
     */
    public void sign(String secretKey, SecretKeyType keyType);

    /**
     * verify data with specific key
     *
     * @param secretKey RSA publicKey or privateKey
     * @param keyType   key type
     */
    public void verify(String secretKey, SecretKeyType keyType);

    /**
     * get nonce
     *
     * @return nonce
     */
    public String getNonce();

    /**
     * get timestamp
     *
     * @return timestamp
     */
    public String getTimestamp();

    /**
     * get sign
     *
     * @return sign
     */
    public String getSign();

}
