package site.howaric.poll;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

public class PollExecutor {

    private static final Logger LOG = LoggerFactory.getLogger(PollExecutor.class);

    public static void execute(PollJob pollJob, Integer interval, Integer duration, TimeUnit unit) {
        if (interval <= 0 || duration <= 0) {
            throw new PollException("Illegal interval or duration time");
        }
        int index = 0;
        long intervalSeconds = unit.toSeconds(interval.longValue());
        long intervalMillis = unit.toMillis(interval.longValue());
        long durationSeconds = unit.toSeconds(duration.longValue());
        while (index * intervalSeconds < durationSeconds) {
            if (pollJob.poll()) {
                return;
            }
            LOG.info("PollJob Progress [index:{} interval:{} duration:{}] TimeUnit:{}", index + 1, interval, duration, unit.name());
            sleep(intervalMillis);
            index++;
        }
        throw new PollException("PollJob Timeout");
    }

    public static void execute(PollJob pollJob, Integer interval, Integer duration) {
        execute(pollJob, interval, duration, TimeUnit.SECONDS);
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        } catch (InterruptedException e) {
            LOG.error("Sleep in PollJob Interrupted", e);
        }
    }

}

class PollException extends RuntimeException {

    private static final long serialVersionUID = -9063487033474811787L;

    public PollException() {
        super();
    }

    public PollException(String message, Throwable cause) {
        super(message, cause);
    }

    public PollException(String message) {
        super(message);
    }

    public PollException(Throwable cause) {
        super(cause);
    }

}