/*
 * Decompiled with CFR 0.152.
 */
package kalang;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import kalang.ast.ClassNode;
import kalang.compiler.CodeGenerator;
import kalang.compiler.CompilationUnit;
import kalang.compiler.KalangCompiler;
import kalang.compiler.KalangSource;
import kalang.compiler.SourceLoader;
import kalang.compiler.codegen.Ast2Class;
import kalang.tool.FileSystemSourceLoader;
import kalang.tool.MemoryOutputManager;
import org.apache.commons.io.FileUtils;

public class KalangClassLoader
extends URLClassLoader
implements CodeGenerator {
    private final KalangCompiler compiler;
    private final HashMap<String, Class> loadedClasses = new HashMap();
    private final FileSystemSourceLoader sourceLoader;

    public KalangClassLoader() {
        this(new File[0]);
    }

    public KalangClassLoader(File[] sourceDir) {
        super(new URL[0]);
        this.sourceLoader = new FileSystemSourceLoader(sourceDir, new String[]{"kl", "kalang"});
        final KalangClassLoader cg = this;
        this.compiler = new KalangCompiler(){

            @Override
            public SourceLoader getSourceLoader() {
                return KalangClassLoader.this.sourceLoader;
            }

            @Override
            public CodeGenerator createCodeGenerator(CompilationUnit compilationUnit) {
                return cg;
            }
        };
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz = this.loadedClasses.get(name);
        if (clazz != null) {
            return clazz;
        }
        KalangSource src = this.sourceLoader.loadSource(name);
        if (src != null) {
            this.compiler.addSource(src);
            this.compiler.compile();
        }
        if ((clazz = this.loadedClasses.get(name)) != null) {
            return clazz;
        }
        return super.findClass(name);
    }

    @Override
    public void generate(ClassNode classNode) {
        String[] names;
        MemoryOutputManager outputManager = new MemoryOutputManager();
        Ast2Class ast2Class = new Ast2Class(outputManager);
        ast2Class.generate(classNode);
        for (String name : names = outputManager.getClassNames()) {
            byte[] bs = outputManager.getBytes(name);
            if (bs == null) continue;
            Class<?> clazz = this.defineClass(name, bs, 0, bs.length);
            this.loadedClasses.put(name, clazz);
        }
    }

    public void addClassPath(File path) {
        try {
            super.addURL(path.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(KalangClassLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.sourceLoader.addSourceDir(path);
    }

    public Class parseSource(String className, String code, String fileName) {
        this.compiler.addSource(className, code, fileName);
        this.compiler.compile();
        return this.loadedClasses.get(className);
    }

    public Class parseFile(String className, File file) throws IOException {
        String code = FileUtils.readFileToString((File)file);
        return this.parseSource(className, code, file.getName());
    }
}

