/*
 * Decompiled with CFR 0.152.
 */
package kalang.ast;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import kalang.ast.AnnotationNode;
import kalang.ast.Annotationable;
import kalang.ast.AstNode;
import kalang.ast.FieldNode;
import kalang.ast.MethodNode;
import kalang.ast.Statement;
import kalang.core.GenericType;
import kalang.core.ObjectType;
import kalang.core.Type;

public class ClassNode
extends AstNode
implements Annotationable {
    public int modifier;
    public String name;
    @Nullable
    public String fileName = null;
    @Nullable
    public ObjectType superType;
    private final List<FieldNode> fields = new ArrayList<FieldNode>();
    protected final List<MethodNode> methods = new LinkedList<MethodNode>();
    private final List<ObjectType> interfaces = new LinkedList<ObjectType>();
    public final List<AnnotationNode> annotations = new LinkedList<AnnotationNode>();
    public final List<Statement> staticInitStmts = new LinkedList<Statement>();
    public final List<Statement> initStmts = new LinkedList<Statement>();
    protected List<GenericType> genericTypes = new LinkedList<GenericType>();
    public final List<ClassNode> classes = new LinkedList<ClassNode>();
    @Nullable
    public ClassNode enclosingClass;

    public ClassNode() {
    }

    public ClassNode(String name, int modifier) {
        this.modifier = modifier;
        this.name = name;
    }

    public void declareGenericType(GenericType type) {
        this.genericTypes.add(type);
    }

    public GenericType[] getGenericTypes() {
        return this.genericTypes.toArray(new GenericType[this.genericTypes.size()]);
    }

    @Override
    public List<AstNode> getChildren() {
        LinkedList<AstNode> ls = new LinkedList<AstNode>();
        this.addChild(ls, this.fields);
        this.addChild(ls, this.methods);
        ls.addAll(this.classes);
        return ls;
    }

    public FieldNode createField(Type type, String name, int modifier) {
        FieldNode fieldNode = new FieldNode(this, type, name, modifier);
        this.fields.add(fieldNode);
        return fieldNode;
    }

    public MethodNode createMethodNode(Type type, String name, int modifier) {
        MethodNode md = new MethodNode(this, type, name, modifier);
        this.methods.add(md);
        return md;
    }

    public MethodNode[] getDeclaredMethodNodes() {
        return this.methods.toArray(new MethodNode[0]);
    }

    @Override
    public AnnotationNode[] getAnnotations() {
        return this.annotations.toArray(new AnnotationNode[0]);
    }

    public FieldNode[] getFields() {
        return this.fields.toArray(new FieldNode[this.fields.size()]);
    }

    public void addInterface(ObjectType type) {
        this.interfaces.add(type);
    }

    public ObjectType[] getInterfaces() {
        return this.interfaces.toArray(new ObjectType[this.interfaces.size()]);
    }
}

