/*
 * Decompiled with CFR 0.152.
 */
package kalang.ast;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.ast.AstNode;
import kalang.ast.BlockStmt;
import kalang.ast.ExprNode;
import kalang.ast.Statement;

public class LoopStmt
extends Statement {
    private BlockStmt loopBody;
    @Nullable
    private final ExprNode preConditionExpr;
    @Nullable
    private final ExprNode postConditionExpr;

    public LoopStmt(ExprNode preConditionExpr, ExprNode postConditionExpr) {
        this(preConditionExpr, postConditionExpr, null);
    }

    public LoopStmt(@Nullable ExprNode preConditionExpr, @Nullable ExprNode postConditionExpr, @Nullable BlockStmt loopBody) {
        this.loopBody = loopBody == null ? new BlockStmt() : loopBody;
        this.preConditionExpr = preConditionExpr;
        this.postConditionExpr = postConditionExpr;
    }

    @Override
    public List<AstNode> getChildren() {
        LinkedList<AstNode> ls = new LinkedList<AstNode>();
        this.addChild(ls, this.loopBody);
        this.addChild(ls, this.preConditionExpr);
        this.addChild(ls, this.postConditionExpr);
        return ls;
    }

    @Nonnull
    public BlockStmt getLoopBody() {
        return this.loopBody;
    }

    @Nullable
    public ExprNode getPreConditionExpr() {
        return this.preConditionExpr;
    }

    @Nullable
    public ExprNode getPostConditionExpr() {
        return this.postConditionExpr;
    }
}

