/*
 * Decompiled with CFR 0.152.
 */
package kalang.ast;

import kalang.ast.ExprNode;
import kalang.ast.VarObject;
import kalang.core.ArrayType;
import kalang.core.Type;
import kalang.exception.Exceptions;

public class StoreArrayElementExpr
extends ExprNode {
    private VarObject array;
    private ExprNode index;
    private ExprNode valueExpr;

    public StoreArrayElementExpr(VarObject array, ExprNode index, ExprNode from) {
        if (!(array.getType() instanceof ArrayType)) {
            throw Exceptions.illegalArgument(array);
        }
        this.array = array;
        this.index = index;
        this.valueExpr = from;
    }

    @Override
    public Type getType() {
        return ((ArrayType)this.array.getType()).getComponentType();
    }

    public VarObject getArray() {
        return this.array;
    }

    public ExprNode getIndex() {
        return this.index;
    }

    public ExprNode getValueExpr() {
        return this.valueExpr;
    }
}

