/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import javax.annotation.Nonnull;
import kalang.antlr.KalangLexer;
import kalang.antlr.KalangParser;
import kalang.ast.ClassNode;
import kalang.compiler.AstBuilder;
import kalang.compiler.CodeGenerator;
import kalang.compiler.CompileContext;
import kalang.compiler.DiagnosisHandler;
import kalang.compiler.KalangSource;
import kalang.compiler.SemanticAnalyzer;
import org.antlr.v4.runtime.CommonTokenStream;

public class CompilationUnit {
    private final KalangLexer lexer;
    private final KalangParser parser;
    private final AstBuilder astBuilder;
    private final SemanticAnalyzer semanticAnalyzer;
    private final CommonTokenStream tokens;
    private int compilingPhase;
    private final KalangSource source;
    private final CompileContext context;

    public CompilationUnit(@Nonnull KalangSource source, CompileContext context) {
        this.source = source;
        this.context = context;
        this.lexer = context.createLexer(this, source.getText());
        this.tokens = context.createTokenStream(this, this.lexer);
        this.parser = context.createParser(this, this.tokens);
        this.astBuilder = context.createAstBuilder(this, this.parser);
        this.astBuilder.importPackage("java.lang");
        this.astBuilder.importPackage("java.util");
        this.astBuilder.importPackage("java.net");
        this.astBuilder.importPackage("java.io");
        this.astBuilder.importPackage("java.nio");
        this.astBuilder.importPackage("kalang.io");
        this.semanticAnalyzer = context.createSemanticAnalyzer(this, context.getAstLoader());
        this.compile(1);
    }

    protected void doCompilePhase(int phase) {
        if (phase == 1) {
            this.parseInit(this.context.getDiagnosisHandler());
        } else if (phase == 2) {
            this.parseMeta(this.context.getDiagnosisHandler());
        } else if (phase == 3) {
            this.parseBody(this.context.getDiagnosisHandler());
        } else if (phase != 4 && phase == 5) {
            CodeGenerator codeGenerator = this.context.createCodeGenerator(this);
            if (codeGenerator == null) {
                throw new IllegalStateException("CodeGenerator is missing");
            }
            codeGenerator.generate(this.getAst());
        }
    }

    public void compile(int targetPhase) {
        while (this.compilingPhase < targetPhase) {
            ++this.compilingPhase;
            this.doCompilePhase(this.compilingPhase);
        }
    }

    protected void parseInit(DiagnosisHandler semanticErrorHandler) {
        this.parse(semanticErrorHandler, 1);
    }

    protected void parseMeta(DiagnosisHandler semanticErrorHandler) {
        this.parse(semanticErrorHandler, 2);
    }

    public void parseBody(DiagnosisHandler semanticErrorHandler) {
        this.parse(semanticErrorHandler, 3);
    }

    protected void parse(DiagnosisHandler semanticErrorHandler, int targetParsingPhase) {
        this.astBuilder.setDiagnosisHandler(semanticErrorHandler);
        this.astBuilder.compile(targetParsingPhase, this.context.getAstLoader());
    }

    @Nonnull
    public ClassNode getAst() {
        return this.astBuilder.getAst();
    }

    @Nonnull
    public AstBuilder getAstBuilder() {
        return this.astBuilder;
    }

    @Nonnull
    public SemanticAnalyzer getSemanticAnalyzer() {
        return this.semanticAnalyzer;
    }

    @Nonnull
    public CommonTokenStream getTokenStream() {
        return this.tokens;
    }

    public KalangLexer getLexer() {
        return this.lexer;
    }

    public KalangParser getParser() {
        return this.parser;
    }

    public CommonTokenStream getTokens() {
        return this.tokens;
    }

    public KalangSource getSource() {
        return this.source;
    }

    public CompileContext getCompileContext() {
        return this.context;
    }
}

