/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import kalang.compiler.CompileContext;
import kalang.compiler.KalangSource;
import kalang.compiler.OffsetRange;

public class Diagnosis {
    private final CompileContext context;
    private Kind kind;
    private OffsetRange offset;
    private String description;
    private KalangSource source;

    public Diagnosis(CompileContext context, Kind kind, OffsetRange offset, String description, KalangSource kalangSource) {
        this.context = context;
        this.kind = kind;
        this.offset = offset;
        this.description = description;
        this.source = kalangSource;
    }

    public Kind getKind() {
        return this.kind;
    }

    public OffsetRange getOffset() {
        return this.offset;
    }

    public String getDescription() {
        return this.description;
    }

    public KalangSource getSource() {
        return this.source;
    }

    public CompileContext getContext() {
        return this.context;
    }

    public String toString() {
        String fileName = this.source == null ? "UNKNOWN SOURCE" : this.source.getFileName();
        return String.format("%s:%s:%s:%s", new Object[]{this.kind, fileName, this.offset.startLine, this.description});
    }

    public static enum Kind {
        FATAL(true),
        ERROR(true),
        WARNING(false),
        NOTE(false);

        boolean isError;

        private Kind(boolean isError) {
            this.isError = isError;
        }

        public boolean isError() {
            return this.isError;
        }
    }
}

