/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler;

import java.util.ArrayList;
import java.util.Set;
import kalang.ast.AssignExpr;
import kalang.ast.AssignableExpr;
import kalang.ast.AstNode;
import kalang.ast.AstVisitor;
import kalang.ast.BlockStmt;
import kalang.ast.CatchBlock;
import kalang.ast.ClassNode;
import kalang.ast.IfStmt;
import kalang.ast.LocalVarNode;
import kalang.ast.LoopStmt;
import kalang.ast.MethodNode;
import kalang.ast.TryStmt;
import kalang.ast.VarExpr;
import kalang.compiler.AstLoader;
import kalang.compiler.CompilationUnit;
import kalang.compiler.Diagnosis;
import kalang.compiler.DiagnosisHandler;
import kalang.compiler.DiagnosisReporter;
import kalang.core.Type;
import kalang.core.VarTable;
import kalang.util.CollectionsUtil;

public class InitializationAnalyzer
extends AstVisitor<Object> {
    private AstLoader astLoader;
    private MethodNode method;
    private CompilationUnit source;
    private VarTable<LocalVarNode, Void> assignedVars = new VarTable();
    private DiagnosisReporter diagnosisReporter;

    public InitializationAnalyzer(CompilationUnit source, AstLoader astLoader) {
        this.astLoader = astLoader;
        this.source = source;
    }

    public void check(ClassNode clz, MethodNode method, DiagnosisHandler disgnosisHandler) {
        this.diagnosisReporter = new DiagnosisReporter(this.source.getCompileContext(), disgnosisHandler, this.source.getSource());
        this.visit(method);
    }

    @Override
    public Object visit(AstNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof VarExpr && !this.assignedVars.exist(((VarExpr)node).getVar(), true)) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, ((VarExpr)node).getVar().getName() + " is uninitialized!", ((VarExpr)node).offset);
        }
        return super.visit(node);
    }

    @Override
    public Object visitAssignExpr(AssignExpr node) {
        AssignableExpr to = node.getTo();
        if (to instanceof VarExpr) {
            this.assignedVars.put(((VarExpr)to).getVar(), null);
        }
        return super.visitAssignExpr(node);
    }

    @Override
    public Type visitTryStmt(TryStmt node) {
        ArrayList<VarTable<LocalVarNode, Void>> assignedList = new ArrayList<VarTable<LocalVarNode, Void>>(node.getCatchStmts().size() + 1);
        this.enterNewFrame();
        assignedList.add(this.assignedVars);
        this.visit(node.getExecStmt());
        this.exitFrame();
        for (CatchBlock cs : node.getCatchStmts()) {
            this.enterNewFrame();
            assignedList.add(this.assignedVars);
            this.visit(cs);
            this.exitFrame();
        }
        this.addIntersectedAssignedVar(assignedList.toArray(new VarTable[assignedList.size()]));
        BlockStmt finallyStmt = node.getFinallyStmt();
        if (finallyStmt != null) {
            this.visit(finallyStmt);
        }
        return null;
    }

    @Override
    public Type visitIfStmt(IfStmt node) {
        VarTable<LocalVarNode, Void> trueAssignedVars = null;
        VarTable<LocalVarNode, Void> falseAssignedVars = null;
        this.enterNewFrame();
        trueAssignedVars = this.assignedVars;
        this.visit(node.getTrueBody());
        this.exitFrame();
        this.enterNewFrame();
        falseAssignedVars = this.assignedVars;
        this.visit(node.getFalseBody());
        this.exitFrame();
        if (trueAssignedVars != null && falseAssignedVars != null) {
            this.addIntersectedAssignedVar(trueAssignedVars, falseAssignedVars);
        }
        return null;
    }

    @Override
    public Type visitLoopStmt(LoopStmt node) {
        this.visit(node.getPreConditionExpr());
        this.enterNewFrame();
        this.visit(node.getLoopBody());
        this.exitFrame();
        this.visit(node.getPostConditionExpr());
        return null;
    }

    @Override
    public Object visitMethodNode(MethodNode node) {
        this.method = node;
        return super.visitMethodNode(node);
    }

    protected void enterNewFrame() {
        this.assignedVars = new VarTable<LocalVarNode, Void>(this.assignedVars);
    }

    protected void exitFrame() {
        this.assignedVars = this.assignedVars.getParent();
    }

    protected void addIntersectedAssignedVar(VarTable<LocalVarNode, Void> ... assignedVarsList) {
        Set[] assigned = new Set[assignedVarsList.length];
        for (int i = 0; i < assigned.length; ++i) {
            assigned[i] = assignedVarsList[i].keySet();
        }
        Set<LocalVarNode> sets = CollectionsUtil.getIntersection(assigned);
        for (LocalVarNode s : sets) {
            this.assignedVars.put(s, null);
        }
    }
}

