/*
 * Decompiled with CFR 0.152.
 */
package kalang.core;

import kalang.core.NullableKind;
import kalang.core.ObjectType;
import kalang.core.Type;
import kalang.util.AstUtil;

public class ArrayType
extends ObjectType {
    private Type componentType;

    public ArrayType(Type componentType, NullableKind nullable) {
        super(AstUtil.createArrayAst("java.lang.Object"), nullable);
        this.componentType = componentType;
    }

    @Override
    public String getName() {
        return this.componentType.getName() + "[]";
    }

    public Type getComponentType() {
        return this.componentType;
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        if (this.equalAndNullAssignChecked(type)) {
            return true;
        }
        if (!(type instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)type;
        if (!this.nullable.isAssignableFrom(other.getNullable())) {
            return false;
        }
        return this.componentType.isAssignableFrom(other.getComponentType());
    }
}

