/*
 * Decompiled with CFR 0.152.
 */
package kalang.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nullable;

public class VarTable<T, V> {
    private HashMap<T, V> vars = new HashMap();
    VarTable<T, V> parent;

    public VarTable() {
    }

    public VarTable(@Nullable VarTable<T, V> parent) {
        this.parent = parent;
    }

    public void put(T key, V var) {
        this.vars.put(key, var);
    }

    public boolean exist(T key) {
        return this.exist(key, true);
    }

    public boolean exist(T key, boolean includeParent) {
        boolean e = this.vars.containsKey(key);
        if (!e && this.parent != null) {
            e = this.parent.exist(key);
        }
        return e;
    }

    public V get(T key) {
        return this.get(key, true);
    }

    public V get(T key, boolean includeParent) {
        V est = this.vars.get(key);
        if (est == null && includeParent && this.parent != null) {
            est = this.parent.get(key, includeParent);
        }
        return est;
    }

    public void remove(T key, boolean includeParent) {
        this.vars.remove(key);
        if (includeParent && this.parent != null) {
            this.parent.remove(key, includeParent);
        }
    }

    public V[] toArray(V[] arr) {
        return this.vars.values().toArray(arr);
    }

    public String toString() {
        return Arrays.toString(this.vars.values().toArray());
    }

    public VarTable<T, V> getParent() {
        return this.parent;
    }

    public void setParent(VarTable<T, V> parent) {
        this.parent = parent;
    }

    public Set<T> keySet() {
        return this.vars.keySet();
    }

    public VarTable<T, V> newStack() {
        return new VarTable<T, V>(this);
    }

    public VarTable<T, V> popStack() {
        return this.getParent();
    }

    public Collection<V> values() {
        return this.vars.values();
    }

    public HashMap<T, V> vars() {
        return this.vars;
    }
}

