/*
 * Decompiled with CFR 0.152.
 */
package kalang.core;

import java.util.Arrays;
import javax.annotation.Nullable;
import kalang.ast.ClassNode;
import kalang.core.NullableKind;
import kalang.core.ObjectType;
import kalang.core.Type;
import kalang.core.Types;
import kalang.util.AstUtil;
import kalang.util.ModifierUtil;
import kalang.util.TypeUtil;

public class WildcardType
extends ObjectType {
    private Type[] upperBounds;
    private Type[] lowerBounds;

    static ClassNode getClassNode(Type[] upperBounds, Type[] lowerBounds) {
        ObjectType[] interfaces;
        ObjectType superType;
        ObjectType ub;
        if (lowerBounds != null && lowerBounds.length > 0) {
            return AstUtil.createClassNodeWithInterfaces("?", Types.getRootType(), new ObjectType[0]);
        }
        if (upperBounds == null || upperBounds.length == 0) {
            upperBounds = new ObjectType[]{Types.getRootType()};
        }
        if (ModifierUtil.isInterface((ub = (ObjectType)upperBounds[0]).getModifier())) {
            superType = Types.getRootType();
            interfaces = new ObjectType[]{ub};
        } else {
            superType = ub;
            interfaces = new ObjectType[]{};
        }
        return AstUtil.createClassNodeWithInterfaces("?", superType, interfaces);
    }

    public WildcardType(@Nullable Type[] upperBounds, @Nullable Type[] lowerBounds) {
        super(WildcardType.getClassNode(upperBounds, lowerBounds), NullableKind.NONNULL);
        this.upperBounds = upperBounds == null ? new Type[]{} : upperBounds;
        this.lowerBounds = lowerBounds == null ? new Type[]{} : lowerBounds;
    }

    @Override
    public String getName() {
        if (this.lowerBounds.length > 0) {
            return "? super " + TypeUtil.toString(this.lowerBounds, "&");
        }
        if (this.upperBounds.length > 0) {
            return "? extends " + TypeUtil.toString(this.upperBounds, "&");
        }
        return "?";
    }

    public Type[] getUpperBounds() {
        return this.upperBounds;
    }

    public void setUpperBounds(Type[] upperBounds) {
        this.upperBounds = upperBounds;
    }

    public Type[] getLowerBounds() {
        return this.lowerBounds;
    }

    public void setLowerBounds(Type[] lowerBounds) {
        this.lowerBounds = lowerBounds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardType other = (WildcardType)obj;
        if (!Arrays.deepEquals(this.upperBounds, other.upperBounds)) {
            return false;
        }
        return Arrays.deepEquals(this.lowerBounds, other.lowerBounds);
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        if (this.lowerBounds.length > 0) {
            return this.lowerBounds[0].isAssignableFrom(type);
        }
        return super.isAssignableFrom(type);
    }

    public boolean containsType(ObjectType type) {
        if (this.lowerBounds.length > 0) {
            return type.isAssignableFrom(this.lowerBounds[0]);
        }
        return this.upperBounds[0].isAssignableFrom(type);
    }
}

