/*
 * Decompiled with CFR 0.152.
 */
package kalang.java;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import kalang.java.FileSystemFileManager;
import kalang.java.MemoryFileManager;
import kalang.java.StringJavaSource;
import kalang.util.ClassNameUtil;
import kalang.util.FilePathUtil;
import org.apache.commons.io.FileUtils;

public class MemoryCompiler
extends ClassLoader {
    protected final List<JavaFileObject> sources = new LinkedList<JavaFileObject>();
    protected final List<URL> classPaths = new LinkedList<URL>();
    protected MemoryFileManager fileManager;
    private DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector();
    protected final List<File> sourcePaths = new LinkedList<File>();
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public void addSourcePath(File path) {
        this.sourcePaths.add(path);
    }

    public void addSourceFromFile(String className, File file) throws IOException {
        this.addSourceFromString(className, FileUtils.readFileToString((File)file, (String)"utf-8"));
    }

    public void addSourceFromFile(File root, File file) throws IOException {
        String className = ClassNameUtil.getClassName(root, file);
        this.addSourceFromFile(className, file);
    }

    public void addSourceFromString(String className, String content) {
        StringJavaSource s = new StringJavaSource(className, content);
        this.sources.add(s);
    }

    protected boolean compile(Collection<JavaFileObject> javaFileObjects) {
        StandardJavaFileManager sfm = this.compiler.getStandardFileManager(null, null, null);
        this.fileManager = this.createFileManager(sfm);
        LinkedList<String> options = new LinkedList<String>();
        String classPath = this.buildClassPathOption();
        if (classPath != null && !classPath.isEmpty()) {
            options.add("-classpath");
            options.add(classPath);
        }
        this.diagnosticCollector = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManager, this.diagnosticCollector, options, null, javaFileObjects);
        return task.call();
    }

    public boolean compile() {
        return this.compile(this.sources);
    }

    protected MemoryFileManager createFileManager(StandardJavaFileManager sfm) {
        FileSystemFileManager fsfm = new FileSystemFileManager(sfm);
        this.sourcePaths.forEach(p -> fsfm.addSourcePath((File)p));
        return new MemoryFileManager(fsfm);
    }

    protected JavaFileObject loadJavaSource(String className) throws IOException {
        String relativePath = ClassNameUtil.getRelativePathOfClass(className, "java");
        for (File p : this.sourcePaths) {
            File sf = new File(p, relativePath);
            if (!FilePathUtil.existFile(sf)) continue;
            return new StringJavaSource(className, FileUtils.readFileToString((File)sf, (String)"utf-8"));
        }
        return null;
    }

    @Nullable
    public MemoryFileManager getFileManager() {
        return this.fileManager;
    }

    public DiagnosticCollector<JavaFileObject> getDiagnosticCollector() {
        return this.diagnosticCollector;
    }

    public void printDiagnostic() {
        if (this.diagnosticCollector != null) {
            for (Diagnostic<JavaFileObject> d : this.diagnosticCollector.getDiagnostics()) {
                JavaFileObject source = d.getSource();
                if (source != null) {
                    System.err.println(source.getName() + ":" + d.getLineNumber());
                }
                System.err.println((Object)((Object)d.getKind()) + ":" + d.getMessage(null));
            }
        }
    }

    public void writeClassesToFile(File outputDir) throws IOException {
        if (this.fileManager != null) {
            for (Map.Entry<String, byte[]> e : this.fileManager.getBytes().entrySet()) {
                String clsName = e.getKey();
                byte[] data = e.getValue();
                String relativePath = ClassNameUtil.getRelativePathOfClass(clsName, "class");
                File of = new File(outputDir, relativePath);
                FileUtils.writeByteArrayToFile((File)of, (byte[])data, (boolean)false);
            }
        }
    }

    protected Class getLoadedClass(String name) {
        byte[] data;
        Map<String, byte[]> bs;
        if (this.fileManager != null && (bs = this.fileManager.getBytes()) != null && (data = bs.get(name)) != null) {
            return this.defineClass(name, data, 0, data.length);
        }
        return null;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz = this.getLoadedClass(name);
        if (clazz == null) {
            JavaFileObject source;
            try {
                source = this.loadJavaSource(name);
            }
            catch (IOException ex) {
                source = null;
            }
            if (source != null) {
                if (!this.compile(Collections.singleton(source))) {
                    this.printDiagnostic();
                }
                clazz = this.getLoadedClass(name);
            }
        }
        if (clazz != null) {
            return clazz;
        }
        return super.findClass(name);
    }

    protected String buildClassPathOption() {
        ArrayList<String> paths = new ArrayList<String>(this.classPaths.size());
        for (URL cp : this.classPaths) {
            try {
                paths.add(new File(cp.toURI()).getAbsolutePath());
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(MemoryCompiler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return String.join((CharSequence)";", paths);
    }

    public void addClassPath(URL path) {
        this.classPaths.add(path);
    }

    public void addSource(JavaFileObject value) {
        this.sources.add(value);
    }
}

