/*
 * Decompiled with CFR 0.152.
 */
package kalang.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class MemoryFileManager
implements JavaFileManager {
    protected JavaFileManager fm;
    protected Map<String, ByteArrayOutputStream> opss = new HashMap<String, ByteArrayOutputStream>();

    public MemoryFileManager(JavaFileManager fm) {
        this.fm = fm;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.fm.getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return this.fm.list(location, packageName, kinds, recurse);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return this.fm.inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.fm.isSameFile(a, b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.fm.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.fm.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.fm.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return new SimpleJavaFileObject(URI.create(location.getName()), JavaFileObject.Kind.CLASS){

            @Override
            public OutputStream openOutputStream() throws IOException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                MemoryFileManager.this.opss.put(className, os);
                return os;
            }
        };
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.fm.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.fm.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
        this.fm.flush();
    }

    @Override
    public void close() throws IOException {
        this.fm.close();
    }

    @Override
    public int isSupportedOption(String option) {
        return this.fm.isSupportedOption(option);
    }

    public Map<String, byte[]> getBytes() {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (Map.Entry<String, ByteArrayOutputStream> o : this.opss.entrySet()) {
            result.put(o.getKey(), o.getValue().toByteArray());
        }
        return result;
    }
}

