/*
 * Decompiled with CFR 0.152.
 */
package kalang.tool;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import kalang.KalangClassLoader;
import kalang.compiler.Diagnosis;
import kalang.compiler.DiagnosisHandler;
import kalang.gui.Editor;
import kalang.tool.AstWriter;
import kalang.tool.ClassWriter;
import kalang.tool.FileSystemOutputManager;
import kalang.tool.JointFileSystemCompiler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Compiler {
    private static final String APP_NAME = "kalang";
    private static final Options OPTIONS = new Options();
    private boolean hasError = false;

    public static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(APP_NAME, OPTIONS);
    }

    public static void main(String[] args) throws ParseException, IOException {
        Compiler cper = new Compiler();
        cper.compile(args);
    }

    public boolean compile(String[] args) throws ParseException, IOException {
        String[] srcs;
        DefaultParser parser = new DefaultParser();
        CommandLine cli = parser.parse(OPTIONS, args);
        if (args.length == 0 || cli.hasOption("h")) {
            Compiler.printUsage();
            return false;
        }
        if (cli.hasOption("gui")) {
            Editor.main(args);
            return true;
        }
        if (cli.hasOption("run")) {
            return this.run(cli);
        }
        JointFileSystemCompiler fsc = new JointFileSystemCompiler();
        final DiagnosisHandler oldHandler = fsc.getDiagnosisHandler();
        fsc.setDiagnosisHandler(new DiagnosisHandler(){

            @Override
            public void handleDiagnosis(Diagnosis diagnosis) {
                oldHandler.handleDiagnosis(diagnosis);
                if (diagnosis.getKind().isError()) {
                    Compiler.this.hasError = true;
                }
            }
        });
        File[] cps = this.parseClassPath(cli);
        if (cps != null) {
            for (File file : cps) {
                fsc.addClassPath(file);
            }
        }
        String outPath = ".";
        if (cli.hasOption("s")) {
            String srcPath = cli.getOptionValue("s");
            fsc.addKalangAndJavaSourceDir(new File(srcPath));
        }
        if (cli.hasOption("o")) {
            outPath = cli.getOptionValue("o");
        }
        String outputFormat = "class";
        if (cli.hasOption("f")) {
            outputFormat = cli.getOptionValue("f");
        }
        FileSystemOutputManager outputManager = new FileSystemOutputManager(new File(outPath), outputFormat);
        switch (outputFormat) {
            case "class": {
                fsc.setJavaOutputManager(outputManager);
                fsc.setCodeGenerator(new ClassWriter(outputManager));
                break;
            }
            case "ast": {
                fsc.setCodeGenerator(new AstWriter(outputManager));
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown format:" + outputFormat);
            }
        }
        File file = new File(".");
        fsc.addJavaSourcePath(file);
        fsc.addSourcePath(file);
        for (String s : srcs = cli.getArgs()) {
            File srcFile = new File(s);
            if (srcFile.isDirectory()) {
                fsc.addKalangAndJavaSourceDir(srcFile);
                continue;
            }
            fsc.addKalangOrJavaSource(file, srcFile);
        }
        this.hasError = false;
        fsc.compile();
        return !this.hasError;
    }

    private File[] parseClassPath(CommandLine cli) {
        if (cli.hasOption("cp")) {
            String[] cps = cli.getOptionValue("cp").split(";");
            File[] file = new File[cps.length];
            for (int i = 0; i < cps.length; ++i) {
                file[i] = new File(cps[i]);
            }
            return file;
        }
        return new File[0];
    }

    public boolean run(CommandLine cli) {
        Method mm;
        Class<?> clazz;
        String clsName = cli.getOptionValue("run");
        KalangClassLoader kcl = new KalangClassLoader();
        kcl.addClassPath(new File("."));
        File[] cps = this.parseClassPath(cli);
        if (cps != null) {
            for (File c : cps) {
                kcl.addClassPath(c);
            }
        }
        try {
            clazz = kcl.loadClass(clsName);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Class not found!");
            return false;
        }
        try {
            mm = clazz.getMethod("main", Class.forName("[Ljava.lang.String;"));
        }
        catch (NoSuchMethodException ex) {
            System.err.println("main method not found!");
            return false;
        }
        catch (ClassNotFoundException | SecurityException ex) {
            Logger.getLogger(Compiler.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        if (!Modifier.isStatic(mm.getModifiers())) {
            System.out.println("main method is not static");
            return false;
        }
        try {
            mm.invoke(null, new Object[]{cli.getArgs()});
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    static {
        OPTIONS.addOption("h", false, "show this help message");
        OPTIONS.addOption("cp", true, "compile classpath");
        OPTIONS.addOption("s", true, "source directory");
        OPTIONS.addOption("o", true, "output directory");
        OPTIONS.addOption("f", true, "output format");
        OPTIONS.addOption("run", true, "run the class with special name");
        OPTIONS.addOption("gui", false, "start a buildin gui");
    }
}

