/*
 * Decompiled with CFR 0.152.
 */
package kalang.tool;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import kalang.ast.ClassNode;
import kalang.compiler.AstLoader;
import kalang.compiler.CodeGenerator;
import kalang.compiler.CompilationUnit;
import kalang.compiler.JavaAstLoader;
import kalang.compiler.KalangCompiler;
import kalang.compiler.SourceLoader;
import kalang.compiler.codegen.Ast2JavaStub;
import kalang.tool.FileSystemSourceLoader;
import kalang.tool.MultiClassLoader;
import kalang.tool.OutputManager;
import kalang.util.ClassNameUtil;
import org.apache.commons.io.FileUtils;

public class FileSystemCompiler
extends KalangCompiler {
    private Map<String, File> sourceFiles = new HashMap<String, File>();
    protected List<URL> classPaths = new LinkedList<URL>();
    @Nullable
    protected MultiClassLoader classLoader;
    protected final List<File> sourcePaths = new LinkedList<File>();
    private CodeGenerator codeGenerator;

    @Deprecated
    public void addClassLoader(ClassLoader classLoader) {
        this.getClassLoader().addClassLoader(classLoader);
    }

    public MultiClassLoader getClassLoader() {
        if (this.classLoader == null) {
            URLClassLoader pathClassLoader = new URLClassLoader(this.classPaths.toArray(new URL[this.classPaths.size()]));
            this.classLoader = new MultiClassLoader(new ClassLoader[]{pathClassLoader});
        }
        return this.classLoader;
    }

    @Override
    public AstLoader getAstLoader() {
        return new JavaAstLoader(super.getAstLoader(), this.getClassLoader());
    }

    @Override
    public CodeGenerator createCodeGenerator(CompilationUnit compilationUnit) {
        return new CodeGenerator(){

            @Override
            public void generate(ClassNode classNode) {
                if (FileSystemCompiler.this.codeGenerator != null) {
                    FileSystemCompiler.this.codeGenerator.generate(classNode);
                }
            }
        };
    }

    public void addSource(File srcDir, File file) throws IOException {
        String className = ClassNameUtil.getClassName(srcDir, file);
        this.sourceFiles.put(className, file);
        super.addSource(className, FileUtils.readFileToString((File)file), file.getName());
    }

    public void addSourceDir(File sourceDir) throws IOException {
        Collection files = FileUtils.listFiles((File)sourceDir, (String[])new String[]{"kl"}, (boolean)true);
        for (File f : files) {
            this.addSource(sourceDir, f);
        }
    }

    public void addClassPath(File path) {
        try {
            this.classPaths.add(path.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(FileSystemCompiler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void generateJavaStub(OutputManager om) {
        super.compile(2);
        HashMap<String, CompilationUnit> sourceAsts = this.getCompilationUnits();
        for (Map.Entry<String, CompilationUnit> a : sourceAsts.entrySet()) {
            Ast2JavaStub a2js = new Ast2JavaStub();
            a2js.generate(a.getValue().getAst());
            String stubCode = a2js.getJavaStubCode();
            String className = a.getValue().getAst().name;
            if (om == null) {
                System.out.println(stubCode);
                continue;
            }
            try {
                OutputStream os = om.createOutputStream(className);
                os.write(stubCode.getBytes());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public SourceLoader getSourceLoader() {
        return new FileSystemSourceLoader(this.sourcePaths.toArray(new File[this.sourcePaths.size()]), new String[]{"kl", "kalang"});
    }

    public void addSourcePath(File path) {
        this.sourcePaths.add(path);
    }

    public CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    public void setCodeGenerator(CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    protected void handleIOException(IOException ex) {
        ex.printStackTrace(System.err);
    }
}

