/*
 * Decompiled with CFR 0.152.
 */
package kalang.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.AmbiguousMethodException;
import kalang.AstNotFoundException;
import kalang.MethodNotFoundException;
import kalang.ast.ClassReference;
import kalang.ast.ExprNode;
import kalang.ast.ObjectInvokeExpr;
import kalang.ast.PrimitiveCastExpr;
import kalang.ast.StaticInvokeExpr;
import kalang.compiler.AstLoader;
import kalang.core.ObjectType;
import kalang.core.PrimitiveType;
import kalang.core.Type;
import kalang.core.Types;
import kalang.util.MathType;

public class BoxUtil {
    static final int CAST_UNSUPPORTED = -1;
    static final int CAST_PRIMITIVE = 1;
    static final int CAST_PRIMITIVE_TO_OBJECT = 2;
    static final int CAST_OBJECT_TO_PRIMITIVE = 3;
    static final int CAST_NOTHING = 4;

    @Nullable
    public static ExprNode assign(@Nonnull ExprNode expr, @Nonnull Type fromType, @Nonnull Type toType) {
        int t = BoxUtil.getCastMethod(fromType, toType);
        switch (t) {
            case 4: {
                return expr;
            }
            case 3: {
                return BoxUtil.castObject2Primitive(expr, fromType, toType);
            }
            case 1: {
                return BoxUtil.castPrimitive(expr, (PrimitiveType)fromType, (PrimitiveType)toType);
            }
            case 2: {
                return BoxUtil.castPrimitive2Object(expr, (PrimitiveType)fromType);
            }
            case -1: {
                return null;
            }
        }
        throw new IllegalStateException("unknown cast type:" + fromType + "=>" + toType);
    }

    public static boolean assignable(Type fromType, Type toType) {
        return BoxUtil.getCastMethod(fromType, toType) > 0;
    }

    private static int getCastMethod(Type fromType, Type toType) {
        if (toType.isAssignableFrom(fromType)) {
            return 4;
        }
        if (fromType instanceof PrimitiveType && toType instanceof PrimitiveType) {
            if (MathType.castable(MathType.getType(fromType.getName()), MathType.getType(toType.getName()))) {
                return 1;
            }
        } else if (fromType instanceof PrimitiveType && toType instanceof ObjectType) {
            if (toType.equals(Types.getRootType())) {
                return 2;
            }
            PrimitiveType toPriType = Types.getPrimitiveType((ObjectType)toType);
            if (toPriType == null) {
                return -1;
            }
            if (toPriType.equals(fromType)) {
                return 2;
            }
        } else if (fromType instanceof ObjectType && toType instanceof PrimitiveType) {
            ObjectType fromClassType = (ObjectType)fromType;
            PrimitiveType fromPrimitive = Types.getPrimitiveType(fromClassType);
            if (fromPrimitive == null) {
                return -1;
            }
            if (fromPrimitive.equals(toType)) {
                return 3;
            }
        }
        return -1;
    }

    private static ExprNode castPrimitive(ExprNode expr, PrimitiveType fromType, PrimitiveType toType) {
        return new PrimitiveCastExpr(fromType, toType, expr);
    }

    private static ExprNode castPrimitive2Object(ExprNode expr, PrimitiveType fromType) {
        StaticInvokeExpr inv;
        ObjectType classType = Types.getClassType(fromType);
        if (classType == null) {
            throw new UnknownError("unknown primitive type:" + fromType);
        }
        try {
            inv = StaticInvokeExpr.create(new ClassReference(classType.getClassNode()), "valueOf", new ExprNode[]{expr});
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return inv;
    }

    private static ExprNode castObject2Primitive(ExprNode expr, Type fromType, Type toType) {
        ObjectInvokeExpr inv;
        try {
            inv = ObjectInvokeExpr.create(expr, toType + "Value", null);
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return inv;
    }

    private static ExprNode castPrimitive2String(ExprNode expr, PrimitiveType fromType) {
        return BoxUtil.castObject2String(BoxUtil.castPrimitive2Object(expr, fromType));
    }

    private static ExprNode castObject2String(ExprNode expr) {
        StaticInvokeExpr inv;
        try {
            inv = StaticInvokeExpr.create(new ClassReference(AstLoader.BASE_AST_LOADER.loadAst("java.util.Objects")), "toString", new ExprNode[]{expr});
        }
        catch (AmbiguousMethodException | AstNotFoundException | MethodNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return inv;
    }

    public static ExprNode castToString(ExprNode expr) {
        Type fromType = expr.getType();
        if (fromType instanceof PrimitiveType) {
            return BoxUtil.castPrimitive2String(expr, (PrimitiveType)fromType);
        }
        if (fromType instanceof ObjectType) {
            return BoxUtil.castObject2String(expr);
        }
        return null;
    }
}

