/*
 * Decompiled with CFR 0.152.
 */
package kalang.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MathType {
    public static final int INT = 1;
    public static final int LONG = 2;
    public static final int FLOAT = 3;
    public static final int DOUBLE = 4;
    public static final int BYTE = 5;
    public static final String INT_STR = "int";
    public static final String LONG_STR = "long";
    public static final String FLOAT_STR = "float";
    public static final String DOUBLE_STR = "double";
    public static final String BYTE_STR = "byte";
    public static final int OP_ADD = 1;
    public static final int OP_SUB = 2;
    public static final int OP_MUL = 3;
    public static final int OP_DIV = 4;
    public static final int OP_MOD = 5;
    public static final String OP_ADD_STR = "+";
    public static final String OP_SUB_STR = "-";
    public static final String OP_MUL_STR = "*";
    public static final String OP_DIV_STR = "/";
    public static final String OP_MOD_STR = "%";

    public static boolean isFloatPoint(String type) {
        return type.equals(FLOAT_STR) || type.equals(DOUBLE_STR);
    }

    public static boolean isFloatPoint(int type) {
        return type == 3 || type == 4;
    }

    public static int getType(String type) {
        if (type.equals(INT_STR)) {
            return 1;
        }
        if (type.equals(LONG_STR)) {
            return 2;
        }
        if (type.equals(FLOAT_STR)) {
            return 3;
        }
        if (type.equals(DOUBLE_STR)) {
            return 4;
        }
        if (type.equals(BYTE_STR)) {
            return 5;
        }
        return 0;
    }

    public static String getTypeStr(int type) {
        if (type == 1) {
            return INT_STR;
        }
        if (type == 2) {
            return LONG_STR;
        }
        if (type == 3) {
            return FLOAT_STR;
        }
        if (type == 4) {
            return DOUBLE_STR;
        }
        if (type == 5) {
            return BYTE_STR;
        }
        return "";
    }

    public static int getOperation(String op) {
        if (op.equals(OP_ADD_STR)) {
            return 1;
        }
        if (op.equals(OP_SUB_STR)) {
            return 2;
        }
        if (op.equals(OP_MUL_STR)) {
            return 3;
        }
        if (op.equals(OP_DIV_STR)) {
            return 4;
        }
        if (op.equals(OP_MOD_STR)) {
            return 5;
        }
        return 0;
    }

    public static String getOperationStr(int op) {
        if (op == 1) {
            return OP_ADD_STR;
        }
        if (op == 2) {
            return OP_SUB_STR;
        }
        if (op == 3) {
            return OP_MUL_STR;
        }
        if (op == 4) {
            return OP_DIV_STR;
        }
        if (op == 5) {
            return OP_MOD_STR;
        }
        return "";
    }

    public static String getType(String type1, String type2, String op) {
        int t1 = MathType.getType(type1);
        int t2 = MathType.getType(type2);
        int o = MathType.getOperation(op);
        int ret = MathType.getType(t1, t2, o);
        return MathType.getTypeStr(ret);
    }

    public static int getType(int type1, int type2, int op) {
        if (MathType.isFloatPoint(type1) || MathType.isFloatPoint(type2) || op == 4) {
            return 4;
        }
        if (type1 == 2 || type2 == 2) {
            return 2;
        }
        return 1;
    }

    public static boolean castable(int fromType, int toType) {
        if (fromType == toType) {
            return true;
        }
        HashMap<Integer, List<Integer>> baseMap = new HashMap<Integer, List<Integer>>();
        baseMap.put(5, Arrays.asList(1, 2, 3, 4));
        baseMap.put(1, Arrays.asList(2, 3, 4));
        baseMap.put(2, Arrays.asList(3, 4));
        baseMap.put(3, Arrays.asList(4));
        baseMap.put(4, new LinkedList());
        if (baseMap.containsKey(fromType)) {
            return ((List)baseMap.get(fromType)).contains(toType);
        }
        return false;
    }
}

