/*
 * Decompiled with CFR 0.152.
 */
package kalang.util;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.ast.MethodNode;
import kalang.ast.ParameterNode;
import kalang.core.ConstructorDescriptor;
import kalang.core.ExecutableDescriptor;
import kalang.core.MethodDescriptor;
import kalang.core.Type;

public class MethodUtil {
    @Nonnull
    public static String[] getParameterNames(@Nonnull ParameterNode[] parameterNodes) {
        String[] names = new String[parameterNodes.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = parameterNodes[i].getName();
        }
        return names;
    }

    public static String getDeclarationKey(String name, ParameterNode[] params) {
        Type[] types = new Type[params.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = params[i].getType();
        }
        return MethodUtil.getDeclarationKey(name, types);
    }

    public static String getDeclarationKey(String name, String ... paramTypes) {
        return String.format("%s(%s)", name, String.join((CharSequence)",", paramTypes));
    }

    public static String getDeclarationKey(String name, Type[] types) {
        ArrayList<String> typeStrList = new ArrayList<String>(types.length);
        for (Type t : types) {
            typeStrList.add(t.getDeclarationKey());
        }
        return MethodUtil.getDeclarationKey(name, typeStrList.toArray(new String[typeStrList.size()]));
    }

    public static String getDeclarationKey(MethodNode node) {
        return MethodUtil.getDeclarationKey(node.getName(), MethodUtil.getParameterTypes(node));
    }

    public static String getParametersDescription(Type[] types) {
        ArrayList<String> tys = new ArrayList<String>(types.length);
        for (Type t : types) {
            tys.add(t.getName());
        }
        return String.join((CharSequence)",", tys);
    }

    public static String toString(String className, String name, Type[] types) {
        return String.format("%s.%s(%s)", className, name, MethodUtil.getParametersDescription(types));
    }

    public static String toString(MethodNode node) {
        String className = "";
        if (node.getClassNode() != null) {
            className = node.getClassNode().name + "#";
        }
        return String.format("%s.%s(%s)", className, node.getName(), MethodUtil.getParametersDescription(MethodUtil.getParameterTypes(node)));
    }

    public static String toString(MethodNode node, String className) {
        return String.format("%s.%s(%s)", className, node.getName(), MethodUtil.getParametersDescription(MethodUtil.getParameterTypes(node)));
    }

    public static String toString(MethodNode[] methods, String delimiter) {
        ArrayList<String> list = new ArrayList<String>(methods.length);
        for (MethodNode m : methods) {
            list.add(MethodUtil.toString(m));
        }
        return String.join((CharSequence)delimiter, list);
    }

    public static Type[] getParameterTypes(MethodNode mn) {
        ParameterNode[] parameters = mn.getParameters();
        Type[] types = new Type[parameters.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = parameters[i].getType();
        }
        return types;
    }

    @Nullable
    private static ExecutableDescriptor getExecutableDescriptor(ExecutableDescriptor[] methods, String name, @Nullable Type[] parameterTypes) {
        if (parameterTypes == null) {
            parameterTypes = new Type[]{};
        }
        for (ExecutableDescriptor m : methods) {
            Object[] mParams;
            if (!m.getName().equals(name) || !Arrays.equals(mParams = m.getParameterTypes(), parameterTypes)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public static ConstructorDescriptor getConstructorDescriptor(ConstructorDescriptor[] constructors, @Nullable Type[] paramTypes) {
        return (ConstructorDescriptor)MethodUtil.getExecutableDescriptor(constructors, "<init>", paramTypes);
    }

    @Nullable
    public static MethodDescriptor getMethodDescriptor(MethodDescriptor[] methods, String name, @Nullable Type[] paramTypes) {
        return (MethodDescriptor)MethodUtil.getExecutableDescriptor(methods, name, paramTypes);
    }
}

