/*
 * Decompiled with CFR 0.152.
 */
package kalang.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.LinkedList;

public class FileIO {
    public static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");

    public static String readText(File file) throws IOException {
        return FileIO.readText(file, DEFAULT_CHARSET);
    }

    public static String readText(File file, String charset) throws IOException {
        return FileIO.readText(file, Charset.forName(charset));
    }

    public static String readText(File file, Charset charset) throws IOException {
        StringBuilder buffer;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);){
            int rlen;
            buffer = new StringBuilder();
            char[] buf = new char[4096];
            while ((rlen = reader.read(buf)) > 0) {
                buffer.append(buf, 0, rlen);
            }
        }
        return buffer.toString();
    }

    public static String readText(String file, Charset charset) throws IOException {
        return FileIO.readText(new File(file), charset);
    }

    public static String readText(String file, String charset) throws IOException {
        return FileIO.readText(new File(file), charset);
    }

    public static String readText(String file) throws IOException {
        return FileIO.readText(new File(file));
    }

    public static String[] readLines(File file, Charset charset) throws IOException {
        String line;
        LinkedList<String> lines = new LinkedList<String>();
        String text = FileIO.readText(file, charset);
        BufferedReader bfReader = new BufferedReader(new StringReader(text));
        while ((line = bfReader.readLine()) != null) {
            lines.add(line);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static String[] readLines(File file, String charset) throws IOException {
        return FileIO.readLines(file, Charset.forName(charset));
    }

    public static String[] readLines(File file) throws IOException {
        return FileIO.readLines(file, DEFAULT_CHARSET);
    }

    public static String[] readLines(String file, Charset charset) throws IOException {
        return FileIO.readLines(new File(file), charset);
    }

    public static String[] readLines(String file, String charset) throws IOException {
        return FileIO.readLines(new File(file), Charset.forName(charset));
    }

    public static String[] readLines(String file) throws IOException {
        return FileIO.readLines(new File(file), DEFAULT_CHARSET);
    }

    public static void writeText(OutputStream out, String text, Charset charset) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(out, charset);){
            writer.write(text);
        }
    }

    public static void writeText(OutputStream out, String text, String charset) throws IOException {
        FileIO.writeText(out, text, Charset.forName(charset));
    }

    public static void writeText(OutputStream out, String text) throws IOException {
        FileIO.writeText(out, text, DEFAULT_CHARSET);
    }

    public static void writeText(File out, String text, Charset charset) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(out);){
            FileIO.writeText((OutputStream)fos, text, charset);
        }
    }

    public static void writeText(File out, String text, String charset) throws IOException {
        FileIO.writeText(out, text, Charset.forName(charset));
    }

    public static void writeText(File out, String text) throws IOException {
        FileIO.writeText(out, text, DEFAULT_CHARSET);
    }
}

