/*
 * Decompiled with CFR 0.152.
 */
package kamons.text.table;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kamons.text.table.TextTableConfig;

public class TextTableWriter {
    private OutputStream os;
    private TextTableConfig config;
    private Charset charset;

    public TextTableWriter(OutputStream os, TextTableConfig config) {
        this(os, config, Charset.defaultCharset());
    }

    public TextTableWriter(OutputStream os, TextTableConfig config, String charset) {
        this(os, config, Charset.forName(charset));
    }

    public TextTableWriter(OutputStream os, TextTableConfig config, Charset charset) {
        this.os = os;
        this.config = config;
        this.charset = charset;
    }

    private void printLeftRowBorder() throws IOException {
        String text = this.config.hasBorder() ? " | " : "   ";
        this.os.write(text.getBytes(this.charset));
    }

    private void printMiddleRowBorder() throws IOException {
        this.printLeftRowBorder();
    }

    private void printRightRowBorder() throws IOException {
        this.printLeftRowBorder();
    }

    public void printRow(String ... columns) throws IOException {
        int[] widths = this.config.getColumnWidths();
        StringBuilder[] sbs = new StringBuilder[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            sbs[i] = new StringBuilder(columns.length > i ? columns[i] : "");
        }
        boolean empty = false;
        while (!empty) {
            empty = true;
            this.printLeftRowBorder();
            for (int i = 0; i < sbs.length; ++i) {
                if (i > 0) {
                    this.printMiddleRowBorder();
                }
                int textWidth = sbs[i].toString().getBytes("utf-8").length;
                int columnWidth = widths[i];
                int deleteLen = Math.min(textWidth, columnWidth);
                int charCount = sbs[i].codePointCount(0, deleteLen);
                byte[] suffix = new byte[columnWidth > textWidth ? columnWidth - textWidth : 0];
                for (int j = 0; j < suffix.length; ++j) {
                    suffix[j] = 32;
                }
                String text = sbs[i].substring(0, charCount);
                sbs[i].delete(0, charCount);
                if (sbs[i].length() > 0) {
                    empty = false;
                }
                this.os.write(text.getBytes(this.charset));
                if (suffix.length <= 0) continue;
                this.os.write(suffix);
            }
            this.printRightRowBorder();
            this.os.write(10);
        }
    }
}

