/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.initialization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.initialization.InitializationAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class InitializationStore<V extends CFAbstractValue<V>, S extends InitializationStore<V, S>>
extends CFAbstractStore<V, S> {
    protected final Set<VariableElement> initializedFields;

    public InitializationStore(CFAbstractAnalysis<V, S, ?> analysis, boolean sequentialSemantics) {
        super(analysis, sequentialSemantics);
        this.initializedFields = new HashSet<VariableElement>();
    }

    @Override
    public void insertValue(FlowExpressions.Receiver r, V value) {
        if (value == null) {
            return;
        }
        super.insertValue(r, value);
        InitializationAnnotatedTypeFactory atypeFactory = (InitializationAnnotatedTypeFactory)this.analysis.getTypeFactory();
        QualifierHierarchy qualifierHierarchy = atypeFactory.getQualifierHierarchy();
        AnnotationMirror invariantAnno = atypeFactory.getFieldInvariantAnnotation();
        for (AnnotationMirror a : ((CFAbstractValue)value).getType().getAnnotations()) {
            FlowExpressions.FieldAccess fa;
            if (!qualifierHierarchy.isSubtype(a, invariantAnno) || !(r instanceof FlowExpressions.FieldAccess) || !((fa = (FlowExpressions.FieldAccess)r).getReceiver() instanceof FlowExpressions.ThisReference) && !(fa.getReceiver() instanceof FlowExpressions.ClassName)) continue;
            this.addInitializedField(fa.getField());
        }
    }

    @Override
    public void updateForMethodCall(MethodInvocationNode n, AnnotatedTypeFactory atypeFactory, V val) {
        AnnotationMirror fieldInvariantAnnotation = ((InitializationAnnotatedTypeFactory)atypeFactory).getFieldInvariantAnnotation();
        ArrayList<FlowExpressions.FieldAccess> invariantFields = new ArrayList<FlowExpressions.FieldAccess>();
        for (Map.Entry e : this.fieldValues.entrySet()) {
            FlowExpressions.FieldAccess fieldAccess = (FlowExpressions.FieldAccess)e.getKey();
            Set<AnnotationMirror> declaredAnnos = atypeFactory.getAnnotatedType(fieldAccess.getField()).getAnnotations();
            if (!AnnotationUtils.containsSame(declaredAnnos, fieldInvariantAnnotation)) continue;
            invariantFields.add(fieldAccess);
        }
        super.updateForMethodCall(n, atypeFactory, val);
        for (FlowExpressions.FieldAccess invariantField : invariantFields) {
            this.insertValue((FlowExpressions.Receiver)invariantField, (V)fieldInvariantAnnotation);
        }
    }

    public InitializationStore(S other) {
        super(other);
        this.initializedFields = new HashSet<VariableElement>(((InitializationStore)other).initializedFields);
    }

    public void addInitializedField(FlowExpressions.FieldAccess field) {
        boolean fieldOnThisReference = field.getReceiver() instanceof FlowExpressions.ThisReference;
        boolean staticField = field.isStatic();
        if (fieldOnThisReference || staticField) {
            this.initializedFields.add(field.getField());
        }
    }

    public void addInitializedField(VariableElement f) {
        this.initializedFields.add(f);
    }

    public boolean isFieldInitialized(Element f) {
        return this.initializedFields.contains(f);
    }

    @Override
    protected boolean supersetOf(CFAbstractStore<V, S> o) {
        if (!(o instanceof InitializationStore)) {
            return false;
        }
        InitializationStore other = (InitializationStore)o;
        for (Element element : other.initializedFields) {
            if (this.initializedFields.contains(element)) continue;
            return false;
        }
        return super.supersetOf(other);
    }

    @Override
    public S leastUpperBound(S other) {
        InitializationStore result = (InitializationStore)super.leastUpperBound(other);
        result.initializedFields.addAll(((InitializationStore)other).initializedFields);
        result.initializedFields.retainAll(this.initializedFields);
        return (S)result;
    }

    @Override
    protected void internalDotOutput(StringBuilder result) {
        super.internalDotOutput(result);
        result.append("  initialized fields = " + this.initializedFields + "\\n");
    }

    public Map<FlowExpressions.FieldAccess, V> getFieldValues() {
        return this.fieldValues;
    }

    public CFAbstractAnalysis<V, S, ?> getAnalysis() {
        return this.analysis;
    }
}

