/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.Wildcard;
import org.checkerframework.qualframework.poly.format.QualParamsFormatter;
import org.checkerframework.qualframework.poly.format.SurfaceSyntaxFormatterConfiguration;

public class SurfaceSyntaxQualParamsFormatter<Q>
implements QualParamsFormatter<Q> {
    private final SurfaceSyntaxFormatterConfiguration<Q> config;

    public SurfaceSyntaxQualParamsFormatter(SurfaceSyntaxFormatterConfiguration<Q> config) {
        this.config = config;
    }

    @Override
    public String format(QualParams<Q> params) {
        return this.format(params, true, true);
    }

    @Override
    public String format(QualParams<Q> params, boolean printInvisible) {
        return this.format(params, true, printInvisible);
    }

    @Override
    public String format(QualParams<Q> params, boolean printPrimary, boolean printInvisible) {
        StringBuffer sb = new StringBuffer();
        if (params == this.config.getQualTop()) {
            AnnotationParts anno = this.config.getTargetTypeSystemAnnotation(this.config.getTop());
            if (this.config.shouldPrintAnnotation(anno, printInvisible)) {
                return anno.toString();
            }
            return null;
        }
        if (params == this.config.getQualBottom()) {
            AnnotationParts anno = this.config.getTargetTypeSystemAnnotation(this.config.getBottom());
            if (this.config.shouldPrintAnnotation(anno, printInvisible)) {
                return anno.toString();
            }
            return null;
        }
        boolean printedPrimary = false;
        if (printPrimary && params.getPrimary() != null) {
            List<AnnotationParts> annos = this.createAnnotations(params.getPrimary(), printInvisible);
            for (AnnotationParts anno : annos) {
                if (printedPrimary) {
                    sb.append(" ");
                } else {
                    printedPrimary = true;
                }
                sb.append(anno.toString());
            }
        }
        boolean addSpace = printedPrimary;
        for (Map.Entry<String, Wildcard<Q>> entry : params.entrySet()) {
            List<AnnotationParts> annos = this.createAnnotations(entry.getValue(), entry.getKey(), printInvisible);
            for (AnnotationParts anno : annos) {
                if (addSpace) {
                    sb.append(" ");
                } else {
                    addSpace = true;
                }
                sb.append(anno.toString());
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    @Override
    public String format(PolyQual<Q> polyQual, boolean printInvisible) {
        StringBuffer sb = new StringBuffer();
        List<AnnotationParts> annos = this.createAnnotations(polyQual, printInvisible);
        boolean first = false;
        for (AnnotationParts anno : annos) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(anno);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private List<AnnotationParts> createAnnotations(Wildcard<Q> wildcard, String paramName, boolean printInvisible) {
        if (wildcard.isEmpty()) {
            ErrorReporter.errorAbort("Unable to convert wildcard: " + wildcard);
        }
        ArrayList<AnnotationParts> results = new ArrayList<AnnotationParts>();
        List<AnnotationParts> upper = this.createAnnotations(wildcard.getUpperBound(), printInvisible);
        HashMap<AnnotationParts, org.checkerframework.qualframework.poly.qual.Wildcard> bounds = new HashMap<AnnotationParts, org.checkerframework.qualframework.poly.qual.Wildcard>();
        for (AnnotationParts annotationParts : upper) {
            annotationParts.putQuoted("param", paramName);
            bounds.put(annotationParts, org.checkerframework.qualframework.poly.qual.Wildcard.EXTENDS);
        }
        results.addAll(upper);
        List<AnnotationParts> lower = this.createAnnotations(wildcard.getLowerBound(), printInvisible);
        for (AnnotationParts part : lower) {
            part.putQuoted("param", paramName);
            if (upper.contains(part)) {
                bounds.remove(part);
                continue;
            }
            bounds.put(part, org.checkerframework.qualframework.poly.qual.Wildcard.SUPER);
            results.add(part);
        }
        ArrayList<AnnotationParts> arrayList = new ArrayList<AnnotationParts>();
        for (AnnotationParts anno : results) {
            if (bounds.containsKey(anno)) {
                anno.put("wildcard", this.createWildcardString((org.checkerframework.qualframework.poly.qual.Wildcard)((Object)bounds.get(anno))));
            }
            if (!this.config.shouldPrintAnnotation(anno, printInvisible)) continue;
            arrayList.add(anno);
        }
        return arrayList;
    }

    private List<AnnotationParts> createAnnotations(PolyQual<Q> polyQual, boolean printInvisible) {
        Object anno;
        ArrayList<AnnotationParts> result = new ArrayList<AnnotationParts>();
        if (polyQual == null) {
            return result;
        }
        if (polyQual instanceof PolyQual.Combined) {
            PolyQual.Combined combined = (PolyQual.Combined)polyQual;
            for (PolyQual.QualVar var : combined.getVars()) {
                anno = this.createAnnotations(var, printInvisible);
                result.addAll((Collection<AnnotationParts>)anno);
            }
            AnnotationParts anno2 = this.config.getTargetTypeSystemAnnotation(combined.getGround());
            if (anno2 != null) {
                result.add(anno2);
            }
        } else if (polyQual instanceof PolyQual.GroundQual) {
            AnnotationParts anno3 = this.config.getTargetTypeSystemAnnotation(((PolyQual.GroundQual)polyQual).getQualifier());
            if (anno3 != null) {
                result.add(anno3);
            }
        } else if (polyQual instanceof PolyQual.QualVar) {
            PolyQual.QualVar qualVar = (PolyQual.QualVar)polyQual;
            String lower = this.formatQual(qualVar.getLowerBound(), printInvisible);
            String upper = this.formatQual(qualVar.getUpperBound(), printInvisible);
            anno = new AnnotationParts("Var");
            ((AnnotationParts)anno).putQuoted("arg", qualVar.getName());
            if (lower != null || upper != null) {
                lower = lower == null ? "" : lower;
                upper = upper == null ? "" : upper;
                ((AnnotationParts)anno).putQuoted("range", " \u2208 [" + lower + ".." + upper + "]");
            }
            result.add((AnnotationParts)anno);
        } else {
            ErrorReporter.errorAbort("Unknown PolyQual Subclass: " + polyQual.getClass());
            return result;
        }
        ArrayList<AnnotationParts> filteredResults = new ArrayList<AnnotationParts>();
        for (AnnotationParts anno4 : result) {
            if (!this.config.shouldPrintAnnotation(anno4, printInvisible)) continue;
            filteredResults.add(anno4);
        }
        return filteredResults;
    }

    private String formatQual(Q qual, boolean printInvisible) {
        AnnotationParts anno = this.config.getTargetTypeSystemAnnotation(qual);
        if (anno != null && this.config.shouldPrintAnnotation(anno, printInvisible)) {
            return anno.toString();
        }
        return null;
    }

    private String createWildcardString(org.checkerframework.qualframework.poly.qual.Wildcard wildcardType) {
        return wildcardType.getDeclaringClass().getSimpleName() + "." + (Object)((Object)wildcardType);
    }

    public static class AnnotationParts {
        private String name;
        private Map<String, Object> fields = new HashMap<String, Object>();

        public AnnotationParts(String name) {
            this.name = name;
        }

        public void putQuoted(String key, String value) {
            this.fields.put(key, "\"" + value + "\"");
        }

        public void put(String key, String value) {
            this.fields.put(key, value);
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationParts that = (AnnotationParts)o;
            if (!this.fields.equals(that.fields)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.fields.hashCode();
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("@");
            sb.append(this.name);
            if (this.fields.size() == 1 && this.fields.get("value") != null) {
                sb.append("(");
                sb.append(this.fields.get("value"));
                sb.append(")");
            } else if (this.fields.size() > 0) {
                sb.append("(");
                boolean first = true;
                for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(entry.getKey());
                    sb.append("=");
                    sb.append(entry.getValue());
                }
                sb.append(")");
            }
            return sb.toString();
        }
    }
}

