/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.lex;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import site.kason.tempera.lex.CharStream;
import site.kason.tempera.lex.LexException;
import site.kason.tempera.lex.OffsetRange;
import site.kason.tempera.lex.TokenFactory;
import site.kason.tempera.lex.TokenInfo;
import site.kason.tempera.lex.nfa.MatchedResult;
import site.kason.tempera.lex.nfa.NFA;
import site.kason.tempera.lex.nfa.State;

public class Lexer<TOKEN, TOKEN_INFO extends TokenInfo> {
    private NFA nfa;
    private Map<State, TOKEN_INFO> stateToTokenInfo = new HashMap<State, TOKEN_INFO>();
    private CharStream charBuffer;
    private TokenFactory<TOKEN, TOKEN_INFO> tokenFactory;

    public Lexer(CharStream charBuffer, TOKEN_INFO[] tokenInfos, TokenFactory<TOKEN, TOKEN_INFO> tokenFactory) {
        this.charBuffer = charBuffer;
        for (int i = 0; i < tokenInfos.length; ++i) {
            this.addTokenRule(tokenInfos[i]);
        }
        this.tokenFactory = tokenFactory;
    }

    private void addTokenRule(TOKEN_INFO info) {
        NFA theNfa = info.getNFA();
        if (theNfa != null) {
            for (State s : info.getNFA().getAcceptedStates()) {
                this.stateToTokenInfo.put(s, info);
            }
            if (this.nfa == null) {
                this.nfa = info.getNFA();
            } else {
                this.nfa.or(info.getNFA());
            }
        }
    }

    private TOKEN_INFO selectBestToken(State[] states) {
        TokenInfo bestTokenInfo = null;
        for (State s : states) {
            TokenInfo tk = (TokenInfo)this.stateToTokenInfo.get(s);
            if (bestTokenInfo != null && tk.getPriority() >= bestTokenInfo.getPriority()) continue;
            bestTokenInfo = tk;
        }
        return (TOKEN_INFO)bestTokenInfo;
    }

    private boolean hasNextToken() {
        return this.charBuffer.lookAhead(1) != -1;
    }

    public TOKEN nextToken() throws LexException {
        if (!this.hasNextToken()) {
            return this.tokenFactory.createEOIToken(new OffsetRange(this.charBuffer.getCurrentOffset(), this.charBuffer.getCurrentOffset() + 1, this.charBuffer.getCurrentLine(), this.charBuffer.getCurrentColumn(), this.charBuffer.getCurrentLine(), this.charBuffer.getCurrentColumn() + 1));
        }
        int startOffset = this.charBuffer.getCurrentOffset();
        int startLine = this.charBuffer.getCurrentLine();
        int startColumn = this.charBuffer.getCurrentColumn();
        MatchedResult match = this.nfa.match(this.charBuffer);
        if (match == null) {
            throw new LexException(new OffsetRange(startOffset, startOffset, startLine, startColumn, startLine, startColumn), "unexcepted input");
        }
        State[] matchedStates = match.getMatchedState();
        TOKEN_INFO tokenType = this.selectBestToken(matchedStates);
        int stopOffset = this.charBuffer.getCurrentOffset() - 1;
        int stopLine = this.charBuffer.getCurrentLine();
        int stopColumn = this.charBuffer.getCurrentColumn() - 1;
        TOKEN tk = this.tokenFactory.createToken(tokenType, new OffsetRange(startOffset, stopOffset, startLine, startColumn, stopLine, stopColumn), match.getMatchedChars());
        return tk;
    }

    public List<TOKEN> nextTokens() throws LexException {
        LinkedList<TOKEN> resultTokens = new LinkedList<TOKEN>();
        while (this.hasNextToken()) {
            TOKEN token = this.nextToken();
            resultTokens.add(token);
        }
        return resultTokens;
    }

    public int getRecognizedLength() {
        return this.charBuffer.getCurrentOffset();
    }

    public void skip(int count) {
        this.charBuffer.consume(count);
    }

    public int getCaret() {
        return this.charBuffer.getCurrentOffset();
    }
}

