/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.lexer;

import java.util.LinkedList;
import java.util.List;
import kamons.array.ArrayUtil;
import kamons.string.LiteralParser;
import site.kason.tempera.lex.CharStream;
import site.kason.tempera.lex.LexException;
import site.kason.tempera.lex.Lexer;
import site.kason.tempera.lex.OffsetRange;
import site.kason.tempera.lex.StringCharStream;
import site.kason.tempera.lex.TokenFactory;
import site.kason.tempera.lex.TokenInfo;
import site.kason.tempera.lex.nfa.NFA;
import site.kason.tempera.lex.nfa.NFAUtil;
import site.kason.tempera.lexer.TexToken;
import site.kason.tempera.lexer.TexTokenInfo;
import site.kason.tempera.lexer.TexTokenType;

public class TexLexer {
    private Lexer<TexToken, TexTokenInfo> tagLexer;
    public static final LiteralParser LITERAL_PARSER = LiteralParser.createDefault();
    private final String input;
    private boolean inTagMode = false;
    private String startTag = "{{";
    private String endTag = "}}";
    private final CharStream charStream;

    private static TexTokenInfo tk(TexTokenType token, int priority, NFA nfa) {
        return new TexTokenInfo(token, nfa, priority);
    }

    private static TexTokenInfo tk(TexTokenType token, int priority, String rule) {
        return TexLexer.tk(token, priority, NFAUtil.of(rule));
    }

    private static TexTokenInfo[] getTokenInfos(String startTag, String endTag) {
        int p = 0;
        return new TexTokenInfo[]{TexLexer.tk(TexTokenType.SPACE, p++, " "), TexLexer.tk(TexTokenType.DOT, p++, "."), TexLexer.tk(TexTokenType.IN, p++, "in"), TexLexer.tk(TexTokenType.START_TAG, p++, startTag), TexLexer.tk(TexTokenType.END_TAG, p++, endTag), TexLexer.tk(TexTokenType.COLON, p++, ":"), TexLexer.tk(TexTokenType.VAR, p++, "var"), TexLexer.tk(TexTokenType.VAL, p++, "val"), TexLexer.tk(TexTokenType.IF, p++, "if"), TexLexer.tk(TexTokenType.ELSE, p++, "else"), TexLexer.tk(TexTokenType.END_IF, p++, "/if"), TexLexer.tk(TexTokenType.FOR, p++, "for"), TexLexer.tk(TexTokenType.END_FOR, p++, "/for"), TexLexer.tk(TexTokenType.PLACEHOLDER, p++, "placeholder"), TexLexer.tk(TexTokenType.END_PLACEHOLDER, p++, "/placeholder"), TexLexer.tk(TexTokenType.REPLACE, p++, "replace"), TexLexer.tk(TexTokenType.END_REPLACE, p++, "/replace"), TexLexer.tk(TexTokenType.LAYOUT, p++, "layout"), TexLexer.tk(TexTokenType.END_LAYOUT, p++, "/layout"), TexLexer.tk(TexTokenType.LPAREN, p++, "("), TexLexer.tk(TexTokenType.RPAREN, p++, ")"), TexLexer.tk(TexTokenType.LBRACK, p++, "["), TexLexer.tk(TexTokenType.RBRACK, p++, "]"), TexLexer.tk(TexTokenType.LBRACE, p++, "{"), TexLexer.tk(TexTokenType.RBRACE, p++, "}"), TexLexer.tk(TexTokenType.LT, p++, "<"), TexLexer.tk(TexTokenType.GT, p++, ">"), TexLexer.tk(TexTokenType.AT, p++, "@"), TexLexer.tk(TexTokenType.LOGIC_NOT, p++, "!"), TexLexer.tk(TexTokenType.COMMA, p++, ","), TexLexer.tk(TexTokenType.ADD, p++, "+"), TexLexer.tk(TexTokenType.SUB, p++, "-"), TexLexer.tk(TexTokenType.MUL, p++, "*"), TexLexer.tk(TexTokenType.DIV, p++, "/"), TexLexer.tk(TexTokenType.MOD, p++, "%"), TexLexer.tk(TexTokenType.LOGIC_AND, p++, "&&"), TexLexer.tk(TexTokenType.LOGIC_OR, p++, "||"), TexLexer.tk(TexTokenType.EQ, p++, "=="), TexLexer.tk(TexTokenType.LT, p++, "<"), TexLexer.tk(TexTokenType.LE, p++, "<="), TexLexer.tk(TexTokenType.GT, p++, ">"), TexLexer.tk(TexTokenType.GE, p++, ">="), TexLexer.tk(TexTokenType.NE, p++, "!="), TexLexer.tk(TexTokenType.NUMBER, p++, TexLexer.createNumberNFA()), TexLexer.tk(TexTokenType.IDENTITY, p++, NFAUtil.range(97, 122).or(NFAUtil.range(65, 90)).concat(NFAUtil.range(97, 122).or(NFAUtil.range(65, 90)).closure())), TexLexer.tk(TexTokenType.STRING, p++, NFAUtil.of("\"").concat(NFAUtil.exclude(34, 92).or(NFAUtil.of("\\").concat(NFAUtil.oneOf(ArrayUtil.toInts((char[])LITERAL_PARSER.getSupportedEscapeChars())))).closure()).concat(NFAUtil.of("\"")))};
    }

    public TexLexer(String input) {
        this.charStream = new StringCharStream(input);
        this.tagLexer = new Lexer(this.charStream, (TokenInfo[])TexLexer.getTokenInfos(this.startTag, this.endTag), (TokenFactory)new TokenFactory<TexToken, TexTokenInfo>(){

            @Override
            public TexToken createToken(TexTokenInfo tokenType, OffsetRange offset, int[] chars) {
                return new TexToken(tokenType.getType(), offset, new String(chars, 0, chars.length));
            }

            @Override
            public TexToken createEOIToken(OffsetRange offset) {
                return new TexToken(TexTokenType.EOF, offset, "");
            }
        });
        this.input = input;
    }

    public TexToken nextToken() throws LexException {
        int startOffset = this.charStream.getCurrentOffset();
        if (startOffset >= this.input.length()) {
            return this.tagLexer.nextToken();
        }
        int startLine = this.charStream.getCurrentLine();
        int startColumn = this.charStream.getCurrentColumn();
        if (!this.inTagMode) {
            int tagOffset = this.input.indexOf(this.startTag, startOffset);
            if (tagOffset == startOffset) {
                this.inTagMode = true;
                this.tagLexer.skip(this.startTag.length());
                int stopOffset = this.charStream.getCurrentOffset() - 1;
                int stopLine = this.charStream.getCurrentLine();
                int stopColumn = this.charStream.getCurrentColumn() - 1;
                return new TexToken(TexTokenType.START_TAG, new OffsetRange(startOffset, stopOffset, startLine, startColumn, stopLine, stopColumn), this.input.substring(startOffset, stopOffset));
            }
            if (tagOffset > startOffset) {
                int textLen = tagOffset - startOffset;
                this.charStream.skip(textLen);
                return new TexToken(TexTokenType.TEXT, new OffsetRange(startOffset, this.charStream.getCurrentOffset() - 1, startLine, startColumn, this.charStream.getCurrentLine(), this.charStream.getCurrentColumn() - 1), this.input.substring(startOffset, startOffset + textLen));
            }
            int textLen = this.input.length() - startOffset;
            this.tagLexer.skip(textLen);
            return new TexToken(TexTokenType.TEXT, new OffsetRange(startOffset, this.charStream.getCurrentOffset() - 1, startLine, startColumn, this.charStream.getCurrentLine(), this.charStream.getCurrentColumn() - 1), this.input.substring(startOffset, startOffset + textLen));
        }
        TexToken tk = this.tagLexer.nextToken();
        if (TexTokenType.END_TAG.equals((Object)tk.getTokenType())) {
            this.inTagMode = false;
        }
        return tk;
    }

    public List<TexToken> nextTokens() throws LexException {
        TexToken tk;
        LinkedList<TexToken> result = new LinkedList<TexToken>();
        while ((tk = this.nextToken()).getTokenType() != TexTokenType.EOF) {
            result.add(tk);
        }
        return result;
    }

    private static NFA createNumberNFA() {
        NFA d1 = NFAUtil.range(48, 57);
        NFA d2 = NFAUtil.range(48, 57);
        NFA d3 = NFAUtil.range(48, 57);
        NFA d4 = NFAUtil.range(48, 57);
        NFA d5 = NFAUtil.range(48, 57);
        NFA d6 = NFAUtil.range(48, 57);
        NFA dot = NFAUtil.of(".");
        NFA intNFA = d1.concat(d2.closure());
        NFA floatNFA = d3.concat(d4.closure()).concat(dot).concat(d5.concat(d6.closure()));
        return intNFA.or(floatNFA);
    }
}

