/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class TemplateClassLoader
extends ClassLoader {
    private final File cacheDir;

    public TemplateClassLoader(@Nullable ClassLoader parent, @Nullable File cacheDir) {
        super(parent);
        this.cacheDir = cacheDir;
    }

    public TemplateClassLoader() {
        this(TemplateClassLoader.class.getClassLoader(), null);
    }

    public Class generateTemplateClass(String name, byte[] bytes) {
        if (this.cacheDir != null) {
            String fileName = name.replace(".", "/") + ".class";
            try (FileOutputStream os = new FileOutputStream(new File(this.cacheDir.getAbsolutePath(), fileName));){
                os.write(bytes);
            }
            catch (IOException ex) {
                Logger.getLogger(TemplateClassLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

