/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.source;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import site.kason.tempera.engine.TemplateSource;

public class FileTemplateSource
implements TemplateSource {
    File file;
    String name;
    private final String encoding;

    public FileTemplateSource(String name, File file, String encoding) {
        this.file = file;
        this.encoding = encoding;
        this.name = name;
    }

    @Override
    public String getContent() throws IOException {
        return FileUtils.readFileToString((File)this.file, (String)this.encoding);
    }

    @Override
    public String getCacheKey() {
        try {
            return this.file.getCanonicalPath() + this.file.lastModified();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public String getPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ex) {
            return this.file.getAbsolutePath();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

