/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.var;

import java.util.HashMap;
import java.util.Map;
import kalang.AstNotFoundException;
import kalang.core.Type;
import site.kason.tempera.lex.LexException;
import site.kason.tempera.type.TypeParser;
import site.kason.tempera.var.VarLexer;
import site.kason.tempera.var.VarToken;
import site.kason.tempera.var.VarTokenType;

public class VarParser {
    VarToken token;
    VarLexer lexer;
    private Map<String, Type> varNameToTypes = new HashMap<String, Type>();

    private RuntimeException unexpectedToken(VarTokenType type) {
        return new RuntimeException("unexcepted token:" + type);
    }

    private VarToken expect(VarTokenType type) throws LexException {
        if (!this.token.getType().equals(type)) {
            throw this.unexpectedToken(type);
        }
        VarToken tk = this.token;
        this.nextToken();
        return tk;
    }

    private void nextToken() throws LexException {
        this.token = (VarToken)this.lexer.nextToken();
    }

    private boolean isToken(VarTokenType type) {
        if (this.token == null) {
            return false;
        }
        return this.token.getType().equals(type);
    }

    private void consume() throws LexException {
        this.nextToken();
    }

    private void varDecl() throws LexException, AstNotFoundException {
        String varType;
        this.expect(VarTokenType.VAR);
        VarToken idToken = this.expect(VarTokenType.IDENTITY);
        String varName = idToken.getText();
        this.expect(VarTokenType.COLON);
        if (this.isToken(VarTokenType.IDENTITY)) {
            varType = this.token.getText();
            this.consume();
        } else if (this.isToken(VarTokenType.TYPE)) {
            varType = this.token.getText();
            this.consume();
        } else {
            throw new LexException(this.token.getOffset(), "unexpected token:" + this.token.getType().name());
        }
        this.varNameToTypes.put(varName, new TypeParser().parse(varType));
    }

    public void scan() throws LexException, AstNotFoundException {
        this.nextToken();
        while (this.isToken(VarTokenType.VAR)) {
            this.varDecl();
        }
        this.expect(VarTokenType.EOI);
    }

    public void parse(String input) throws AstNotFoundException, LexException {
        this.lexer = new VarLexer(input);
        this.scan();
    }

    public Map<String, Type> getDeclaredVars() {
        return this.varNameToTypes;
    }
}

