/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.engine;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import kalang.AstNotFoundException;
import kalang.ast.ClassNode;
import kalang.compiler.AstLoader;
import kalang.compiler.JavaAstLoader;
import site.kason.tempera.engine.Configuration;
import site.kason.tempera.engine.DefaultTemplate;
import site.kason.tempera.engine.Template;
import site.kason.tempera.engine.TemplateAstLoader;
import site.kason.tempera.engine.TemplateLoader;
import site.kason.tempera.engine.TemplateNotFoundException;
import site.kason.tempera.engine.TemplateSource;
import site.kason.tempera.extension.Filter;
import site.kason.tempera.extension.Function;
import site.kason.tempera.model.RenderContext;
import site.kason.tempera.parser.Renderer;
import site.kason.tempera.parser.TemplateClassLoader;
import site.kason.tempera.parser.TemplateParser;

public class Engine
implements TemplateAstLoader {
    @Nullable
    private final TemplateLoader templateLoader;
    private final Map<String, Template> templateNameToCache = new HashMap<String, Template>();
    private final Map<TemplateSource, ClassNode> templateToAsts = new HashMap<TemplateSource, ClassNode>();
    private final TemplateClassLoader templateClassLoader;
    private final AstLoader astLoader;
    private final RenderContext renderContext = new RenderContext();
    private final String leftDelimiter;
    private final String rightDelimiter;

    public Engine() {
        this(Configuration.DEFAULT);
    }

    public Engine(Configuration conf) {
        this.templateLoader = conf.getTemplateLoader();
        ClassLoader classLoader = conf.getClassLoader();
        if (classLoader == null) {
            classLoader = Engine.class.getClassLoader();
        }
        this.astLoader = new JavaAstLoader(AstLoader.BASE_AST_LOADER, classLoader);
        String cachePath = conf.getCacheDir();
        File cacheDir = cachePath == null ? null : new File(cachePath);
        this.templateClassLoader = new TemplateClassLoader(classLoader, cacheDir);
        Map<String, Filter> filters = conf.getFilters();
        for (Map.Entry<String, Filter> entry : filters.entrySet()) {
            this.renderContext.addFilter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : conf.getFunctions().entrySet()) {
            this.renderContext.addFunction(entry.getKey(), (Function)entry.getValue());
        }
        String defaultFilterName = conf.getDefaultFilter();
        if (defaultFilterName != null && !defaultFilterName.isEmpty()) {
            Filter filter = filters.get(defaultFilterName);
            Objects.requireNonNull(filter, "filter not found:" + defaultFilterName);
            this.renderContext.addDefaultFilter(filter);
        }
        this.leftDelimiter = conf.getLeftDelimiter();
        this.rightDelimiter = conf.getRightDelimiter();
    }

    public Template compile(TemplateSource source) throws IOException {
        Template tpl;
        String cacheKey = source.getCacheKey();
        Template template = tpl = cacheKey == null ? null : this.templateNameToCache.get(cacheKey);
        if (tpl == null) {
            TemplateParser parser = new TemplateParser(source.getName(), source.getContent(), this.leftDelimiter, this.rightDelimiter, this, this.templateClassLoader);
            ClassNode ast = parser.getClassNode();
            this.templateToAsts.put(source, ast);
            Class<Renderer> clazz = parser.parse();
            tpl = new DefaultTemplate(clazz, this.renderContext);
            if (cacheKey != null) {
                this.templateNameToCache.put(cacheKey, tpl);
            }
        }
        return tpl;
    }

    public Template compile(String templateName) throws IOException {
        if (this.templateLoader == null) {
            throw new RuntimeException("no template loader found.");
        }
        TemplateSource source = this.templateLoader.load(templateName);
        return this.compile(source);
    }

    public Template compileInline(final String templateContent, final String templateName, final @Nullable String cacheKey) throws IOException {
        return this.compile(new TemplateSource(){

            @Override
            public String getContent() {
                return templateContent;
            }

            @Override
            public String getCacheKey() {
                return cacheKey;
            }

            @Override
            public String getPath() {
                return templateName;
            }

            @Override
            public String getName() {
                return templateName;
            }
        });
    }

    @Override
    public ClassNode loadTemplateAst(String templateName) throws IOException {
        TemplateLoader tplLoader = this.templateLoader;
        if (tplLoader == null) {
            throw new TemplateNotFoundException(templateName);
        }
        TemplateSource source = tplLoader.load(templateName);
        ClassNode ast = this.templateToAsts.get(source);
        if (ast != null) {
            return ast;
        }
        this.compile(source);
        ast = this.templateToAsts.get(source);
        assert (ast != null);
        return ast;
    }

    @Override
    public ClassNode loadAst(String className) throws AstNotFoundException {
        return this.astLoader.loadAst(className);
    }
}

