/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.lex.nfa;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import site.kason.tempera.lex.CharStream;
import site.kason.tempera.lex.nfa.MatchedResult;
import site.kason.tempera.lex.nfa.State;

public class NFA {
    private State startState;
    private List<State> acceptedStates;

    public NFA(State startState, List<State> acceptedStates) {
        this.startState = startState;
        this.acceptedStates = acceptedStates;
    }

    private static Set<State> getLambdaClosureStates(Set<State> states) {
        LinkedList<State> todos = new LinkedList<State>();
        todos.addAll(states);
        HashSet<State> results = new HashSet<State>();
        while (!todos.isEmpty()) {
            State s = (State)todos.poll();
            if (!results.add(s)) continue;
            State[] lambdaStates = s.getLambdaClosureStates();
            todos.addAll(Arrays.asList(lambdaStates));
        }
        return results;
    }

    public MatchedResult match(CharStream inputStream) {
        Set<State> currentStates = new HashSet<State>();
        currentStates.add(this.startState);
        currentStates = NFA.getLambdaClosureStates(currentStates);
        State[] matchedState = null;
        int inputOffset = 1;
        int matchedLen = 0;
        while (!currentStates.isEmpty() && inputStream.lookAhead(inputOffset) != -1) {
            Set<State> nextStates = new HashSet<State>();
            int input = inputStream.lookAhead(inputOffset++);
            for (State s : currentStates) {
                State[] nexts = s.getNextStates(input);
                nextStates.addAll(Arrays.asList(nexts));
            }
            State[] found = this.findAcceptedState(nextStates = NFA.getLambdaClosureStates(nextStates));
            if (found != null && found.length > 0) {
                matchedState = found;
                matchedLen = inputOffset - 1;
            }
            currentStates = nextStates;
        }
        int[] matchedChars = inputStream.consume(matchedLen);
        return matchedState != null ? new MatchedResult(matchedState, matchedLen, matchedChars) : null;
    }

    private State[] findAcceptedState(Set<State> states) {
        LinkedList<State> accepteds = new LinkedList<State>();
        for (State s : states) {
            if (!this.acceptedStates.contains(s)) continue;
            accepteds.add(s);
        }
        return accepteds.toArray(new State[accepteds.size()]);
    }

    public State[] getAcceptedStates() {
        State[] res = (State[])Array.newInstance(State.class, this.acceptedStates.size());
        return this.acceptedStates.toArray(res);
    }

    public State getStartState() {
        return this.startState;
    }

    public NFA or(NFA nfa2) {
        State newStartState = new State();
        newStartState.pushLambdaClosureState(this.getStartState());
        newStartState.pushLambdaClosureState(nfa2.getStartState());
        State[] acList1 = this.getAcceptedStates();
        State[] acList2 = nfa2.getAcceptedStates();
        ArrayList<State> newAcceptedStates = new ArrayList<State>(acList1.length + acList2.length);
        newAcceptedStates.addAll(Arrays.asList(acList1));
        newAcceptedStates.addAll(Arrays.asList(acList2));
        this.startState = newStartState;
        this.acceptedStates = newAcceptedStates;
        return this;
    }

    public NFA concat(NFA nfa2) {
        State[] accpetedState;
        State newStartState = this.getStartState();
        for (State ac : accpetedState = this.getAcceptedStates()) {
            ac.pushLambdaClosureState(nfa2.getStartState());
        }
        this.startState = newStartState;
        this.acceptedStates = Arrays.asList(nfa2.getAcceptedStates());
        return this;
    }

    public NFA closure() {
        State[] acList;
        for (State s : acList = this.getAcceptedStates()) {
            s.pushLambdaClosureState(this.startState);
            this.startState.pushLambdaClosureState(s);
        }
        return this;
    }
}

