/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.lex.nfa;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import site.kason.tempera.lex.nfa.CharMatcher;

public class State {
    private Map<Integer, Set<State>> nextStates = new HashMap<Integer, Set<State>>();
    private Map<CharMatcher, Set<State>> nextStatesByMatcher = new HashMap<CharMatcher, Set<State>>();
    private Set<State> closureStates = new HashSet<State>();

    public void pushNextState(int input, State nextState) {
        Set<State> list = this.nextStates.get(input);
        if (list == null) {
            list = new HashSet<State>();
            this.nextStates.put(input, list);
        }
        list.add(nextState);
    }

    public void pushNextState(CharMatcher matcher, State nextState) {
        Set<State> list = this.nextStatesByMatcher.get(matcher);
        if (list == null) {
            list = new HashSet<State>();
            this.nextStatesByMatcher.put(matcher, list);
        }
        list.add(nextState);
    }

    public State[] getNextStates(int input) {
        HashSet<State> result = new HashSet<State>();
        Set<State> list = this.nextStates.get(input);
        if (list != null) {
            result.addAll(list);
        }
        if (!this.nextStatesByMatcher.isEmpty()) {
            for (Map.Entry<CharMatcher, Set<State>> e : this.nextStatesByMatcher.entrySet()) {
                if (!e.getKey().isMatched(input)) continue;
                result.addAll((Collection)e.getValue());
            }
        }
        return result.toArray(new State[result.size()]);
    }

    public State[] getLambdaClosureStates() {
        return this.closureStates.toArray(new State[this.closureStates.size()]);
    }

    public void pushLambdaClosureState(State state) {
        this.closureStates.add(state);
    }
}

