/*
 * Decompiled with CFR 0.152.
 */
package site.kason.tempera.loader;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import site.kason.tempera.engine.TemplateLoader;
import site.kason.tempera.engine.TemplateNotFoundException;
import site.kason.tempera.engine.TemplateSource;
import site.kason.tempera.source.FileTemplateSource;

public class FileTemplateLoader
implements TemplateLoader {
    private final String[] suffix;
    private final String baseDir;
    private final String encoding;
    public static final String DEFAULT_ENCODING = "utf-8";

    public FileTemplateLoader(String baseDir, String[] suffix, String encoding) {
        this.suffix = suffix;
        this.baseDir = baseDir;
        this.encoding = encoding;
    }

    public FileTemplateLoader(String baseDir) {
        this(baseDir, new String[0], DEFAULT_ENCODING);
    }

    @Override
    public TemplateSource load(String templateName) throws TemplateNotFoundException {
        String[] sfx = this.suffix;
        if (sfx == null || sfx.length == 0) {
            sfx = new String[]{""};
        }
        for (String s : sfx) {
            File file = new File(this.baseDir, templateName.replace('.', '/') + s);
            if (!file.exists()) continue;
            return new FileTemplateSource(templateName, file, this.encoding);
        }
        throw new TemplateNotFoundException("template not found:" + templateName);
    }

    public String[] listTemplateNames() {
        File bd = new File(this.baseDir);
        LinkedList<String> names = new LinkedList<String>();
        this.searchTemplateNames("", bd, names);
        return names.toArray(new String[names.size()]);
    }

    private void searchTemplateNames(String namePrefix, File dir, Collection<String> results) {
        File[] files;
        block0: for (File f : files = dir.listFiles()) {
            if (f.isFile()) {
                String fn = f.getName();
                for (String sf : this.suffix) {
                    if (!fn.endsWith(sf)) continue;
                    results.add(namePrefix + fn.substring(0, fn.length() - sf.length()));
                    continue block0;
                }
                continue;
            }
            if (!f.isDirectory()) continue;
            this.searchTemplateNames(namePrefix + f.getName() + ".", f, results);
        }
    }
}

